/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftLecternView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;

public class LecternMenu
extends AbstractContainerMenu {
    private CraftLecternView bukkitEntity = null;
    private Player player;
    private static final int DATA_COUNT = 1;
    private static final int SLOT_COUNT = 1;
    public static final int BUTTON_PREV_PAGE = 1;
    public static final int BUTTON_NEXT_PAGE = 2;
    public static final int BUTTON_TAKE_BOOK = 3;
    public static final int BUTTON_PAGE_JUMP_RANGE_START = 100;
    private final Container lectern;
    private final ContainerData lecternData;

    @Override
    public CraftLecternView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLectern inventory = new CraftInventoryLectern(this.lectern);
        this.bukkitEntity = new CraftLecternView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public LecternMenu(int i, Inventory playerinventory) {
        this(i, new SimpleContainer(1), new SimpleContainerData(1), playerinventory);
    }

    public LecternMenu(int i, Container iinventory, ContainerData icontainerproperties, Inventory playerinventory) {
        super(MenuType.LECTERN, i);
        LecternMenu.checkContainerSize(iinventory, 1);
        LecternMenu.checkContainerDataCount(icontainerproperties, 1);
        this.lectern = iinventory;
        this.lecternData = icontainerproperties;
        this.addSlot(new Slot(iinventory, 0, 0, 0){

            @Override
            public void setChanged() {
                super.setChanged();
                LecternMenu.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(icontainerproperties);
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean clickMenuButton(net.minecraft.world.entity.player.Player entityhuman, int i) {
        if (i >= 100) {
            int j = i - 100;
            this.setData(0, j);
            return true;
        }
        switch (i) {
            case 1: {
                int k = this.lecternData.get(0);
                this.setData(0, k - 1);
                return true;
            }
            case 2: {
                int l = this.lecternData.get(0);
                this.setData(0, l + 1);
                return true;
            }
            case 3: {
                if (!entityhuman.mayBuild()) {
                    return false;
                }
                PlayerTakeLecternBookEvent event = new PlayerTakeLecternBookEvent(this.player, ((CraftInventoryLectern)this.getBukkitView().getTopInventory()).getHolder());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                ItemStack itemstack = this.lectern.removeItemNoUpdate(0);
                this.lectern.setChanged();
                if (!entityhuman.getInventory().add(itemstack)) {
                    entityhuman.drop(itemstack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack quickMoveStack(net.minecraft.world.entity.player.Player entityhuman, int i) {
        return ItemStack.EMPTY;
    }

    @Override
    public void setData(int i, int j) {
        super.setData(i, j);
        this.broadcastChanges();
    }

    @Override
    public boolean stillValid(net.minecraft.world.entity.player.Player entityhuman) {
        if (this.lectern instanceof LecternBlockEntity.LecternInventory && !((LecternBlockEntity.LecternInventory)this.lectern).getLectern().hasBook()) {
            return false;
        }
        if (!this.checkReachable) {
            return true;
        }
        return this.lectern.stillValid(entityhuman);
    }

    public ItemStack getBook() {
        return this.lectern.getItem(0);
    }

    public int getPage() {
        return this.lecternData.get(0);
    }
}

