/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    public final Fluid content;

    public BucketItem(Fluid fluidtype, Item.Properties item_info) {
        super(item_info);
        this.content = fluidtype;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        BlockHitResult movingobjectpositionblock = BucketItem.getPlayerPOVHitResult(world, entityhuman, this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if (movingobjectpositionblock.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (movingobjectpositionblock.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        Direction enumdirection = movingobjectpositionblock.getDirection();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        if (world.mayInteract(entityhuman, blockposition) && entityhuman.mayUseItemAt(blockposition1, enumdirection, itemstack)) {
            BlockPos blockposition2;
            if (this.content == Fluids.EMPTY) {
                BlockState iblockdata = world.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup ifluidsource = (BucketPickup)((Object)block);
                    ItemStack dummyFluid = ifluidsource.pickupBlock(entityhuman, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (dummyFluid.isEmpty()) {
                        return InteractionResult.FAIL;
                    }
                    PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((ServerLevel)world, entityhuman, blockposition, blockposition, movingobjectpositionblock.getDirection(), itemstack, dummyFluid.getItem(), enumhand);
                    if (event.isCancelled()) {
                        ((ServerPlayer)entityhuman).connection.send(new ClientboundBlockUpdatePacket(world, blockposition));
                        ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                        return InteractionResult.FAIL;
                    }
                    ItemStack itemstack1 = ifluidsource.pickupBlock(entityhuman, world, blockposition, iblockdata);
                    if (!itemstack1.isEmpty()) {
                        entityhuman.awardStat(Stats.ITEM_USED.get(this));
                        ifluidsource.getPickupSound().ifPresent(soundeffect -> entityhuman.playSound((SoundEvent)soundeffect, 1.0f, 1.0f));
                        world.gameEvent((Entity)entityhuman, GameEvent.FLUID_PICKUP, blockposition);
                        ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
                        if (!world.isClientSide()) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)entityhuman, itemstack1);
                        }
                        return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack2);
                    }
                }
                return InteractionResult.FAIL;
            }
            BlockState iblockdata1 = world.getBlockState(blockposition);
            BlockPos blockPos = blockposition2 = iblockdata1.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? blockposition : blockposition1;
            if (this.emptyContents(entityhuman, world, blockposition2, movingobjectpositionblock, movingobjectpositionblock.getDirection(), blockposition, itemstack, enumhand)) {
                this.checkExtraContent(entityhuman, world, itemstack, blockposition2);
                if (entityhuman instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)entityhuman, blockposition2, itemstack);
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(this));
                ItemStack itemstack3 = ItemUtils.createFilledResult(itemstack, entityhuman, BucketItem.getEmptySuccessItem(itemstack, entityhuman));
                return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack3);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public static ItemStack getEmptySuccessItem(ItemStack itemstack, Player entityhuman) {
        return !entityhuman.hasInfiniteMaterials() ? new ItemStack(Items.BUCKET) : itemstack;
    }

    @Override
    public void checkExtraContent(@Nullable LivingEntity entityliving, Level world, ItemStack itemstack, BlockPos blockposition) {
    }

    @Override
    public boolean emptyContents(@Nullable LivingEntity entityliving, Level world, BlockPos blockposition, @Nullable BlockHitResult movingobjectpositionblock) {
        return this.emptyContents(entityliving, world, blockposition, movingobjectpositionblock, null, null, null, InteractionHand.MAIN_HAND);
    }

    public boolean emptyContents(@Nullable LivingEntity entityliving, Level world, BlockPos blockposition, @Nullable BlockHitResult movingobjectpositionblock, Direction enumdirection, BlockPos clicked, ItemStack itemstack, InteractionHand enumhand) {
        ServerPlayer entityplayer;
        PlayerBucketEmptyEvent event;
        boolean flag4;
        LiquidBlockContainer ifluidcontainer;
        boolean flag1;
        Fluid fluidtype = this.content;
        if (!(fluidtype instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid fluidtypeflowing = (FlowingFluid)fluidtype;
        BlockState iblockdata = world.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        boolean flag = iblockdata.canBeReplaced(this.content);
        boolean bl = flag1 = entityliving != null && entityliving.isShiftKeyDown();
        boolean flag2 = flag || block instanceof LiquidBlockContainer && (ifluidcontainer = (LiquidBlockContainer)((Object)block)).canPlaceLiquid(entityliving, world, blockposition, iblockdata, this.content);
        boolean flag3 = flag2;
        boolean bl2 = flag4 = iblockdata.isAir() || flag3 && (!flag1 || movingobjectpositionblock == null);
        if (flag3 && entityliving instanceof ServerPlayer && (event = CraftEventFactory.callPlayerBucketEmptyEvent((ServerLevel)world, entityplayer = (ServerPlayer)entityliving, blockposition, clicked, enumdirection, itemstack, enumhand)).isCancelled()) {
            entityplayer.connection.send(new ClientboundBlockUpdatePacket(world, blockposition));
            entityplayer.getBukkitEntity().updateInventory();
            return false;
        }
        if (!flag4) {
            return movingobjectpositionblock != null && this.emptyContents(entityliving, world, movingobjectpositionblock.getBlockPos().relative(movingobjectpositionblock.getDirection()), null, enumdirection, clicked, itemstack, enumhand);
        }
        if (world.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int i = blockposition.getX();
            int j = blockposition.getY();
            int k = blockposition.getZ();
            world.playSound((Entity)entityliving, blockposition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.addParticle(ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer1 = (LiquidBlockContainer)((Object)block);
            if (this.content == Fluids.WATER) {
                ifluidcontainer1.placeLiquid(world, blockposition, iblockdata, fluidtypeflowing.getSource(false));
                this.playEmptySound(entityliving, world, blockposition);
                return true;
            }
        }
        if (!world.isClientSide() && flag && !iblockdata.liquid()) {
            world.destroyBlock(blockposition, true);
        }
        if (!world.setBlock(blockposition, this.content.defaultFluidState().createLegacyBlock(), 11) && !iblockdata.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(entityliving, world, blockposition);
        return true;
    }

    protected void playEmptySound(@Nullable LivingEntity entityliving, LevelAccessor generatoraccess, BlockPos blockposition) {
        SoundEvent soundeffect = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        generatoraccess.playSound(entityliving, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
        generatoraccess.gameEvent((Entity)entityliving, GameEvent.FLUID_PLACE, blockposition);
    }

    public Fluid getContent() {
        return this.content;
    }
}

