/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrossbowItem
extends ProjectileWeaponItem {
    private static final float MAX_CHARGE_DURATION = 1.25f;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;
    public static final float MOB_ARROW_POWER = 1.6f;
    private static final ChargingSounds DEFAULT_SOUNDS = new ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));

    public CrossbowItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        ChargedProjectiles var4 = var3.get(DataComponents.CHARGED_PROJECTILES);
        if (var4 != null && !var4.isEmpty()) {
            this.performShooting(var0, var1, var2, var3, CrossbowItem.getShootingPower(var4), 1.0f, null);
            return InteractionResult.CONSUME;
        }
        if (!var1.getProjectile(var3).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            var1.startUsingItem(var2);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static float getShootingPower(ChargedProjectiles var0) {
        if (var0.contains(Items.FIREWORK_ROCKET)) {
            return 1.6f;
        }
        return 3.15f;
    }

    @Override
    public boolean releaseUsing(ItemStack var0, Level var1, LivingEntity var2, int var3) {
        int var4 = this.getUseDuration(var0, var2) - var3;
        return CrossbowItem.getPowerForTime(var4, var0, var2) >= 1.0f && CrossbowItem.isCharged(var0);
    }

    private static boolean tryLoadProjectiles(LivingEntity var0, ItemStack var1) {
        List<ItemStack> var2 = CrossbowItem.draw(var1, var0.getProjectile(var1), var0);
        if (!var2.isEmpty()) {
            var1.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of(var2));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack var0) {
        ChargedProjectiles var1 = var0.getOrDefault(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        return !var1.isEmpty();
    }

    @Override
    protected void shootProjectile(LivingEntity var0, Projectile var1, int var2, float var3, float var4, float var5, @Nullable LivingEntity var6) {
        Vector3f var7;
        if (var6 != null) {
            double var8 = var6.getX() - var0.getX();
            double var10 = var6.getZ() - var0.getZ();
            double var12 = Math.sqrt(var8 * var8 + var10 * var10);
            double var14 = var6.getY(0.3333333333333333) - var1.getY() + var12 * (double)0.2f;
            var7 = CrossbowItem.getProjectileShotVector(var0, new Vec3(var8, var14, var10), var5);
        } else {
            Vec3 var8 = var0.getUpVector(1.0f);
            Quaternionf var9 = new Quaternionf().setAngleAxis((double)(var5 * ((float)Math.PI / 180)), var8.x, var8.y, var8.z);
            Vec3 var10 = var0.getViewVector(1.0f);
            var7 = var10.toVector3f().rotate((Quaternionfc)var9);
        }
        var1.shoot(var7.x(), var7.y(), var7.z(), var3, var4);
        float var8 = CrossbowItem.getShotPitch(var0.getRandom(), var2);
        var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEvents.CROSSBOW_SHOOT, var0.getSoundSource(), 1.0f, var8);
    }

    private static Vector3f getProjectileShotVector(LivingEntity var0, Vec3 var1, float var2) {
        Vec3 var5;
        Vector3f var3 = var1.toVector3f().normalize();
        Vector3f var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)var4.lengthSquared() <= 1.0E-7) {
            var5 = var0.getUpVector(1.0f);
            var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)var5.toVector3f());
        }
        var5 = new Vector3f((Vector3fc)var3).rotateAxis(1.5707964f, var4.x, var4.y, var4.z);
        return new Vector3f((Vector3fc)var3).rotateAxis(var2 * ((float)Math.PI / 180), ((Vector3f)var5).x, ((Vector3f)var5).y, ((Vector3f)var5).z);
    }

    @Override
    protected Projectile createProjectile(Level var0, LivingEntity var1, ItemStack var2, ItemStack var3, boolean var4) {
        if (var3.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity(var0, var3, var1, var1.getX(), var1.getEyeY() - (double)0.15f, var1.getZ(), true);
        }
        Projectile var5 = super.createProjectile(var0, var1, var2, var3, var4);
        if (var5 instanceof AbstractArrow) {
            AbstractArrow var6 = (AbstractArrow)var5;
            var6.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        }
        return var5;
    }

    @Override
    protected int getDurabilityUse(ItemStack var0) {
        return var0.is(Items.FIREWORK_ROCKET) ? 3 : 1;
    }

    public void performShooting(Level var0, LivingEntity var1, InteractionHand var2, ItemStack var3, float var4, float var5, @Nullable LivingEntity var6) {
        if (!(var0 instanceof ServerLevel)) {
            return;
        }
        ServerLevel var7 = (ServerLevel)var0;
        ChargedProjectiles var8 = var3.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        if (var8 == null || var8.isEmpty()) {
            return;
        }
        this.shoot(var7, var1, var2, var3, var8.getItems(), var4, var5, var1 instanceof Player, var6);
        if (var1 instanceof ServerPlayer) {
            ServerPlayer var9 = (ServerPlayer)var1;
            CriteriaTriggers.SHOT_CROSSBOW.trigger(var9, var3);
            var9.awardStat(Stats.ITEM_USED.get(var3.getItem()));
        }
    }

    private static float getShotPitch(RandomSource var0, int var1) {
        if (var1 == 0) {
            return 1.0f;
        }
        return CrossbowItem.getRandomShotPitch((var1 & 1) == 1, var0);
    }

    private static float getRandomShotPitch(boolean var0, RandomSource var1) {
        float var2 = var0 ? 0.63f : 0.43f;
        return 1.0f / (var1.nextFloat() * 0.5f + 1.8f) + var2;
    }

    @Override
    public void onUseTick(Level var0, LivingEntity var1, ItemStack var22, int var3) {
        if (!var0.isClientSide()) {
            ChargingSounds var4 = this.getChargingSounds(var22);
            float var5 = (float)(var22.getUseDuration(var1) - var3) / (float)CrossbowItem.getChargeDuration(var22, var1);
            if (var5 < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (var5 >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                var4.start().ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (SoundEvent)var2.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if (var5 >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                var4.mid().ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (SoundEvent)var2.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if (var5 >= 1.0f && !CrossbowItem.isCharged(var22) && CrossbowItem.tryLoadProjectiles(var1, var22)) {
                var4.end().ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (SoundEvent)var2.value(), var1.getSoundSource(), 1.0f, 1.0f / (var0.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack var0, LivingEntity var1) {
        return 72000;
    }

    public static int getChargeDuration(ItemStack var0, LivingEntity var1) {
        float var2 = EnchantmentHelper.modifyCrossbowChargingTime(var0, var1, 1.25f);
        return Mth.floor(var2 * 20.0f);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.CROSSBOW;
    }

    ChargingSounds getChargingSounds(ItemStack var0) {
        return EnchantmentHelper.pickHighestLevel(var0, EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
    }

    private static float getPowerForTime(int var0, ItemStack var1, LivingEntity var2) {
        float var3 = (float)var0 / (float)CrossbowItem.getChargeDuration(var1, var2);
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3;
    }

    @Override
    public boolean useOnRelease(ItemStack var0) {
        return var0.is(this);
    }

    @Override
    public int getDefaultProjectileRange() {
        return 8;
    }

    public record ChargingSounds(Optional<Holder<SoundEvent>> start, Optional<Holder<SoundEvent>> mid, Optional<Holder<SoundEvent>> end) {
        public static final Codec<ChargingSounds> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)SoundEvent.CODEC.optionalFieldOf("start").forGetter(ChargingSounds::start), (App)SoundEvent.CODEC.optionalFieldOf("mid").forGetter(ChargingSounds::mid), (App)SoundEvent.CODEC.optionalFieldOf("end").forGetter(ChargingSounds::end)).apply((Applicative)var0, ChargingSounds::new));
    }

    public static enum ChargeType implements StringRepresentable
    {
        NONE("none"),
        ARROW("arrow"),
        ROCKET("rocket");

        public static final Codec<ChargeType> CODEC;
        private final String name;

        private ChargeType(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ChargeType::values);
        }
    }
}

