/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class ExperienceBottleItem
extends Item
implements ProjectileItem {
    public ExperienceBottleItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
        if (var0 instanceof ServerLevel) {
            ServerLevel var4 = (ServerLevel)var0;
            Projectile.spawnProjectileFromRotation(ThrownExperienceBottle::new, var4, var3, var1, -20.0f, 0.7f, 1.0f);
        }
        var1.awardStat(Stats.ITEM_USED.get(this));
        var3.consume(1, var1);
        return InteractionResult.SUCCESS;
    }

    @Override
    public Projectile asProjectile(Level var0, Position var1, ItemStack var2, Direction var3) {
        return new ThrownExperienceBottle(var0, var1.x(), var1.y(), var1.z(), var2);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
    }
}

