/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<?>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();

    public SpawnEggItem(Item.Properties item_info) {
        super(item_info);
        TypedEntityData<EntityType<?>> typedentitydata = this.components().get(DataComponents.ENTITY_DATA);
        if (typedentitydata != null) {
            BY_ID.put(typedentitydata.type(), this);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        Level world = itemactioncontext.getLevel();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel worldserver = (ServerLevel)world;
        ItemStack itemstack = itemactioncontext.getItemInHand();
        BlockPos blockposition = itemactioncontext.getClickedPos();
        Direction enumdirection = itemactioncontext.getClickedFace();
        BlockState iblockdata = world.getBlockState(blockposition);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityType<?> entitytypes = this.getType(itemstack);
            if (entitytypes == null) {
                return InteractionResult.FAIL;
            }
            if (!worldserver.getServer().isSpawnerBlockEnabled()) {
                Player entityhuman = itemactioncontext.getPlayer();
                if (entityhuman instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                    entityplayer.sendSystemMessage(Component.translatable("advMode.notEnabled.spawner"));
                }
                return InteractionResult.FAIL;
            }
            spawner.setEntityId(entitytypes, world.getRandom());
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.BLOCK_CHANGE, blockposition);
            itemstack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockposition1 = iblockdata.getCollisionShape(world, blockposition).isEmpty() ? blockposition : blockposition.relative(enumdirection);
        return this.spawnMob(itemactioncontext.getPlayer(), itemstack, world, blockposition1, true, !Objects.equals(blockposition, blockposition1) && enumdirection == Direction.UP);
    }

    private InteractionResult spawnMob(@Nullable LivingEntity entityliving, ItemStack itemstack, Level world, BlockPos blockposition, boolean flag, boolean flag1) {
        EntityType<?> entitytypes = this.getType(itemstack);
        if (entitytypes == null) {
            return InteractionResult.FAIL;
        }
        if (!entitytypes.isAllowedInPeaceful() && world.getDifficulty() == Difficulty.PEACEFUL) {
            return InteractionResult.FAIL;
        }
        if (entitytypes.spawn((ServerLevel)world, itemstack, entityliving, blockposition, EntitySpawnReason.SPAWN_ITEM_USE, flag, flag1) != null) {
            itemstack.consume(1, entityliving);
            world.gameEvent((Entity)entityliving, GameEvent.ENTITY_PLACE, blockposition);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        BlockHitResult movingobjectpositionblock = SpawnEggItem.getPlayerPOVHitResult(world, entityhuman, ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionblock.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            if (!(world.getBlockState(blockposition).getBlock() instanceof LiquidBlock)) {
                return InteractionResult.PASS;
            }
            if (world.mayInteract(entityhuman, blockposition) && entityhuman.mayUseItemAt(blockposition, movingobjectpositionblock.getDirection(), itemstack)) {
                InteractionResult enuminteractionresult = this.spawnMob(entityhuman, itemstack, world, blockposition, false, false);
                if (enuminteractionresult == InteractionResult.SUCCESS) {
                    entityhuman.awardStat(Stats.ITEM_USED.get(this));
                }
                return enuminteractionresult;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean spawnsEntity(ItemStack itemstack, EntityType<?> entitytypes) {
        return Objects.equals(this.getType(itemstack), entitytypes);
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> entitytypes) {
        return BY_ID.get(entitytypes);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    @Nullable
    public EntityType<?> getType(ItemStack itemstack) {
        TypedEntityData<EntityType<?>> typedentitydata = itemstack.get(DataComponents.ENTITY_DATA);
        return typedentitydata != null ? typedentitydata.type() : null;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return Optional.ofNullable(this.components().get(DataComponents.ENTITY_DATA)).map(TypedEntityData::type).map(EntityType::requiredFeatures).orElseGet(FeatureFlagSet::of);
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player entityhuman, Mob entityinsentient, EntityType<? extends Mob> entitytypes, ServerLevel worldserver, Vec3 vec3d, ItemStack itemstack) {
        if (!this.spawnsEntity(itemstack, entitytypes)) {
            return Optional.empty();
        }
        Mob entityinsentient1 = entityinsentient instanceof AgeableMob ? ((AgeableMob)entityinsentient).getBreedOffspring(worldserver, (AgeableMob)entityinsentient) : entitytypes.create(worldserver, EntitySpawnReason.SPAWN_ITEM_USE);
        if (entityinsentient1 == null) {
            return Optional.empty();
        }
        entityinsentient1.setBaby(true);
        if (!entityinsentient1.isBaby()) {
            return Optional.empty();
        }
        entityinsentient1.snapTo(vec3d.x(), vec3d.y(), vec3d.z(), 0.0f, 0.0f);
        entityinsentient1.applyComponentsFromItemStack(itemstack);
        worldserver.addFreshEntityWithPassengers(entityinsentient1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        itemstack.consume(1, entityhuman);
        return Optional.of(entityinsentient1);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack itemstack, @Nullable Player entityhuman) {
        TypedEntityData<EntityType<?>> typedentitydata;
        if (entityhuman != null && entityhuman.getPermissionLevel() >= 2 && (typedentitydata = itemstack.get(DataComponents.ENTITY_DATA)) != null) {
            return typedentitydata.type().onlyOpCanSetNbt();
        }
        return false;
    }
}

