/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class CustomData {
    public static final CustomData EMPTY = new CustomData(new CompoundTag());
    public static final Codec<CompoundTag> COMPOUND_TAG_CODEC = Codec.withAlternative(CompoundTag.CODEC, TagParser.FLATTENED_CODEC);
    public static final Codec<CustomData> CODEC = COMPOUND_TAG_CODEC.xmap(CustomData::new, var0 -> var0.tag);
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, var0 -> var0.tag);
    private final CompoundTag tag;

    private CustomData(CompoundTag var0) {
        this.tag = var0;
    }

    public static CustomData of(CompoundTag var0) {
        return new CustomData(var0.copy());
    }

    public boolean matchedBy(CompoundTag var0) {
        return NbtUtils.compareNbt(var0, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> var0, ItemStack var1, Consumer<CompoundTag> var2) {
        CustomData var3 = var1.getOrDefault(var0, EMPTY).update(var2);
        if (var3.tag.isEmpty()) {
            var1.remove(var0);
        } else {
            var1.set(var0, var3);
        }
    }

    public static void set(DataComponentType<CustomData> var0, ItemStack var1, CompoundTag var2) {
        if (!var2.isEmpty()) {
            var1.set(var0, CustomData.of(var2));
        } else {
            var1.remove(var0);
        }
    }

    public CustomData update(Consumer<CompoundTag> var0) {
        CompoundTag var1 = this.tag.copy();
        var0.accept(var1);
        return new CustomData(var1);
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public CompoundTag copyTag() {
        return this.tag.copy();
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof CustomData) {
            CustomData var1 = (CustomData)var0;
            return this.tag.equals(var1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }
}

