/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClipContext {
    private final Vec3 from;
    private final Vec3 to;
    private final Block block;
    private final Fluid fluid;
    private final CollisionContext collisionContext;

    public ClipContext(Vec3 vec3d, Vec3 vec3d1, Block raytrace_blockcollisionoption, Fluid raytrace_fluidcollisionoption, Entity entity) {
        this(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, entity == null ? CollisionContext.empty() : CollisionContext.of(entity));
    }

    public ClipContext(Vec3 vec3d, Vec3 vec3d1, Block raytrace_blockcollisionoption, Fluid raytrace_fluidcollisionoption, CollisionContext voxelshapecollision) {
        this.from = vec3d;
        this.to = vec3d1;
        this.block = raytrace_blockcollisionoption;
        this.fluid = raytrace_fluidcollisionoption;
        this.collisionContext = voxelshapecollision;
    }

    public Vec3 getTo() {
        return this.to;
    }

    public Vec3 getFrom() {
        return this.from;
    }

    public VoxelShape getBlockShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return this.block.get(iblockdata, iblockaccess, blockposition, this.collisionContext);
    }

    public VoxelShape getFluidShape(FluidState fluid, BlockGetter iblockaccess, BlockPos blockposition) {
        return this.fluid.canPick(fluid) ? fluid.getShape(iblockaccess, blockposition) : Shapes.empty();
    }

    public static enum Block implements ShapeGetter
    {
        COLLIDER(BlockBehaviour.BlockStateBase::getCollisionShape),
        OUTLINE(BlockBehaviour.BlockStateBase::getShape),
        VISUAL(BlockBehaviour.BlockStateBase::getVisualShape),
        FALLDAMAGE_RESETTING((iblockdata, iblockaccess, blockposition, voxelshapecollision) -> {
            EntityCollisionContext voxelshapecollisionentity;
            if (iblockdata.is(BlockTags.FALL_DAMAGE_RESETTING)) {
                return Shapes.block();
            }
            if (voxelshapecollision instanceof EntityCollisionContext && (voxelshapecollisionentity = (EntityCollisionContext)voxelshapecollision).getEntity() != null && voxelshapecollisionentity.getEntity().getType() == EntityType.PLAYER) {
                if (iblockdata.is(Blocks.END_GATEWAY) || iblockdata.is(Blocks.END_PORTAL)) {
                    return Shapes.block();
                }
                if (iblockaccess instanceof ServerLevel) {
                    ServerLevel worldserver = (ServerLevel)iblockaccess;
                    if (iblockdata.is(Blocks.NETHER_PORTAL) && worldserver.getGameRules().getInt(GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY) == 0) {
                        return Shapes.block();
                    }
                }
            }
            return Shapes.empty();
        });

        private final ShapeGetter shapeGetter;

        private Block(ShapeGetter raytrace_c) {
            this.shapeGetter = raytrace_c;
        }

        @Override
        public VoxelShape get(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
            return this.shapeGetter.get(iblockdata, iblockaccess, blockposition, voxelshapecollision);
        }
    }

    public static enum Fluid {
        NONE(fluid -> false),
        SOURCE_ONLY(FluidState::isSource),
        ANY(fluid -> !fluid.isEmpty()),
        WATER(fluid -> fluid.is(FluidTags.WATER));

        private final Predicate<FluidState> canPick;

        private Fluid(Predicate<FluidState> predicate) {
            this.canPick = predicate;
        }

        public boolean canPick(FluidState fluid) {
            return this.canPick.test(fluid);
        }
    }

    public static interface ShapeGetter {
        public VoxelShape get(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);
    }
}

