/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.LinkedList;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(Entity entity, BlockState iblockdata, Level world, BlockPos blockposition) {
        if (iblockdata.getValue(BERRIES).booleanValue()) {
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(BERRIES, false))) {
                    return InteractionResult.SUCCESS;
                }
                if (entity instanceof Player) {
                    LinkedList<net.minecraft.world.item.ItemStack> dropped = new LinkedList<net.minecraft.world.item.ItemStack>();
                    Block.dropFromBlockInteractLootTable(worldserver, BuiltInLootTables.HARVEST_CAVE_VINE, iblockdata, world.getBlockEntity(blockposition), null, entity, (worldserver1, itemstack) -> dropped.add((net.minecraft.world.item.ItemStack)itemstack));
                    PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, blockposition, (Player)entity, InteractionHand.MAIN_HAND, dropped);
                    if (event.isCancelled()) {
                        return InteractionResult.SUCCESS;
                    }
                    for (ItemStack itemStack : event.getItemsHarvested()) {
                        Block.popResource(world, blockposition, CraftItemStack.asNMSCopy(itemStack));
                    }
                } else {
                    Block.dropFromBlockInteractLootTable(worldserver, BuiltInLootTables.HARVEST_CAVE_VINE, iblockdata, world.getBlockEntity(blockposition), null, entity, (worldserver1, itemstack) -> Block.popResource((Level)worldserver1, blockposition, itemstack));
                }
                float f = Mth.randomBetween(worldserver.random, 0.8f, 1.2f);
                worldserver.playSound((Entity)null, blockposition, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
                BlockState iblockdata1 = (BlockState)iblockdata.setValue(BERRIES, false);
                worldserver.setBlock(blockposition, iblockdata1, 2);
                worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, iblockdata1));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState iblockdata) {
        return iblockdata.hasProperty(BERRIES) && iblockdata.getValue(BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int i) {
        return iblockdata -> iblockdata.getValue(BlockStateProperties.BERRIES) != false ? i : 0;
    }
}

