/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class DetectorRailBlock
extends BaseRailBlock {
    public static final MapCodec<DetectorRailBlock> CODEC = DetectorRailBlock.simpleCodec(DetectorRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int PRESSED_CHECK_PERIOD = 20;

    public MapCodec<DetectorRailBlock> codec() {
        return CODEC;
    }

    public DetectorRailBlock(BlockBehaviour.Properties blockbase_info) {
        super(true, blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false)).setValue(SHAPE, RailShape.NORTH_SOUTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (!world.isClientSide() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(worldserver, blockposition, iblockdata);
        }
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) == false ? 0 : (enumdirection == Direction.UP ? 15 : 0);
    }

    private void checkPressed(Level world, BlockPos blockposition, BlockState iblockdata) {
        if (this.canSurvive(iblockdata, world, blockposition)) {
            boolean flag = iblockdata.getValue(POWERED);
            boolean flag1 = false;
            List<AbstractMinecart> list = this.getInteractingMinecartOfType(world, blockposition, AbstractMinecart.class, entity -> true);
            if (!list.isEmpty()) {
                flag1 = true;
            }
            if (flag != flag1) {
                org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, flag ? 15 : 0, flag1 ? 15 : 0);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (flag1 && !flag) {
                BlockState iblockdata1 = (BlockState)iblockdata.setValue(POWERED, true);
                world.setBlock(blockposition, iblockdata1, 3);
                this.updatePowerToConnected(world, blockposition, iblockdata1, true);
                world.updateNeighborsAt(blockposition, this);
                world.updateNeighborsAt(blockposition.below(), this);
                world.setBlocksDirty(blockposition, iblockdata, iblockdata1);
            }
            if (!flag1 && flag) {
                BlockState iblockdata2 = (BlockState)iblockdata.setValue(POWERED, false);
                world.setBlock(blockposition, iblockdata2, 3);
                this.updatePowerToConnected(world, blockposition, iblockdata2, false);
                world.updateNeighborsAt(blockposition, this);
                world.updateNeighborsAt(blockposition.below(), this);
                world.setBlocksDirty(blockposition, iblockdata, iblockdata2);
            }
            if (flag1) {
                world.scheduleTick(blockposition, this, 20);
            }
            world.updateNeighbourForOutputSignal(blockposition, this);
        }
    }

    protected void updatePowerToConnected(Level world, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        RailState minecarttracklogic = new RailState(world, blockposition, iblockdata);
        for (BlockPos blockposition1 : minecarttracklogic.getConnections()) {
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            world.neighborChanged(iblockdata1, blockposition1, iblockdata1.getBlock(), null, false);
        }
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            BlockState iblockdata2 = this.updateState(iblockdata, world, blockposition, flag);
            this.checkPressed(world, blockposition, iblockdata2);
        }
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            List<MinecartCommandBlock> list = this.getInteractingMinecartOfType(world, blockposition, MinecartCommandBlock.class, entity -> true);
            if (!list.isEmpty()) {
                return list.get(0).getCommandBlock().getSuccessCount();
            }
            List<AbstractMinecart> list1 = this.getInteractingMinecartOfType(world, blockposition, AbstractMinecart.class, EntitySelector.CONTAINER_ENTITY_SELECTOR);
            if (!list1.isEmpty()) {
                return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)list1.get(0)));
            }
        }
        return 0;
    }

    private <T extends AbstractMinecart> List<T> getInteractingMinecartOfType(Level world, BlockPos blockposition, Class<T> oclass, Predicate<Entity> predicate) {
        return world.getEntitiesOfClass(oclass, this.getSearchBB(blockposition), predicate);
    }

    private AABB getSearchBB(BlockPos blockposition) {
        double d0 = 0.2;
        return new AABB((double)blockposition.getX() + 0.2, blockposition.getY(), (double)blockposition.getZ() + 0.2, (double)(blockposition.getX() + 1) - 0.2, (double)(blockposition.getY() + 1) - 0.2, (double)(blockposition.getZ() + 1) - 0.2);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        RailShape blockpropertytrackposition = iblockdata.getValue(SHAPE);
        RailShape blockpropertytrackposition1 = this.rotate(blockpropertytrackposition, enumblockrotation);
        return (BlockState)iblockdata.setValue(SHAPE, blockpropertytrackposition1);
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        RailShape blockpropertytrackposition = iblockdata.getValue(SHAPE);
        RailShape blockpropertytrackposition1 = this.mirror(blockpropertytrackposition, enumblockmirror);
        return (BlockState)iblockdata.setValue(SHAPE, blockpropertytrackposition1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(SHAPE, POWERED, WATERLOGGED);
    }
}

