/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;

public class DragonEggBlock
extends FallingBlock {
    public static final MapCodec<DragonEggBlock> CODEC = DragonEggBlock.simpleCodec(DragonEggBlock::new);
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);

    public MapCodec<DragonEggBlock> codec() {
        return CODEC;
    }

    public DragonEggBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        this.teleport(iblockdata, world, blockposition);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman) {
        this.teleport(iblockdata, world, blockposition);
    }

    private void teleport(BlockState iblockdata, Level world, BlockPos blockposition) {
        WorldBorder worldborder = world.getWorldBorder();
        for (int i = 0; i < 1000; ++i) {
            BlockPos blockposition1 = blockposition.offset(world.random.nextInt(16) - world.random.nextInt(16), world.random.nextInt(8) - world.random.nextInt(8), world.random.nextInt(16) - world.random.nextInt(16));
            if (!world.getBlockState(blockposition1).isAir() || !worldborder.isWithinBounds(blockposition1) || world.isOutsideBuildHeight(blockposition1)) continue;
            org.bukkit.block.Block from = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            org.bukkit.block.Block to = world.getWorld().getBlockAt(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
            BlockFromToEvent event = new BlockFromToEvent(from, to);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            blockposition1 = new BlockPos(event.getToBlock().getX(), event.getToBlock().getY(), event.getToBlock().getZ());
            if (world.isClientSide()) {
                for (int j = 0; j < 128; ++j) {
                    double d0 = world.random.nextDouble();
                    float f = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = Mth.lerp(d0, (double)blockposition1.getX(), (double)blockposition.getX()) + (world.random.nextDouble() - 0.5) + 0.5;
                    double d2 = Mth.lerp(d0, (double)blockposition1.getY(), (double)blockposition.getY()) + world.random.nextDouble() - 0.5;
                    double d3 = Mth.lerp(d0, (double)blockposition1.getZ(), (double)blockposition.getZ()) + (world.random.nextDouble() - 0.5) + 0.5;
                    world.addParticle(ParticleTypes.PORTAL, d1, d2, d3, f, f1, f2);
                }
            } else {
                world.setBlock(blockposition1, iblockdata, 2);
                world.removeBlock(blockposition, false);
            }
            return;
        }
    }

    @Override
    protected int getDelayAfterPlace() {
        return 5;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    public int getDustColor(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return -16777216;
    }
}

