/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class DropperBlock
extends DispenserBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<DropperBlock> CODEC = DropperBlock.simpleCodec(DropperBlock::new);
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior(true);

    public MapCodec<DropperBlock> codec() {
        return CODEC;
    }

    public DropperBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected DispenseItemBehavior getDispenseMethod(Level world, net.minecraft.world.item.ItemStack itemstack) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new DropperBlockEntity(blockposition, iblockdata);
    }

    @Override
    public void dispenseFrom(ServerLevel worldserver, BlockState iblockdata, BlockPos blockposition) {
        DispenserBlockEntity tileentitydispenser = worldserver.getBlockEntity(blockposition, BlockEntityType.DROPPER).orElse(null);
        if (tileentitydispenser == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)blockposition);
        } else {
            BlockSource sourceblock = new BlockSource(worldserver, blockposition, iblockdata, tileentitydispenser);
            int i = tileentitydispenser.getRandomSlot(worldserver.random);
            if (i < 0) {
                worldserver.levelEvent(1001, blockposition, 0);
            } else {
                net.minecraft.world.item.ItemStack itemstack = tileentitydispenser.getItem(i);
                if (!itemstack.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1;
                    Direction enumdirection = (Direction)worldserver.getBlockState(blockposition).getValue(FACING);
                    Container iinventory = HopperBlockEntity.getContainerAt(worldserver, blockposition.relative(enumdirection));
                    if (iinventory == null) {
                        itemstack1 = DISPENSE_BEHAVIOUR.dispense(sourceblock, itemstack);
                    } else {
                        CraftItemStack oitemstack = CraftItemStack.asCraftMirror(itemstack.copyWithCount(1));
                        Inventory destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : iinventory.getOwner().getInventory();
                        InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentitydispenser.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        itemstack1 = HopperBlockEntity.addItem(tileentitydispenser, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection.getOpposite());
                        if (event.getItem().equals((Object)oitemstack) && itemstack1.isEmpty()) {
                            itemstack1 = itemstack.copy();
                            itemstack1.shrink(1);
                        } else {
                            itemstack1 = itemstack.copy();
                        }
                    }
                    tileentitydispenser.setItem(i, itemstack1);
                }
            }
        }
    }
}

