/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NetherrackBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<NetherrackBlock> CODEC = NetherrackBlock.simpleCodec(NetherrackBlock::new);

    public MapCodec<NetherrackBlock> codec() {
        return CODEC;
    }

    public NetherrackBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        if (!var0.getBlockState(var1.above()).propagatesSkylightDown()) {
            return false;
        }
        for (BlockPos var4 : BlockPos.betweenClosed(var1.offset(-1, -1, -1), var1.offset(1, 1, 1))) {
            if (!var0.getBlockState(var4).is(BlockTags.NYLIUM)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        boolean var4 = false;
        boolean var5 = false;
        for (BlockPos var7 : BlockPos.betweenClosed(var2.offset(-1, -1, -1), var2.offset(1, 1, 1))) {
            BlockState var8 = var0.getBlockState(var7);
            if (var8.is(Blocks.WARPED_NYLIUM)) {
                var5 = true;
            }
            if (var8.is(Blocks.CRIMSON_NYLIUM)) {
                var4 = true;
            }
            if (!var5 || !var4) continue;
            break;
        }
        if (var5 && var4) {
            var0.setBlock(var2, var1.nextBoolean() ? Blocks.WARPED_NYLIUM.defaultBlockState() : Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        } else if (var5) {
            var0.setBlock(var2, Blocks.WARPED_NYLIUM.defaultBlockState(), 3);
        } else if (var4) {
            var0.setBlock(var2, Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        }
    }

    @Override
    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

