/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final MapCodec<PointedDripstoneBlock> CODEC = PointedDripstoneBlock.simpleCodec(PointedDripstoneBlock::new);
    public static final EnumProperty<Direction> TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.5f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final VoxelShape SHAPE_TIP_MERGE = Block.column(6.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_TIP_UP = Block.column(6.0, 0.0, 11.0);
    private static final VoxelShape SHAPE_TIP_DOWN = Block.column(6.0, 5.0, 16.0);
    private static final VoxelShape SHAPE_FRUSTUM = Block.column(8.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_MIDDLE = Block.column(10.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_BASE = Block.column(12.0, 0.0, 16.0);
    private static final double STALACTITE_DRIP_START_PIXEL = SHAPE_TIP_DOWN.min(Direction.Axis.Y);
    private static final float MAX_HORIZONTAL_OFFSET = (float)SHAPE_BASE.min(Direction.Axis.X);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.column(4.0, 0.0, 16.0);

    public MapCodec<PointedDripstoneBlock> codec() {
        return CODEC;
    }

    public PointedDripstoneBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TIP_DIRECTION, Direction.UP)).setValue(THICKNESS, DripstoneThickness.TIP)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(TIP_DIRECTION, THICKNESS, WATERLOGGED);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, iblockdata.getValue(TIP_DIRECTION));
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        if (enumdirection != Direction.UP && enumdirection != Direction.DOWN) {
            return iblockdata;
        }
        Direction enumdirection1 = iblockdata.getValue(TIP_DIRECTION);
        if (enumdirection1 == Direction.DOWN && scheduledtickaccess.getBlockTicks().hasScheduledTick(blockposition, this)) {
            return iblockdata;
        }
        if (enumdirection == enumdirection1.getOpposite() && !this.canSurvive(iblockdata, iworldreader, blockposition)) {
            if (enumdirection1 == Direction.DOWN) {
                scheduledtickaccess.scheduleTick(blockposition, this, 2);
            } else {
                scheduledtickaccess.scheduleTick(blockposition, this, 1);
            }
            return iblockdata;
        }
        boolean flag = iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(iworldreader, blockposition, enumdirection1, flag);
        return (BlockState)iblockdata.setValue(THICKNESS, dripstonethickness);
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        if (!world.isClientSide()) {
            ServerLevel worldserver;
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            if (world instanceof ServerLevel && iprojectile.mayInteract(worldserver = (ServerLevel)world, blockposition) && iprojectile.mayBreak(worldserver) && iprojectile instanceof ThrownTrident && iprojectile.getDeltaMovement().length() > 0.6) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState())) {
                    return;
                }
                world.destroyBlock(blockposition, true);
            }
        }
    }

    @Override
    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, Entity entity, double d0) {
        if (iblockdata.getValue(TIP_DIRECTION) == Direction.UP && iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(d0 + 2.5, 2.0f, world.damageSources().stalagmite().directBlock(world, blockposition));
        } else {
            super.fallOn(world, iblockdata, blockposition, entity, d0);
        }
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        float f;
        if (PointedDripstoneBlock.canDrip(iblockdata) && (f = randomsource.nextFloat()) <= 0.12f) {
            PointedDripstoneBlock.getFluidAboveStalactite(world, blockposition, iblockdata).filter(pointeddripstoneblock_a -> f < 0.02f || PointedDripstoneBlock.canFillCauldron(pointeddripstoneblock_a.fluid)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, blockposition, iblockdata, pointeddripstoneblock_a.fluid));
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (PointedDripstoneBlock.isStalagmite(iblockdata) && !this.canSurvive(iblockdata, worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        } else {
            PointedDripstoneBlock.spawnFallingStalactite(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        PointedDripstoneBlock.maybeTransferFluid(iblockdata, worldserver, blockposition, randomsource.nextFloat());
        if (randomsource.nextFloat() < 0.011377778f && PointedDripstoneBlock.isStalactiteStartPos(iblockdata, worldserver, blockposition)) {
            PointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(iblockdata, worldserver, blockposition, randomsource);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, float f) {
        Optional<FluidInfo> optional;
        if ((f <= 0.17578125f || f <= 0.05859375f) && PointedDripstoneBlock.isStalactiteStartPos(iblockdata, worldserver, blockposition) && !(optional = PointedDripstoneBlock.getFluidAboveStalactite(worldserver, blockposition, iblockdata)).isEmpty()) {
            BlockPos blockposition1;
            float f1;
            Fluid fluidtype = optional.get().fluid;
            if (fluidtype == Fluids.WATER) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != Fluids.LAVA) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (f < f1 && (blockposition1 = PointedDripstoneBlock.findTip(iblockdata, worldserver, blockposition, 11, false)) != null) {
                if (optional.get().sourceState.is(Blocks.MUD) && fluidtype == Fluids.WATER) {
                    BlockState iblockdata1 = Blocks.CLAY.defaultBlockState();
                    worldserver.setBlockAndUpdate(optional.get().pos, iblockdata1);
                    Block.pushEntitiesUp(optional.get().sourceState, iblockdata1, worldserver, optional.get().pos);
                    worldserver.gameEvent(GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.Context.of(iblockdata1));
                    worldserver.levelEvent(1504, blockposition1, 0);
                } else {
                    BlockPos blockposition2 = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip(worldserver, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        worldserver.levelEvent(1504, blockposition1, 0);
                        int i = blockposition1.getY() - blockposition2.getY();
                        int j = 50 + i;
                        BlockState iblockdata2 = worldserver.getBlockState(blockposition2);
                        worldserver.scheduleTick(blockposition2, iblockdata2.getBlock(), j);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction enumdirection;
        BlockPos blockposition;
        Level generatoraccess = blockactioncontext.getLevel();
        Direction enumdirection1 = PointedDripstoneBlock.calculateTipDirection(generatoraccess, blockposition = blockactioncontext.getClickedPos(), enumdirection = blockactioncontext.getNearestLookingVerticalDirection().getOpposite());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !blockactioncontext.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(generatoraccess, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, enumdirection1)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, generatoraccess.getFluidState(blockposition).getType() == Fluids.WATER);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState iblockdata) {
        return Shapes.empty();
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        VoxelShape voxelshape1 = switch (iblockdata.getValue(THICKNESS)) {
            case DripstoneThickness.TIP_MERGE -> SHAPE_TIP_MERGE;
            case DripstoneThickness.TIP -> iblockdata.getValue(TIP_DIRECTION) == Direction.DOWN ? SHAPE_TIP_DOWN : SHAPE_TIP_UP;
            case DripstoneThickness.FRUSTUM -> SHAPE_FRUSTUM;
            case DripstoneThickness.MIDDLE -> SHAPE_MIDDLE;
            case DripstoneThickness.BASE -> SHAPE_BASE;
            default -> throw new MatchException(null, null);
        };
        return voxelshape1.move(iblockdata.getOffset(blockposition));
    }

    @Override
    protected boolean isCollisionShapeFullBlock(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return false;
    }

    @Override
    protected float getMaxHorizontalOffset() {
        return MAX_HORIZONTAL_OFFSET;
    }

    @Override
    public void onBrokenAfterFall(Level world, BlockPos blockposition, FallingBlockEntity entityfallingblock) {
        if (!entityfallingblock.isSilent()) {
            world.levelEvent(1045, blockposition, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        BlockState iblockdata1 = iblockdata;
        while (PointedDripstoneBlock.isStalactite(iblockdata1)) {
            FallingBlockEntity entityfallingblock = FallingBlockEntity.fall(worldserver, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.isTip(iblockdata1, true)) {
                int i = Math.max(1 + blockposition.getY() - blockposition_mutableblockposition.getY(), 6);
                float f = 1.0f * (float)i;
                entityfallingblock.setHurtsEntities(f, 40);
                break;
            }
            blockposition_mutableblockposition.move(Direction.DOWN);
            iblockdata1 = worldserver.getBlockState(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        BlockState iblockdata3;
        BlockPos blockposition1;
        BlockState iblockdata2;
        BlockState iblockdata1 = worldserver.getBlockState(blockposition.above(1));
        if (PointedDripstoneBlock.canGrow(iblockdata1, iblockdata2 = worldserver.getBlockState(blockposition.above(2))) && (blockposition1 = PointedDripstoneBlock.findTip(iblockdata, worldserver, blockposition, 7, false)) != null && PointedDripstoneBlock.canDrip(iblockdata3 = worldserver.getBlockState(blockposition1)) && PointedDripstoneBlock.canTipGrow(iblockdata3, worldserver, blockposition1)) {
            if (randomsource.nextBoolean()) {
                PointedDripstoneBlock.grow(worldserver, blockposition1, Direction.DOWN);
            } else {
                PointedDripstoneBlock.growStalagmiteBelow(worldserver, blockposition1);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel worldserver, BlockPos blockposition) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (int i = 0; i < 10; ++i) {
            blockposition_mutableblockposition.move(Direction.DOWN);
            BlockState iblockdata = worldserver.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata.getFluidState().isEmpty()) {
                return;
            }
            if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, Direction.UP) && PointedDripstoneBlock.canTipGrow(iblockdata, worldserver, blockposition_mutableblockposition)) {
                PointedDripstoneBlock.grow(worldserver, blockposition_mutableblockposition, Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.isValidPointedDripstonePlacement(worldserver, blockposition_mutableblockposition, Direction.UP) && !worldserver.isWaterAt((BlockPos)blockposition_mutableblockposition.below())) {
                PointedDripstoneBlock.grow(worldserver, (BlockPos)blockposition_mutableblockposition.below(), Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.canDripThrough(worldserver, blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void grow(ServerLevel worldserver, BlockPos blockposition, Direction enumdirection) {
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        BlockState iblockdata = worldserver.getBlockState(blockposition1);
        if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, enumdirection.getOpposite())) {
            PointedDripstoneBlock.createMergedTips(iblockdata, worldserver, blockposition1);
        } else if (iblockdata.isAir() || iblockdata.is(Blocks.WATER)) {
            PointedDripstoneBlock.createDripstone(worldserver, blockposition1, enumdirection, DripstoneThickness.TIP, blockposition);
        }
    }

    private static void createDripstone(LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection, DripstoneThickness dripstonethickness, BlockPos source) {
        BlockState iblockdata = (BlockState)((BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(TIP_DIRECTION, enumdirection)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, generatoraccess.getFluidState(blockposition).getType() == Fluids.WATER);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void createMergedTips(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition) {
        BlockPos blockposition1;
        BlockPos blockposition2;
        if (iblockdata.getValue(TIP_DIRECTION) == Direction.UP) {
            blockposition2 = blockposition;
            blockposition1 = blockposition.above();
        } else {
            blockposition1 = blockposition;
            blockposition2 = blockposition.below();
        }
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition1, Direction.DOWN, DripstoneThickness.TIP_MERGE, blockposition);
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition2, Direction.UP, DripstoneThickness.TIP_MERGE, blockposition);
    }

    public static void spawnDripParticle(Level world, BlockPos blockposition, BlockState iblockdata) {
        PointedDripstoneBlock.getFluidAboveStalactite(world, blockposition, iblockdata).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, blockposition, iblockdata, pointeddripstoneblock_a.fluid));
    }

    private static void spawnDripParticle(Level world, BlockPos blockposition, BlockState iblockdata, Fluid fluidtype) {
        Vec3 vec3d = iblockdata.getOffset(blockposition);
        double d0 = 0.0625;
        double d1 = (double)blockposition.getX() + 0.5 + vec3d.x;
        double d2 = (double)blockposition.getY() + STALACTITE_DRIP_START_PIXEL - 0.0625;
        double d3 = (double)blockposition.getZ() + 0.5 + vec3d.z;
        Fluid fluidtype1 = PointedDripstoneBlock.getDripFluid(world, fluidtype);
        SimpleParticleType particleparam = fluidtype1.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        world.addParticle(particleparam, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, int i, boolean flag) {
        if (PointedDripstoneBlock.isTip(iblockdata, flag)) {
            return blockposition;
        }
        Direction enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(generatoraccess, blockposition, enumdirection.getAxisDirection(), bipredicate, iblockdata1 -> PointedDripstoneBlock.isTip(iblockdata1, flag), i).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader iworldreader, BlockPos blockposition, Direction enumdirection) {
        Direction enumdirection1;
        if (PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, enumdirection)) {
            enumdirection1 = enumdirection;
        } else {
            if (!PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, enumdirection.getOpposite())) {
                return null;
            }
            enumdirection1 = enumdirection.getOpposite();
        }
        return enumdirection1;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader iworldreader, BlockPos blockposition, Direction enumdirection, boolean flag) {
        Direction enumdirection1 = enumdirection.getOpposite();
        BlockState iblockdata = iworldreader.getBlockState(blockposition.relative(enumdirection));
        if (PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection1)) {
            return !flag && iblockdata.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState iblockdata1 = iworldreader.getBlockState(blockposition.relative(enumdirection1));
            return !PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata1, enumdirection) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState iblockdata) {
        return PointedDripstoneBlock.isStalactite(iblockdata) && iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP && iblockdata.getValue(WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition) {
        Direction enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        BlockState iblockdata1 = worldserver.getBlockState(blockposition1);
        return !iblockdata1.getFluidState().isEmpty() ? false : (iblockdata1.isAir() ? true : PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata1, enumdirection.getOpposite()));
    }

    private static Optional<BlockPos> findRootBlock(Level world, BlockPos blockposition, BlockState iblockdata, int i) {
        Direction enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, enumdirection.getOpposite().getAxisDirection(), bipredicate, iblockdata1 -> !iblockdata1.is(Blocks.POINTED_DRIPSTONE), i);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader iworldreader, BlockPos blockposition, Direction enumdirection) {
        BlockPos blockposition1 = blockposition.relative(enumdirection.getOpposite());
        BlockState iblockdata = iworldreader.getBlockState(blockposition1);
        return iblockdata.isFaceSturdy(iworldreader, blockposition1, enumdirection) || PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection);
    }

    private static boolean isTip(BlockState iblockdata, boolean flag) {
        if (!iblockdata.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || flag && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState iblockdata, Direction enumdirection) {
        return PointedDripstoneBlock.isTip(iblockdata, false) && iblockdata.getValue(TIP_DIRECTION) == enumdirection;
    }

    private static boolean isStalactite(BlockState iblockdata) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState iblockdata) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return PointedDripstoneBlock.isStalactite(iblockdata) && !iworldreader.getBlockState(blockposition.above()).is(Blocks.POINTED_DRIPSTONE);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState iblockdata, Direction enumdirection) {
        return iblockdata.is(Blocks.POINTED_DRIPSTONE) && iblockdata.getValue(TIP_DIRECTION) == enumdirection;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level world, BlockPos blockposition, Fluid fluidtype) {
        Predicate<BlockState> predicate = iblockdata -> iblockdata.getBlock() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.getBlock()).canReceiveStalactiteDrip(fluidtype);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, Direction.DOWN.getAxisDirection(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(Level world, BlockPos blockposition) {
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, Direction.UP.getAxisDirection(), bipredicate, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(ServerLevel worldserver, BlockPos blockposition) {
        return PointedDripstoneBlock.getFluidAboveStalactite(worldserver, blockposition, worldserver.getBlockState(blockposition)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.fluid).filter(PointedDripstoneBlock::canFillCauldron).orElse(Fluids.EMPTY);
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level world, BlockPos blockposition, BlockState iblockdata) {
        return !PointedDripstoneBlock.isStalactite(iblockdata) ? Optional.empty() : PointedDripstoneBlock.findRootBlock(world, blockposition, iblockdata, 11).map(blockposition1 -> {
            BlockPos blockposition2 = blockposition1.above();
            BlockState iblockdata1 = world.getBlockState(blockposition2);
            Fluid fluidtype = iblockdata1.is(Blocks.MUD) && !world.dimensionType().ultraWarm() ? Fluids.WATER : world.getFluidState(blockposition2).getType();
            return new FluidInfo(blockposition2, fluidtype, iblockdata1);
        });
    }

    private static boolean canFillCauldron(Fluid fluidtype) {
        return fluidtype == Fluids.LAVA || fluidtype == Fluids.WATER;
    }

    private static boolean canGrow(BlockState iblockdata, BlockState iblockdata1) {
        return iblockdata.is(Blocks.DRIPSTONE_BLOCK) && iblockdata1.is(Blocks.WATER) && iblockdata1.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level world, Fluid fluidtype) {
        return fluidtype.isSame(Fluids.EMPTY) ? (world.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER) : fluidtype;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor generatoraccess, BlockPos blockposition, Direction.AxisDirection enumdirection_enumaxisdirection, BiPredicate<BlockPos, BlockState> bipredicate, Predicate<BlockState> predicate, int i) {
        Direction enumdirection = Direction.get(enumdirection_enumaxisdirection, Direction.Axis.Y);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (int j = 1; j < i; ++j) {
            blockposition_mutableblockposition.move(enumdirection);
            BlockState iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition);
            if (predicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.immutable());
            }
            if (!generatoraccess.isOutsideBuildHeight(blockposition_mutableblockposition.getY()) && bipredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        if (iblockdata.isAir()) {
            return true;
        }
        if (iblockdata.isSolidRender()) {
            return false;
        }
        if (!iblockdata.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = iblockdata.getCollisionShape(iblockaccess, blockposition);
        return !Shapes.joinIsNotEmpty(REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, voxelshape, BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

