/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> CODEC = SculkBlock.simpleCodec(SculkBlock::new);

    public MapCodec<SculkBlock> codec() {
        return CODEC;
    }

    public SculkBlock(BlockBehaviour.Properties blockbase_info) {
        super(ConstantInt.of(1), blockbase_info);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor sculkspreader_a, LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
        int i = sculkspreader_a.getCharge();
        if (i != 0 && randomsource.nextInt(sculkspreader.chargeDecayRate()) == 0) {
            BlockPos blockposition1 = sculkspreader_a.getPos();
            boolean flag1 = blockposition1.closerThan(blockposition, sculkspreader.noGrowthRadius());
            if (!flag1 && SculkBlock.canPlaceGrowth(generatoraccess, blockposition1)) {
                BlockState iblockdata;
                BlockPos blockposition2;
                int j = sculkspreader.growthSpawnCost();
                if (randomsource.nextInt(j) < i && CraftEventFactory.handleBlockSpreadEvent(generatoraccess, blockposition, blockposition2 = blockposition1.above(), iblockdata = this.getRandomGrowthState(generatoraccess, blockposition2, randomsource, sculkspreader.isWorldGeneration()), 3)) {
                    generatoraccess.playSound(null, blockposition1, iblockdata.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return randomsource.nextInt(sculkspreader.additionalDecayRate()) != 0 ? i : i - (flag1 ? 1 : SculkBlock.getDecayPenalty(sculkspreader, blockposition1, blockposition, i));
        }
        return i;
    }

    private static int getDecayPenalty(SculkSpreader sculkspreader, BlockPos blockposition, BlockPos blockposition1, int i) {
        int j = sculkspreader.noGrowthRadius();
        float f = Mth.square((float)Math.sqrt(blockposition.distSqr(blockposition1)) - (float)j);
        int k = Mth.square(24 - j);
        float f1 = Math.min(1.0f, f / (float)k);
        return Math.max(1, (int)((float)i * f1 * 0.5f));
    }

    private BlockState getRandomGrowthState(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, boolean flag) {
        BlockState iblockdata = randomsource.nextInt(11) == 0 ? (BlockState)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, flag) : Blocks.SCULK_SENSOR.defaultBlockState();
        return iblockdata.hasProperty(BlockStateProperties.WATERLOGGED) && !generatoraccess.getFluidState(blockposition).isEmpty() ? (BlockState)iblockdata.setValue(BlockStateProperties.WATERLOGGED, true) : iblockdata;
    }

    private static boolean canPlaceGrowth(LevelAccessor generatoraccess, BlockPos blockposition) {
        BlockState iblockdata = generatoraccess.getBlockState(blockposition.above());
        if (iblockdata.isAir() || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().is(Fluids.WATER)) {
            int i = 0;
            for (BlockPos blockposition1 : BlockPos.betweenClosed(blockposition.offset(-4, 0, -4), blockposition.offset(4, 2, 4))) {
                BlockState iblockdata1 = generatoraccess.getBlockState(blockposition1);
                if (iblockdata1.is(Blocks.SCULK_SENSOR) || iblockdata1.is(Blocks.SCULK_SHRIEKER)) {
                    ++i;
                }
                if (i <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

