/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class TripWireBlock
extends Block {
    public static final MapCodec<TripWireBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(blocktripwire -> blocktripwire.hook), TripWireBlock.propertiesCodec()).apply((Applicative)instance, TripWireBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = CrossCollisionBlock.PROPERTY_BY_DIRECTION;
    private static final VoxelShape SHAPE_ATTACHED = Block.column(16.0, 1.0, 2.5);
    private static final VoxelShape SHAPE_NOT_ATTACHED = Block.column(16.0, 0.0, 8.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<TripWireBlock> codec() {
        return CODEC;
    }

    public TripWireBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = block;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return iblockdata.getValue(ATTACHED) != false ? SHAPE_ATTACHED : SHAPE_NOT_ATTACHED;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Level iblockaccess = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(iblockaccess.getBlockState(blockposition.north()), Direction.NORTH))).setValue(EAST, this.shouldConnectTo(iblockaccess.getBlockState(blockposition.east()), Direction.EAST))).setValue(SOUTH, this.shouldConnectTo(iblockaccess.getBlockState(blockposition.south()), Direction.SOUTH))).setValue(WEST, this.shouldConnectTo(iblockaccess.getBlockState(blockposition.west()), Direction.WEST));
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection.getAxis().isHorizontal() ? (BlockState)iblockdata.setValue(PROPERTY_BY_DIRECTION.get(enumdirection), this.shouldConnectTo(iblockdata1, enumdirection)) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            this.updateSource(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag) {
            this.updateSource(worldserver, blockposition, (BlockState)iblockdata.setValue(POWERED, true));
        }
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (!world.isClientSide() && !entityhuman.getMainHandItem().isEmpty() && entityhuman.getMainHandItem().is(Items.SHEARS)) {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(DISARMED, true), 260);
            world.gameEvent((net.minecraft.world.entity.Entity)entityhuman, GameEvent.SHEAR, blockposition);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    private void updateSource(Level world, BlockPos blockposition, BlockState iblockdata) {
        block0: for (Direction enumdirection : new Direction[]{Direction.SOUTH, Direction.WEST}) {
            for (int i = 1; i < 42; ++i) {
                BlockPos blockposition1 = blockposition.relative(enumdirection, i);
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                if (iblockdata1.is(this.hook)) {
                    if (iblockdata1.getValue(TripWireHookBlock.FACING) != enumdirection.getOpposite()) continue block0;
                    TripWireHookBlock.calculateState(world, blockposition1, iblockdata1, false, true, i, iblockdata);
                    continue block0;
                }
                if (!iblockdata1.is(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        return iblockdata.getShape(iblockaccess, blockposition);
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (!world.isClientSide() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(world, blockposition, List.of(entity));
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.getBlockState(blockposition).getValue(POWERED).booleanValue()) {
            this.checkPressed(worldserver, blockposition);
        }
    }

    private void checkPressed(Level world, BlockPos blockposition) {
        BlockState iblockdata = world.getBlockState(blockposition);
        List<net.minecraft.world.entity.Entity> list = world.getEntities(null, iblockdata.getShape(world, blockposition).bounds().move(blockposition));
        this.checkPressed(world, blockposition, list);
    }

    private void checkPressed(Level world, BlockPos blockposition, List<? extends net.minecraft.world.entity.Entity> list) {
        BlockState iblockdata = world.getBlockState(blockposition);
        boolean flag = iblockdata.getValue(POWERED);
        boolean flag1 = false;
        if (!list.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag != flag1 && flag1 && iblockdata.getValue(ATTACHED).booleanValue()) {
            CraftWorld bworld = world.getWorld();
            PluginManager pluginManager = world.getCraftServer().getPluginManager();
            org.bukkit.block.Block block = bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity entity : list) {
                PlayerInteractEvent cancellable;
                if (entity == null) continue;
                if (entity instanceof Player) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
                } else {
                    if (!(entity instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), block);
                    pluginManager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag1 != flag) {
            iblockdata = (BlockState)iblockdata.setValue(POWERED, flag1);
            world.setBlock(blockposition, iblockdata, 3);
            this.updateSource(world, blockposition, iblockdata);
        }
        if (flag1) {
            world.scheduleTick(new BlockPos(blockposition), this, 10);
        }
    }

    public boolean shouldConnectTo(BlockState iblockdata, Direction enumdirection) {
        return iblockdata.is(this.hook) ? iblockdata.getValue(TripWireHookBlock.FACING) == enumdirection.getOpposite() : iblockdata.is(this);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(EAST, iblockdata.getValue(WEST))).setValue(SOUTH, iblockdata.getValue(NORTH))).setValue(WEST, iblockdata.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(EAST))).setValue(EAST, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(WEST))).setValue(EAST, iblockdata.getValue(NORTH))).setValue(SOUTH, iblockdata.getValue(EAST))).setValue(WEST, iblockdata.getValue(SOUTH));
            }
        }
        return iblockdata;
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)iblockdata.setValue(EAST, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(EAST));
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

