/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WetSpongeBlock
extends Block {
    public static final MapCodec<WetSpongeBlock> CODEC = WetSpongeBlock.simpleCodec(WetSpongeBlock::new);

    public MapCodec<WetSpongeBlock> codec() {
        return CODEC;
    }

    protected WetSpongeBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var1.dimensionType().ultraWarm()) {
            var1.setBlock(var2, Blocks.SPONGE.defaultBlockState(), 3);
            var1.levelEvent(2009, var2, 0);
            var1.playSound(null, var2, SoundEvents.WET_SPONGE_DRIES, SoundSource.BLOCKS, 1.0f, (1.0f + var1.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        Direction var4 = Direction.getRandom(var3);
        if (var4 == Direction.UP) {
            return;
        }
        BlockPos var5 = var2.relative(var4);
        BlockState var6 = var1.getBlockState(var5);
        if (var0.canOcclude() && var6.isFaceSturdy(var1, var5, var4.getOpposite())) {
            return;
        }
        double var7 = var2.getX();
        double var9 = var2.getY();
        double var11 = var2.getZ();
        if (var4 == Direction.DOWN) {
            var9 -= 0.05;
            var7 += var3.nextDouble();
            var11 += var3.nextDouble();
        } else {
            var9 += var3.nextDouble() * 0.8;
            if (var4.getAxis() == Direction.Axis.X) {
                var11 += var3.nextDouble();
                var7 = var4 == Direction.EAST ? (var7 += 1.1) : (var7 += 0.05);
            } else {
                var7 += var3.nextDouble();
                var11 = var4 == Direction.SOUTH ? (var11 += 1.1) : (var11 += 0.05);
            }
        }
        var1.addParticle(ParticleTypes.DRIPPING_WATER, var7, var9, var11, 0.0, 0.0, 0.0);
    }
}

