/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.block.BlockBrushEvent;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    public ItemStack item = ItemStack.EMPTY;
    @Nullable
    private Direction hitDirection;
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;

    public BrushableBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BRUSHABLE_BLOCK, blockposition, iblockdata);
    }

    public boolean brush(long i, ServerLevel worldserver, LivingEntity entityliving, Direction enumdirection, ItemStack itemstack) {
        if (this.hitDirection == null) {
            this.hitDirection = enumdirection;
        }
        this.brushCountResetsAtTick = i + 40L;
        if (i < this.coolDownEndsAtTick) {
            return false;
        }
        this.coolDownEndsAtTick = i + 10L;
        this.unpackLootTable(worldserver, entityliving, itemstack);
        int j = this.getCompletionState();
        if (++this.brushCount >= 10) {
            this.brushingCompleted(worldserver, entityliving, itemstack);
            return true;
        }
        worldserver.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        int k = this.getCompletionState();
        if (j != k) {
            BlockState iblockdata = this.getBlockState();
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(BlockStateProperties.DUSTED, k);
            BlockBrushEvent event = CraftEventFactory.callBlockBrushEvent(worldserver, this.getBlockPos(), iblockdata1, 3, (ServerPlayer)entityliving);
            if (!event.isCancelled()) {
                event.getNewState().update(true);
            }
        }
        return false;
    }

    private void unpackLootTable(ServerLevel worldserver, LivingEntity entityliving, ItemStack itemstack) {
        if (this.lootTable != null) {
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(this.lootTable);
            if (entityliving instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityliving;
                CriteriaTriggers.GENERATE_LOOT.trigger(entityplayer, this.lootTable);
            }
            LootParams lootparams = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(this.worldPosition)).withLuck(entityliving.getLuck()).withParameter(LootContextParams.THIS_ENTITY, entityliving).withParameter(LootContextParams.TOOL, itemstack).create(LootContextParamSets.ARCHAEOLOGY);
            ObjectArrayList<ItemStack> objectarraylist = loottable.getRandomItems(lootparams, this.lootTableSeed);
            this.item = switch (objectarraylist.size()) {
                case 0 -> ItemStack.EMPTY;
                case 1 -> (ItemStack)objectarraylist.getFirst();
                default -> {
                    LOGGER.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.lootTable.location(), (Object)objectarraylist.size());
                    yield (ItemStack)objectarraylist.getFirst();
                }
            };
            this.lootTable = null;
            this.setChanged();
        }
    }

    private void brushingCompleted(ServerLevel worldserver, LivingEntity entityliving, ItemStack itemstack) {
        Block block1;
        BlockState iblockdata = this.getBlockState();
        Block block = this.getBlockState().getBlock();
        if (block instanceof BrushableBlock) {
            BrushableBlock brushableblock = (BrushableBlock)block;
            block1 = brushableblock.getTurnsInto();
        } else {
            block1 = Blocks.AIR;
        }
        BlockBrushEvent event = CraftEventFactory.callBlockBrushEvent(worldserver, this.worldPosition, block1.defaultBlockState(), 3, (ServerPlayer)entityliving);
        if (!event.isCancelled()) {
            this.dropContent(worldserver, entityliving, itemstack);
            worldserver.levelEvent(3008, this.getBlockPos(), Block.getId(iblockdata));
            event.getNewState().update(true);
        }
    }

    private void dropContent(ServerLevel worldserver, LivingEntity entityliving, ItemStack itemstack) {
        this.unpackLootTable(worldserver, entityliving, itemstack);
        if (!this.item.isEmpty()) {
            double d0 = EntityType.ITEM.getWidth();
            double d1 = 1.0 - d0;
            double d2 = d0 / 2.0;
            Direction enumdirection = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
            BlockPos blockposition = this.worldPosition.relative(enumdirection, 1);
            double d3 = (double)blockposition.getX() + 0.5 * d1 + d2;
            double d4 = (double)blockposition.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
            double d5 = (double)blockposition.getZ() + 0.5 * d1 + d2;
            ItemEntity entityitem = new ItemEntity(worldserver, d3, d4, d5, this.item.split(worldserver.random.nextInt(21) + 10));
            entityitem.setDeltaMovement(Vec3.ZERO);
            if (entityliving instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityliving;
                CraftBlock bblock = CraftBlock.at(this.level, this.worldPosition);
                CraftEventFactory.handleBlockDropItemEvent(bblock, bblock.getState(), entityplayer, Arrays.asList(entityitem));
            }
            this.item = ItemStack.EMPTY;
        }
    }

    public void checkReset(ServerLevel worldserver) {
        if (this.brushCount != 0 && worldserver.getGameTime() >= this.brushCountResetsAtTick) {
            int i = this.getCompletionState();
            this.brushCount = Math.max(0, this.brushCount - 2);
            int j = this.getCompletionState();
            if (i != j) {
                worldserver.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(BlockStateProperties.DUSTED, j), 3);
            }
            int k = 4;
            this.brushCountResetsAtTick = worldserver.getGameTime() + 4L;
        }
        if (this.brushCount == 0) {
            this.hitDirection = null;
            this.brushCountResetsAtTick = 0L;
            this.coolDownEndsAtTick = 0L;
        } else {
            worldserver.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        }
    }

    private boolean tryLoadLootTable(ValueInput valueinput) {
        this.lootTable = valueinput.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.lootTableSeed = valueinput.getLongOr(LOOT_TABLE_SEED_TAG, 0L);
        return this.lootTable != null;
    }

    private boolean trySaveLootTable(ValueOutput valueoutput) {
        if (this.lootTable == null) {
            return false;
        }
        valueoutput.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, this.lootTable);
        if (this.lootTableSeed != 0L) {
            valueoutput.putLong(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        CompoundTag nbttagcompound = super.getUpdateTag(holderlookup_a);
        nbttagcompound.storeNullable(HIT_DIRECTION_TAG, Direction.LEGACY_ID_CODEC, this.hitDirection);
        if (!this.item.isEmpty()) {
            RegistryOps<Tag> registryops = holderlookup_a.createSerializationContext(NbtOps.INSTANCE);
            nbttagcompound.store(ITEM_TAG, ItemStack.CODEC, registryops, this.item);
        }
        return nbttagcompound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.item = !this.tryLoadLootTable(valueinput) ? valueinput.read(ITEM_TAG, ItemStack.CODEC).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.hitDirection = valueinput.read(HIT_DIRECTION_TAG, Direction.LEGACY_ID_CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        if (!this.trySaveLootTable(valueoutput) && !this.item.isEmpty()) {
            valueoutput.store(ITEM_TAG, ItemStack.CODEC, this.item);
        }
    }

    public void setLootTable(ResourceKey<LootTable> resourcekey, long i) {
        this.lootTable = resourcekey;
        this.lootTableSeed = i;
    }

    private int getCompletionState() {
        return this.brushCount == 0 ? 0 : (this.brushCount < 3 ? 1 : (this.brushCount < 6 ? 2 : 3));
    }

    @Nullable
    public Direction getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

