/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.phys.Vec3;

public enum VaultState implements StringRepresentable
{
    INACTIVE("inactive", LightLevel.HALF_LIT){

        @Override
        protected void onEnter(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var3.setDisplayItem(ItemStack.EMPTY);
            var0.levelEvent(3016, var1, var4 ? 1 : 0);
        }
    }
    ,
    ACTIVE("active", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            if (!var3.hasDisplayItem()) {
                VaultBlockEntity.Server.cycleDisplayItemFromLootTable(var0, this, var2, var3, var1);
            }
            var0.levelEvent(3015, var1, var4 ? 1 : 0);
        }
    }
    ,
    UNLOCKING("unlocking", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var0.playSound(null, var1, SoundEvents.VAULT_INSERT_ITEM, SoundSource.BLOCKS);
        }
    }
    ,
    EJECTING("ejecting", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var0.playSound(null, var1, SoundEvents.VAULT_OPEN_SHUTTER, SoundSource.BLOCKS);
        }

        @Override
        protected void onExit(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3) {
            var0.playSound(null, var1, SoundEvents.VAULT_CLOSE_SHUTTER, SoundSource.BLOCKS);
        }
    };

    private static final int UPDATE_CONNECTED_PLAYERS_TICK_RATE = 20;
    private static final int DELAY_BETWEEN_EJECTIONS_TICKS = 20;
    private static final int DELAY_AFTER_LAST_EJECTION_TICKS = 20;
    private static final int DELAY_BEFORE_FIRST_EJECTION_TICKS = 20;
    private final String stateName;
    private final LightLevel lightLevel;

    VaultState(String var2, LightLevel var3) {
        this.stateName = var2;
        this.lightLevel = var3;
    }

    @Override
    public String getSerializedName() {
        return this.stateName;
    }

    public int lightLevel() {
        return this.lightLevel.value;
    }

    public VaultState tickAndGetNext(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultServerData var3, VaultSharedData var4) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.activationRange());
            case 1 -> VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.deactivationRange());
            case 2 -> {
                var3.pauseStateUpdatingUntil(var0.getGameTime() + 20L);
                yield EJECTING;
            }
            case 3 -> {
                if (var3.getItemsToEject().isEmpty()) {
                    var3.markEjectionFinished();
                    yield VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.deactivationRange());
                }
                float var5 = var3.ejectionProgress();
                this.ejectResultItem(var0, var1, var3.popNextItemToEject(), var5);
                var4.setDisplayItem(var3.getNextItemToEject());
                boolean var6 = var3.getItemsToEject().isEmpty();
                int var7 = var6 ? 20 : 20;
                var3.pauseStateUpdatingUntil(var0.getGameTime() + (long)var7);
                yield EJECTING;
            }
        };
    }

    private static VaultState updateStateForConnectedPlayers(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultServerData var3, VaultSharedData var4, double var5) {
        var4.updateConnectedPlayersWithinRange(var0, var1, var3, var2, var5);
        var3.pauseStateUpdatingUntil(var0.getGameTime() + 20L);
        return var4.hasConnectedPlayers() ? ACTIVE : INACTIVE;
    }

    public void onTransition(ServerLevel var0, BlockPos var1, VaultState var2, VaultConfig var3, VaultSharedData var4, boolean var5) {
        this.onExit(var0, var1, var3, var4);
        var2.onEnter(var0, var1, var3, var4, var5);
    }

    protected void onEnter(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
    }

    protected void onExit(ServerLevel var0, BlockPos var1, VaultConfig var2, VaultSharedData var3) {
    }

    private void ejectResultItem(ServerLevel var0, BlockPos var1, ItemStack var2, float var3) {
        DefaultDispenseItemBehavior.spawnItem(var0, var2, 2, Direction.UP, Vec3.atBottomCenterOf(var1).relative(Direction.UP, 1.2));
        var0.levelEvent(3017, var1, 0);
        var0.playSound(null, var1, SoundEvents.VAULT_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * var3);
    }

    static enum LightLevel {
        HALF_LIT(6),
        LIT(12);

        final int value;

        private LightLevel(int var2) {
            this.value = var2;
        }
    }
}

