/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final MapCodec<PistonBaseBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(blockpiston -> blockpiston.isSticky), PistonBaseBlock.propertiesCodec()).apply((Applicative)instance, PistonBaseBlock::new));
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final int PLATFORM_THICKNESS = 4;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateAll(Block.boxZ(16.0, 4.0, 16.0));
    private final boolean isSticky;

    public MapCodec<PistonBaseBlock> codec() {
        return CODEC;
    }

    public PistonBaseBlock(boolean flag, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(EXTENDED, false));
        this.isSticky = flag;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return iblockdata.getValue(EXTENDED) != false ? SHAPES.get(iblockdata.getValue(FACING)) : Shapes.block();
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, LivingEntity entityliving, ItemStack itemstack) {
        if (!world.isClientSide()) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (!world.isClientSide()) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock()) && !world.isClientSide() && world.getBlockEntity(blockposition) == null) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(Level world, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        boolean flag = this.getNeighborSignal(world, blockposition, enumdirection);
        if (flag && !iblockdata.getValue(EXTENDED).booleanValue()) {
            if (new PistonStructureResolver(world, blockposition, enumdirection, true).resolve()) {
                world.blockEvent(blockposition, this, 0, enumdirection.get3DDataValue());
            }
        } else if (!flag && iblockdata.getValue(EXTENDED).booleanValue()) {
            PistonMovingBlockEntity tileentitypiston;
            BlockEntity tileentity;
            BlockPos blockposition1 = blockposition.relative(enumdirection, 2);
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            int i = 1;
            if (iblockdata1.is(Blocks.MOVING_PISTON) && iblockdata1.getValue(FACING) == enumdirection && (tileentity = world.getBlockEntity(blockposition1)) instanceof PistonMovingBlockEntity && (tileentitypiston = (PistonMovingBlockEntity)tileentity).isExtending() && (tileentitypiston.getProgress(0.0f) < 0.5f || world.getGameTime() == tileentitypiston.getLastTicked() || ((ServerLevel)world).isHandlingTick())) {
                i = 2;
            }
            if (!this.isSticky) {
                org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                BlockPistonRetractEvent event = new BlockPistonRetractEvent(block, (List)ImmutableList.of(), CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            world.blockEvent(blockposition, this, i, enumdirection.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter signalgetter, BlockPos blockposition, Direction enumdirection) {
        for (Direction enumdirection1 : Direction.values()) {
            if (enumdirection1 == enumdirection || !signalgetter.hasSignal(blockposition.relative(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (signalgetter.hasSignal(blockposition, Direction.DOWN)) {
            return true;
        }
        BlockPos blockposition1 = blockposition.above();
        for (Direction enumdirection2 : Direction.values()) {
            if (enumdirection2 == Direction.DOWN || !signalgetter.hasSignal(blockposition1.relative(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean triggerEvent(BlockState iblockdata, Level world, BlockPos blockposition, int i, int j) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        BlockState iblockdata1 = (BlockState)iblockdata.setValue(EXTENDED, true);
        if (!world.isClientSide()) {
            boolean flag = this.getNeighborSignal(world, blockposition, enumdirection);
            if (flag && (i == 1 || i == 2)) {
                world.setBlock(blockposition, iblockdata1, 2);
                return false;
            }
            if (!flag && i == 0) {
                return false;
            }
        }
        if (i == 0) {
            if (!this.moveBlocks(world, blockposition, enumdirection, true)) {
                return false;
            }
            world.setBlock(blockposition, iblockdata1, 67);
            world.playSound((Entity)null, blockposition, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.25f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_ACTIVATE, blockposition, GameEvent.Context.of(iblockdata1));
        } else if (i == 1 || i == 2) {
            BlockEntity tileentity = world.getBlockEntity(blockposition.relative(enumdirection));
            if (tileentity instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)tileentity).finalTick();
            }
            BlockState iblockdata2 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, enumdirection)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            world.setBlock(blockposition, iblockdata2, 276);
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockposition, iblockdata2, (BlockState)this.defaultBlockState().setValue(FACING, Direction.from3DDataValue(j & 7)), enumdirection, false, true));
            world.updateNeighborsAt(blockposition, iblockdata2.getBlock());
            iblockdata2.updateNeighbourShapes(world, blockposition, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity tileentitypiston;
                BlockEntity tileentity1;
                BlockPos blockposition1 = blockposition.offset(enumdirection.getStepX() * 2, enumdirection.getStepY() * 2, enumdirection.getStepZ() * 2);
                BlockState iblockdata3 = world.getBlockState(blockposition1);
                boolean flag1 = false;
                if (iblockdata3.is(Blocks.MOVING_PISTON) && (tileentity1 = world.getBlockEntity(blockposition1)) instanceof PistonMovingBlockEntity && (tileentitypiston = (PistonMovingBlockEntity)tileentity1).getDirection() == enumdirection && tileentitypiston.isExtending()) {
                    tileentitypiston.finalTick();
                    flag1 = true;
                }
                if (!flag1) {
                    if (i != 1 || iblockdata3.isAir() || !PistonBaseBlock.isPushable(iblockdata3, world, blockposition1, enumdirection.getOpposite(), false, enumdirection) || iblockdata3.getPistonPushReaction() != PushReaction.NORMAL && !iblockdata3.is(Blocks.PISTON) && !iblockdata3.is(Blocks.STICKY_PISTON)) {
                        world.removeBlock(blockposition.relative(enumdirection), false);
                    } else {
                        this.moveBlocks(world, blockposition, enumdirection, false);
                    }
                }
            } else {
                world.removeBlock(blockposition.relative(enumdirection), false);
            }
            world.playSound((Entity)null, blockposition, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.15f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_DEACTIVATE, blockposition, GameEvent.Context.of(iblockdata2));
        }
        return true;
    }

    public static boolean isPushable(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection, boolean flag, Direction enumdirection1) {
        if (blockposition.getY() >= world.getMinY() && blockposition.getY() <= world.getMaxY() && world.getWorldBorder().isWithinBounds(blockposition)) {
            if (iblockdata.isAir()) {
                return true;
            }
            if (!(iblockdata.is(Blocks.OBSIDIAN) || iblockdata.is(Blocks.CRYING_OBSIDIAN) || iblockdata.is(Blocks.RESPAWN_ANCHOR) || iblockdata.is(Blocks.REINFORCED_DEEPSLATE))) {
                if (enumdirection == Direction.DOWN && blockposition.getY() == world.getMinY()) {
                    return false;
                }
                if (enumdirection == Direction.UP && blockposition.getY() == world.getMaxY()) {
                    return false;
                }
                if (!iblockdata.is(Blocks.PISTON) && !iblockdata.is(Blocks.STICKY_PISTON)) {
                    if (iblockdata.getDestroySpeed(world, blockposition) == -1.0f) {
                        return false;
                    }
                    switch (iblockdata.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return flag;
                        }
                        case PUSH_ONLY: {
                            return enumdirection == enumdirection1;
                        }
                    }
                } else if (iblockdata.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !iblockdata.hasBlockEntity();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(Level world, BlockPos blockposition, Direction enumdirection, boolean flag) {
        void var21_37;
        void var21_35;
        PistonStructureResolver pistonextendschecker;
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        if (!flag && world.getBlockState(blockposition1).is(Blocks.PISTON_HEAD)) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 276);
        }
        if (!(pistonextendschecker = new PistonStructureResolver(world, blockposition, enumdirection, flag)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonextendschecker.getToPush();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPos blockposition2 : list) {
            BlockState iblockdata = world.getBlockState(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPos> list2 = pistonextendschecker.getToDestroy();
        BlockState[] aiblockdata = new BlockState[list.size() + list2.size()];
        Direction enumdirection1 = flag ? enumdirection : enumdirection.getOpposite();
        int i = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        final List<BlockPos> moved = pistonextendschecker.getToPush();
        final List<BlockPos> broken = pistonextendschecker.getToDestroy();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPos pos = index < moved.size() ? (BlockPos)moved.get(index) : (BlockPos)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            }
        };
        Object event = flag ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPos b : broken) {
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
            }
            for (BlockPos b : moved) {
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
                b = b.relative(enumdirection1);
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
            }
            return false;
        }
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockposition3 = list2.get(j);
            BlockState blockState = world.getBlockState(blockposition3);
            BlockEntity tileentity = blockState.hasBlockEntity() ? world.getBlockEntity(blockposition3) : null;
            PistonBaseBlock.dropResources(blockState, world, blockposition3, tileentity);
            if (!blockState.is(BlockTags.FIRE) && world.isClientSide()) {
                world.levelEvent(2001, blockposition3, PistonBaseBlock.getId(blockState));
            }
            world.setBlock(blockposition3, Blocks.AIR.defaultBlockState(), 18);
            world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition3, GameEvent.Context.of(blockState));
            aiblockdata[i++] = blockState;
        }
        for (int k = list.size() - 1; k >= 0; --k) {
            BlockPos blockposition4 = list.get(k);
            BlockState blockState = world.getBlockState(blockposition4);
            blockposition4 = blockposition4.relative(enumdirection1);
            map.remove(blockposition4);
            BlockState iblockdata3 = (BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(FACING, enumdirection);
            world.setBlock(blockposition4, iblockdata3, 324);
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockposition4, iblockdata3, (BlockState)list1.get(k), enumdirection, flag, false));
            aiblockdata[i++] = blockState;
        }
        if (flag) {
            PistonType blockpropertypistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState iblockdata4 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.FACING, enumdirection)).setValue(PistonHeadBlock.TYPE, blockpropertypistontype);
            BlockState blockState = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, enumdirection)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            map.remove(blockposition1);
            world.setBlock(blockposition1, blockState, 324);
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockposition1, blockState, iblockdata4, enumdirection, true, true));
        }
        BlockState iblockdata6 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : map.keySet()) {
            world.setBlock(blockPos, iblockdata6, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockposition6 = (BlockPos)entry.getKey();
            BlockState iblockdata7 = (BlockState)entry.getValue();
            iblockdata7.updateIndirectNeighbourShapes(world, blockposition6, 2);
            iblockdata6.updateNeighbourShapes(world, blockposition6, 2);
            iblockdata6.updateIndirectNeighbourShapes(world, blockposition6, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, pistonextendschecker.getPushDirection(), null);
        i = 0;
        int n = list2.size() - 1;
        while (var21_35 >= 0) {
            BlockState iblockdata8 = aiblockdata[i++];
            BlockPos blockposition7 = list2.get((int)var21_35);
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                iblockdata8.affectNeighborsAfterRemoval(worldserver, blockposition7, false);
            }
            iblockdata8.updateIndirectNeighbourShapes(world, blockposition7, 2);
            world.updateNeighborsAt(blockposition7, iblockdata8.getBlock(), orientation);
            --var21_35;
        }
        int n2 = list.size() - 1;
        while (var21_37 >= 0) {
            world.updateNeighborsAt(list.get((int)var21_37), aiblockdata[i++].getBlock(), orientation);
            --var21_37;
        }
        if (flag) {
            world.updateNeighborsAt(blockposition1, Blocks.PISTON_HEAD, orientation);
        }
        return true;
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate((Direction)iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation((Direction)iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState iblockdata) {
        return iblockdata.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }
}

