/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBehaviour
implements FeatureElement {
    protected static final Direction[] UPDATE_SHAPE_ORDER = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    protected final boolean hasCollision;
    protected final float explosionResistance;
    protected final boolean isRandomlyTicking;
    protected final SoundType soundType;
    protected final float friction;
    protected final float speedFactor;
    protected final float jumpFactor;
    protected final boolean dynamicShape;
    protected final FeatureFlagSet requiredFeatures;
    protected final Properties properties;
    protected final Optional<ResourceKey<LootTable>> drops;
    protected final String descriptionId;

    public BlockBehaviour(Properties blockbase_info) {
        this.hasCollision = blockbase_info.hasCollision;
        this.drops = blockbase_info.effectiveDrops();
        this.descriptionId = blockbase_info.effectiveDescriptionId();
        this.explosionResistance = blockbase_info.explosionResistance;
        this.isRandomlyTicking = blockbase_info.isRandomlyTicking;
        this.soundType = blockbase_info.soundType;
        this.friction = blockbase_info.friction;
        this.speedFactor = blockbase_info.speedFactor;
        this.jumpFactor = blockbase_info.jumpFactor;
        this.dynamicShape = blockbase_info.dynamicShape;
        this.requiredFeatures = blockbase_info.requiredFeatures;
        this.properties = blockbase_info;
    }

    public Properties properties() {
        return this.properties;
    }

    protected abstract MapCodec<? extends Block> codec();

    protected static <B extends Block> RecordCodecBuilder<B, Properties> propertiesCodec() {
        return Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties);
    }

    public static <B extends Block> MapCodec<B> simpleCodec(Function<Properties, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBehaviour.propertiesCodec()).apply((Applicative)instance, function));
    }

    protected void updateIndirectNeighbourShapes(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, int i, int j) {
    }

    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        switch (pathmode) {
            case LAND: {
                return !iblockdata.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
            }
            case WATER: {
                return iblockdata.getFluidState().is(FluidTags.WATER);
            }
            case AIR: {
                return !iblockdata.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
            }
        }
        return false;
    }

    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return iblockdata;
    }

    protected boolean skipRendering(BlockState iblockdata, BlockState iblockdata1, Direction enumdirection) {
        return false;
    }

    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        AsyncCatcher.catchOp("block onPlace");
    }

    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag, @Nullable UseOnContext context) {
        this.onPlace(iblockdata, world, blockposition, iblockdata1, flag);
    }

    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
    }

    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (!iblockdata.isAir() && explosion.getBlockInteraction() != Explosion.BlockInteraction.TRIGGER_BLOCK) {
            Block block = iblockdata.getBlock();
            boolean flag = explosion.getIndirectSourceEntity() instanceof Player;
            if (block.dropFromExplosion(explosion)) {
                BlockEntity tileentity = iblockdata.hasBlockEntity() ? worldserver.getBlockEntity(blockposition) : null;
                LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity).withOptionalParameter(LootContextParams.THIS_ENTITY, explosion.getDirectSourceEntity());
                if (explosion instanceof ServerExplosion) {
                    ServerExplosion serverExplosion = (ServerExplosion)explosion;
                    if (serverExplosion.yield < 1.0f) {
                        lootparams_a.withParameter(LootContextParams.EXPLOSION_RADIUS, Float.valueOf(1.0f / serverExplosion.yield));
                    }
                }
                iblockdata.spawnAfterBreak(worldserver, blockposition, ItemStack.EMPTY, flag);
                iblockdata.getDrops(lootparams_a).forEach(itemstack -> biconsumer.accept((ItemStack)itemstack, blockposition));
            }
            worldserver.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 3);
            block.wasExploded(worldserver, blockposition, explosion);
        }
    }

    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        return InteractionResult.PASS;
    }

    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected boolean triggerEvent(BlockState iblockdata, Level world, BlockPos blockposition, int i, int j) {
        return false;
    }

    protected RenderShape getRenderShape(BlockState iblockdata) {
        return RenderShape.MODEL;
    }

    protected boolean useShapeForLightOcclusion(BlockState iblockdata) {
        return false;
    }

    protected boolean isSignalSource(BlockState iblockdata) {
        return false;
    }

    protected FluidState getFluidState(BlockState iblockdata) {
        return Fluids.EMPTY.defaultFluidState();
    }

    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return false;
    }

    protected float getMaxHorizontalOffset() {
        return 0.25f;
    }

    protected float getMaxVerticalOffset() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    protected boolean shouldChangedStateKeepBlockEntity(BlockState iblockdata) {
        return false;
    }

    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return iblockdata;
    }

    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata;
    }

    protected boolean canBeReplaced(BlockState iblockdata, BlockPlaceContext blockactioncontext) {
        return iblockdata.canBeReplaced() && (blockactioncontext.getItemInHand().isEmpty() || !blockactioncontext.getItemInHand().is(this.asItem()));
    }

    protected boolean canBeReplaced(BlockState iblockdata, Fluid fluidtype) {
        return iblockdata.canBeReplaced() || !iblockdata.isSolid();
    }

    protected List<ItemStack> getDrops(BlockState iblockdata, LootParams.Builder lootparams_a) {
        if (this.drops.isEmpty()) {
            return Collections.emptyList();
        }
        LootParams lootparams = lootparams_a.withParameter(LootContextParams.BLOCK_STATE, iblockdata).create(LootContextParamSets.BLOCK);
        ServerLevel worldserver = lootparams.getLevel();
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(this.drops.get());
        return loottable.getRandomItems(lootparams);
    }

    protected long getSeed(BlockState iblockdata, BlockPos blockposition) {
        return Mth.getSeed(blockposition);
    }

    protected VoxelShape getOcclusionShape(BlockState iblockdata) {
        return iblockdata.getShape(EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    protected VoxelShape getBlockSupportShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return this.getCollisionShape(iblockdata, iblockaccess, blockposition, CollisionContext.empty());
    }

    protected VoxelShape getInteractionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return Shapes.empty();
    }

    protected int getLightBlock(BlockState iblockdata) {
        return iblockdata.isSolidRender() ? 15 : (iblockdata.propagatesSkylightDown() ? 0 : 1);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState iblockdata, Level world, BlockPos blockposition) {
        return null;
    }

    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return true;
    }

    protected float getShadeBrightness(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition) ? 0.2f : 1.0f;
    }

    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        return 0;
    }

    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return Shapes.block();
    }

    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.hasCollision ? iblockdata.getShape(iblockaccess, blockposition) : Shapes.empty();
    }

    protected VoxelShape getEntityInsideCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Entity entity) {
        return Shapes.block();
    }

    protected boolean isCollisionShapeFullBlock(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return Block.isShapeFullBlock(iblockdata.getCollisionShape(iblockaccess, blockposition));
    }

    protected VoxelShape getVisualShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.getCollisionShape(iblockdata, iblockaccess, blockposition, voxelshapecollision);
    }

    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
    }

    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
    }

    protected float getDestroyProgress(BlockState iblockdata, Player entityhuman, BlockGetter iblockaccess, BlockPos blockposition) {
        float f = iblockdata.getDestroySpeed(iblockaccess, blockposition);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = entityhuman.hasCorrectToolForDrops(iblockdata) ? 30 : 100;
        return entityhuman.getDestroySpeed(iblockdata) / f / (float)i;
    }

    protected void spawnAfterBreak(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
    }

    protected void attack(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman) {
    }

    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return 0;
    }

    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
    }

    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return 0;
    }

    public final Optional<ResourceKey<LootTable>> getLootTable() {
        return this.drops;
    }

    public final String getDescriptionId() {
        return this.descriptionId;
    }

    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
    }

    protected boolean propagatesSkylightDown(BlockState iblockdata) {
        return !Block.isShapeFullBlock(iblockdata.getShape(EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) && iblockdata.getFluidState().isEmpty();
    }

    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return this.isRandomlyTicking;
    }

    protected SoundType getSoundType(BlockState iblockdata) {
        return this.soundType;
    }

    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return new ItemStack(this.asItem());
    }

    public abstract Item asItem();

    protected abstract Block asBlock();

    public MapColor defaultMapColor() {
        return this.properties.mapColor.apply(this.asBlock().defaultBlockState());
    }

    public float defaultDestroyTime() {
        return this.properties.destroyTime;
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = Codec.unit(() -> Properties.of());
        Function<BlockState, MapColor> mapColor = iblockdata -> MapColor.NONE;
        boolean hasCollision = true;
        SoundType soundType = SoundType.STONE;
        ToIntFunction<BlockState> lightEmission = iblockdata -> 0;
        float explosionResistance;
        float destroyTime;
        boolean requiresCorrectToolForDrops;
        boolean isRandomlyTicking;
        float friction = 0.6f;
        float speedFactor = 1.0f;
        float jumpFactor = 1.0f;
        @Nullable
        private ResourceKey<Block> id;
        private DependantName<Block, Optional<ResourceKey<LootTable>>> drops = resourcekey -> Optional.of(ResourceKey.create(Registries.LOOT_TABLE, resourcekey.location().withPrefix("blocks/")));
        private DependantName<Block, String> descriptionId = resourcekey -> Util.makeDescriptionId("block", resourcekey.location());
        boolean canOcclude = true;
        boolean isAir;
        boolean ignitedByLava;
        @Deprecated
        boolean liquid;
        @Deprecated
        boolean forceSolidOff;
        boolean forceSolidOn;
        PushReaction pushReaction = PushReaction.NORMAL;
        boolean spawnTerrainParticles = true;
        NoteBlockInstrument instrument = NoteBlockInstrument.HARP;
        boolean replaceable;
        StateArgumentPredicate<EntityType<?>> isValidSpawn = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.isFaceSturdy(iblockaccess, blockposition, Direction.UP) && iblockdata.getLightEmission() < 14;
        StatePredicate isRedstoneConductor = (iblockdata, iblockaccess, blockposition) -> iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition);
        StatePredicate isSuffocating;
        StatePredicate isViewBlocking = this.isSuffocating = (iblockdata, iblockaccess, blockposition) -> iblockdata.blocksMotion() && iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition);
        StatePredicate hasPostProcess = (iblockdata, iblockaccess, blockposition) -> false;
        StatePredicate emissiveRendering = (iblockdata, iblockaccess, blockposition) -> false;
        boolean dynamicShape;
        FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
        @Nullable
        OffsetFunction offsetFunction;

        private Properties() {
        }

        public static Properties of() {
            return new Properties();
        }

        public static Properties ofFullCopy(BlockBehaviour blockbase) {
            Properties blockbase_info = Properties.ofLegacyCopy(blockbase);
            Properties blockbase_info1 = blockbase.properties;
            blockbase_info.jumpFactor = blockbase_info1.jumpFactor;
            blockbase_info.isRedstoneConductor = blockbase_info1.isRedstoneConductor;
            blockbase_info.isValidSpawn = blockbase_info1.isValidSpawn;
            blockbase_info.hasPostProcess = blockbase_info1.hasPostProcess;
            blockbase_info.isSuffocating = blockbase_info1.isSuffocating;
            blockbase_info.isViewBlocking = blockbase_info1.isViewBlocking;
            blockbase_info.drops = blockbase_info1.drops;
            blockbase_info.descriptionId = blockbase_info1.descriptionId;
            return blockbase_info;
        }

        @Deprecated
        public static Properties ofLegacyCopy(BlockBehaviour blockbase) {
            Properties blockbase_info = new Properties();
            Properties blockbase_info1 = blockbase.properties;
            blockbase_info.destroyTime = blockbase_info1.destroyTime;
            blockbase_info.explosionResistance = blockbase_info1.explosionResistance;
            blockbase_info.hasCollision = blockbase_info1.hasCollision;
            blockbase_info.isRandomlyTicking = blockbase_info1.isRandomlyTicking;
            blockbase_info.lightEmission = blockbase_info1.lightEmission;
            blockbase_info.mapColor = blockbase_info1.mapColor;
            blockbase_info.soundType = blockbase_info1.soundType;
            blockbase_info.friction = blockbase_info1.friction;
            blockbase_info.speedFactor = blockbase_info1.speedFactor;
            blockbase_info.dynamicShape = blockbase_info1.dynamicShape;
            blockbase_info.canOcclude = blockbase_info1.canOcclude;
            blockbase_info.isAir = blockbase_info1.isAir;
            blockbase_info.ignitedByLava = blockbase_info1.ignitedByLava;
            blockbase_info.liquid = blockbase_info1.liquid;
            blockbase_info.forceSolidOff = blockbase_info1.forceSolidOff;
            blockbase_info.forceSolidOn = blockbase_info1.forceSolidOn;
            blockbase_info.pushReaction = blockbase_info1.pushReaction;
            blockbase_info.requiresCorrectToolForDrops = blockbase_info1.requiresCorrectToolForDrops;
            blockbase_info.offsetFunction = blockbase_info1.offsetFunction;
            blockbase_info.spawnTerrainParticles = blockbase_info1.spawnTerrainParticles;
            blockbase_info.requiredFeatures = blockbase_info1.requiredFeatures;
            blockbase_info.emissiveRendering = blockbase_info1.emissiveRendering;
            blockbase_info.instrument = blockbase_info1.instrument;
            blockbase_info.replaceable = blockbase_info1.replaceable;
            return blockbase_info;
        }

        public Properties mapColor(DyeColor enumcolor) {
            this.mapColor = iblockdata -> enumcolor.getMapColor();
            return this;
        }

        public Properties mapColor(MapColor materialmapcolor) {
            this.mapColor = iblockdata -> materialmapcolor;
            return this;
        }

        public Properties mapColor(Function<BlockState, MapColor> function) {
            this.mapColor = function;
            return this;
        }

        public Properties noCollision() {
            this.hasCollision = false;
            this.canOcclude = false;
            return this;
        }

        public Properties noOcclusion() {
            this.canOcclude = false;
            return this;
        }

        public Properties friction(float f) {
            this.friction = f;
            return this;
        }

        public Properties speedFactor(float f) {
            this.speedFactor = f;
            return this;
        }

        public Properties jumpFactor(float f) {
            this.jumpFactor = f;
            return this;
        }

        public Properties sound(SoundType soundeffecttype) {
            this.soundType = soundeffecttype;
            return this;
        }

        public Properties lightLevel(ToIntFunction<BlockState> tointfunction) {
            this.lightEmission = tointfunction;
            return this;
        }

        public Properties strength(float f, float f1) {
            return this.destroyTime(f).explosionResistance(f1);
        }

        public Properties instabreak() {
            return this.strength(0.0f);
        }

        public Properties strength(float f) {
            this.strength(f, f);
            return this;
        }

        public Properties randomTicks() {
            this.isRandomlyTicking = true;
            return this;
        }

        public Properties dynamicShape() {
            this.dynamicShape = true;
            return this;
        }

        public Properties noLootTable() {
            this.drops = DependantName.fixed(Optional.empty());
            return this;
        }

        public Properties overrideLootTable(Optional<ResourceKey<LootTable>> optional) {
            this.drops = DependantName.fixed(optional);
            return this;
        }

        protected Optional<ResourceKey<LootTable>> effectiveDrops() {
            return this.drops.get(Objects.requireNonNull(this.id, "Block id not set"));
        }

        public Properties ignitedByLava() {
            this.ignitedByLava = true;
            return this;
        }

        public Properties liquid() {
            this.liquid = true;
            return this;
        }

        public Properties forceSolidOn() {
            this.forceSolidOn = true;
            return this;
        }

        @Deprecated
        public Properties forceSolidOff() {
            this.forceSolidOff = true;
            return this;
        }

        public Properties pushReaction(PushReaction enumpistonreaction) {
            this.pushReaction = enumpistonreaction;
            return this;
        }

        public Properties air() {
            this.isAir = true;
            return this;
        }

        public Properties isValidSpawn(StateArgumentPredicate<EntityType<?>> blockbase_e) {
            this.isValidSpawn = blockbase_e;
            return this;
        }

        public Properties isRedstoneConductor(StatePredicate blockbase_f) {
            this.isRedstoneConductor = blockbase_f;
            return this;
        }

        public Properties isSuffocating(StatePredicate blockbase_f) {
            this.isSuffocating = blockbase_f;
            return this;
        }

        public Properties isViewBlocking(StatePredicate blockbase_f) {
            this.isViewBlocking = blockbase_f;
            return this;
        }

        public Properties hasPostProcess(StatePredicate blockbase_f) {
            this.hasPostProcess = blockbase_f;
            return this;
        }

        public Properties emissiveRendering(StatePredicate blockbase_f) {
            this.emissiveRendering = blockbase_f;
            return this;
        }

        public Properties requiresCorrectToolForDrops() {
            this.requiresCorrectToolForDrops = true;
            return this;
        }

        public Properties destroyTime(float f) {
            this.destroyTime = f;
            return this;
        }

        public Properties explosionResistance(float f) {
            this.explosionResistance = Math.max(0.0f, f);
            return this;
        }

        public Properties offsetType(OffsetType blockbase_enumrandomoffset) {
            this.offsetFunction = switch (blockbase_enumrandomoffset.ordinal()) {
                case 0 -> null;
                case 1 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.getBlock();
                    long i = Mth.getSeed(blockposition.getX(), 0, blockposition.getZ());
                    float f = block.getMaxHorizontalOffset();
                    double d0 = Mth.clamp(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f), (double)f);
                    double d1 = Mth.clamp(((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f), (double)f);
                    return new Vec3(d0, 0.0, d1);
                };
                case 2 -> (iblockdata, blockposition) -> {
                    Block block = iblockdata.getBlock();
                    long i = Mth.getSeed(blockposition.getX(), 0, blockposition.getZ());
                    double d0 = ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.getMaxVerticalOffset();
                    float f = block.getMaxHorizontalOffset();
                    double d1 = Mth.clamp(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f), (double)f);
                    double d2 = Mth.clamp(((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f), (double)f);
                    return new Vec3(d1, d0, d2);
                };
                default -> throw new MatchException(null, null);
            };
            return this;
        }

        public Properties noTerrainParticles() {
            this.spawnTerrainParticles = false;
            return this;
        }

        public Properties requiredFeatures(FeatureFlag ... afeatureflag) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(afeatureflag);
            return this;
        }

        public Properties instrument(NoteBlockInstrument blockpropertyinstrument) {
            this.instrument = blockpropertyinstrument;
            return this;
        }

        public Properties replaceable() {
            this.replaceable = true;
            return this;
        }

        public Properties setId(ResourceKey<Block> resourcekey) {
            this.id = resourcekey;
            return this;
        }

        public Properties overrideDescription(String s) {
            this.descriptionId = DependantName.fixed(s);
            return this;
        }

        protected String effectiveDescriptionId() {
            return this.descriptionId.get(Objects.requireNonNull(this.id, "Block id not set"));
        }
    }

    @FunctionalInterface
    public static interface StatePredicate {
        public boolean test(BlockState var1, BlockGetter var2, BlockPos var3);
    }

    @FunctionalInterface
    public static interface StateArgumentPredicate<A> {
        public boolean test(BlockState var1, BlockGetter var2, BlockPos var3, A var4);
    }

    @FunctionalInterface
    public static interface OffsetFunction {
        public Vec3 evaluate(BlockState var1, BlockPos var2);
    }

    public static abstract class BlockStateBase
    extends StateHolder<Block, BlockState> {
        private static final Direction[] DIRECTIONS = Direction.values();
        private static final VoxelShape[] EMPTY_OCCLUSION_SHAPES = Util.make(new VoxelShape[DIRECTIONS.length], avoxelshape -> Arrays.fill(avoxelshape, Shapes.empty()));
        private static final VoxelShape[] FULL_BLOCK_OCCLUSION_SHAPES = Util.make(new VoxelShape[DIRECTIONS.length], avoxelshape -> Arrays.fill(avoxelshape, Shapes.block()));
        private final int lightEmission;
        private final boolean useShapeForLightOcclusion;
        private final boolean isAir;
        private final boolean ignitedByLava;
        @Deprecated
        private final boolean liquid;
        @Deprecated
        private boolean legacySolid;
        private final PushReaction pushReaction;
        private final MapColor mapColor;
        public final float destroySpeed;
        private final boolean requiresCorrectToolForDrops;
        private final boolean canOcclude;
        private final StatePredicate isRedstoneConductor;
        private final StatePredicate isSuffocating;
        private final StatePredicate isViewBlocking;
        private final StatePredicate hasPostProcess;
        private final StatePredicate emissiveRendering;
        @Nullable
        private final OffsetFunction offsetFunction;
        private final boolean spawnTerrainParticles;
        private final NoteBlockInstrument instrument;
        private final boolean replaceable;
        @Nullable
        private Cache cache;
        private FluidState fluidState = Fluids.EMPTY.defaultFluidState();
        private boolean isRandomlyTicking;
        private boolean solidRender;
        private VoxelShape occlusionShape;
        private VoxelShape[] occlusionShapesByFace;
        private boolean propagatesSkylightDown;
        private int lightBlock;

        protected BlockStateBase(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> reference2objectarraymap, MapCodec<BlockState> mapcodec) {
            super(block, reference2objectarraymap, mapcodec);
            Properties blockbase_info = block.properties;
            this.lightEmission = blockbase_info.lightEmission.applyAsInt(this.asState());
            this.useShapeForLightOcclusion = block.useShapeForLightOcclusion(this.asState());
            this.isAir = blockbase_info.isAir;
            this.ignitedByLava = blockbase_info.ignitedByLava;
            this.liquid = blockbase_info.liquid;
            this.pushReaction = blockbase_info.pushReaction;
            this.mapColor = blockbase_info.mapColor.apply(this.asState());
            this.destroySpeed = blockbase_info.destroyTime;
            this.requiresCorrectToolForDrops = blockbase_info.requiresCorrectToolForDrops;
            this.canOcclude = blockbase_info.canOcclude;
            this.isRedstoneConductor = blockbase_info.isRedstoneConductor;
            this.isSuffocating = blockbase_info.isSuffocating;
            this.isViewBlocking = blockbase_info.isViewBlocking;
            this.hasPostProcess = blockbase_info.hasPostProcess;
            this.emissiveRendering = blockbase_info.emissiveRendering;
            this.offsetFunction = blockbase_info.offsetFunction;
            this.spawnTerrainParticles = blockbase_info.spawnTerrainParticles;
            this.instrument = blockbase_info.instrument;
            this.replaceable = blockbase_info.replaceable;
        }

        private boolean calculateSolid() {
            if (((Block)this.owner).properties.forceSolidOn) {
                return true;
            }
            if (((Block)this.owner).properties.forceSolidOff) {
                return false;
            }
            if (this.cache == null) {
                return false;
            }
            VoxelShape voxelshape = this.cache.collisionShape;
            if (voxelshape.isEmpty()) {
                return false;
            }
            AABB axisalignedbb = voxelshape.bounds();
            return axisalignedbb.getSize() >= 0.7291666666666666 ? true : axisalignedbb.getYsize() >= 1.0;
        }

        public void initCache() {
            this.fluidState = ((Block)this.owner).getFluidState(this.asState());
            this.isRandomlyTicking = ((Block)this.owner).isRandomlyTicking(this.asState());
            if (!this.getBlock().hasDynamicShape()) {
                this.cache = new Cache(this.asState());
            }
            this.legacySolid = this.calculateSolid();
            this.occlusionShape = this.canOcclude ? ((Block)this.owner).getOcclusionShape(this.asState()) : Shapes.empty();
            this.solidRender = Block.isShapeFullBlock(this.occlusionShape);
            if (this.occlusionShape.isEmpty()) {
                this.occlusionShapesByFace = EMPTY_OCCLUSION_SHAPES;
            } else if (this.solidRender) {
                this.occlusionShapesByFace = FULL_BLOCK_OCCLUSION_SHAPES;
            } else {
                this.occlusionShapesByFace = new VoxelShape[DIRECTIONS.length];
                for (Direction enumdirection : DIRECTIONS) {
                    this.occlusionShapesByFace[enumdirection.ordinal()] = this.occlusionShape.getFaceShape(enumdirection);
                }
            }
            this.propagatesSkylightDown = ((Block)this.owner).propagatesSkylightDown(this.asState());
            this.lightBlock = ((Block)this.owner).getLightBlock(this.asState());
        }

        public Block getBlock() {
            return (Block)this.owner;
        }

        public Holder<Block> getBlockHolder() {
            return ((Block)this.owner).builtInRegistryHolder();
        }

        @Deprecated
        public boolean blocksMotion() {
            Block block = this.getBlock();
            return block != Blocks.COBWEB && block != Blocks.BAMBOO_SAPLING && this.isSolid();
        }

        @Deprecated
        public boolean isSolid() {
            return this.legacySolid;
        }

        public boolean isValidSpawn(BlockGetter iblockaccess, BlockPos blockposition, EntityType<?> entitytypes) {
            return this.getBlock().properties.isValidSpawn.test(this.asState(), iblockaccess, blockposition, entitytypes);
        }

        public boolean propagatesSkylightDown() {
            return this.propagatesSkylightDown;
        }

        public int getLightBlock() {
            return this.lightBlock;
        }

        public VoxelShape getFaceOcclusionShape(Direction enumdirection) {
            return this.occlusionShapesByFace[enumdirection.ordinal()];
        }

        public VoxelShape getOcclusionShape() {
            return this.occlusionShape;
        }

        public boolean hasLargeCollisionShape() {
            return this.cache == null || this.cache.largeCollisionShape;
        }

        public boolean useShapeForLightOcclusion() {
            return this.useShapeForLightOcclusion;
        }

        public int getLightEmission() {
            return this.lightEmission;
        }

        public boolean isAir() {
            return this.isAir;
        }

        public boolean ignitedByLava() {
            return this.ignitedByLava;
        }

        @Deprecated
        public boolean liquid() {
            return this.liquid;
        }

        public MapColor getMapColor(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.mapColor;
        }

        public BlockState rotate(Rotation enumblockrotation) {
            return this.getBlock().rotate(this.asState(), enumblockrotation);
        }

        public BlockState mirror(Mirror enumblockmirror) {
            return this.getBlock().mirror(this.asState(), enumblockmirror);
        }

        public RenderShape getRenderShape() {
            return this.getBlock().getRenderShape(this.asState());
        }

        public boolean emissiveRendering(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.emissiveRendering.test(this.asState(), iblockaccess, blockposition);
        }

        public float getShadeBrightness(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.getBlock().getShadeBrightness(this.asState(), iblockaccess, blockposition);
        }

        public boolean isRedstoneConductor(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.isRedstoneConductor.test(this.asState(), iblockaccess, blockposition);
        }

        public boolean isSignalSource() {
            return this.getBlock().isSignalSource(this.asState());
        }

        public int getSignal(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
            return this.getBlock().getSignal(this.asState(), iblockaccess, blockposition, enumdirection);
        }

        public boolean hasAnalogOutputSignal() {
            return this.getBlock().hasAnalogOutputSignal(this.asState());
        }

        public int getAnalogOutputSignal(Level world, BlockPos blockposition, Direction enumdirection) {
            return this.getBlock().getAnalogOutputSignal(this.asState(), world, blockposition, enumdirection);
        }

        public float getDestroySpeed(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.destroySpeed;
        }

        public float getDestroyProgress(Player entityhuman, BlockGetter iblockaccess, BlockPos blockposition) {
            return this.getBlock().getDestroyProgress(this.asState(), entityhuman, iblockaccess, blockposition);
        }

        public int getDirectSignal(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
            return this.getBlock().getDirectSignal(this.asState(), iblockaccess, blockposition, enumdirection);
        }

        public PushReaction getPistonPushReaction() {
            return this.pushReaction;
        }

        public boolean isSolidRender() {
            return this.solidRender;
        }

        public boolean canOcclude() {
            return this.canOcclude;
        }

        public boolean skipRendering(BlockState iblockdata, Direction enumdirection) {
            return this.getBlock().skipRendering(this.asState(), iblockdata, enumdirection);
        }

        public VoxelShape getShape(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.getShape(iblockaccess, blockposition, CollisionContext.empty());
        }

        public VoxelShape getShape(BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
            return this.getBlock().getShape(this.asState(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape getCollisionShape(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.cache != null ? this.cache.collisionShape : this.getCollisionShape(iblockaccess, blockposition, CollisionContext.empty());
        }

        public VoxelShape getCollisionShape(BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
            return this.getBlock().getCollisionShape(this.asState(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape getEntityInsideCollisionShape(BlockGetter iblockaccess, BlockPos blockposition, Entity entity) {
            return this.getBlock().getEntityInsideCollisionShape(this.asState(), iblockaccess, blockposition, entity);
        }

        public VoxelShape getBlockSupportShape(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.getBlock().getBlockSupportShape(this.asState(), iblockaccess, blockposition);
        }

        public VoxelShape getVisualShape(BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
            return this.getBlock().getVisualShape(this.asState(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape getInteractionShape(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.getBlock().getInteractionShape(this.asState(), iblockaccess, blockposition);
        }

        public final boolean entityCanStandOn(BlockGetter iblockaccess, BlockPos blockposition, Entity entity) {
            return this.entityCanStandOnFace(iblockaccess, blockposition, entity, Direction.UP);
        }

        public final boolean entityCanStandOnFace(BlockGetter iblockaccess, BlockPos blockposition, Entity entity, Direction enumdirection) {
            return Block.isFaceFull(this.getCollisionShape(iblockaccess, blockposition, CollisionContext.of(entity)), enumdirection);
        }

        public Vec3 getOffset(BlockPos blockposition) {
            OffsetFunction blockbase_b = this.offsetFunction;
            return blockbase_b != null ? blockbase_b.evaluate(this.asState(), blockposition) : Vec3.ZERO;
        }

        public boolean hasOffsetFunction() {
            return this.offsetFunction != null;
        }

        public boolean triggerEvent(Level world, BlockPos blockposition, int i, int j) {
            return this.getBlock().triggerEvent(this.asState(), world, blockposition, i, j);
        }

        public void handleNeighborChanged(Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
            this.getBlock().neighborChanged(this.asState(), world, blockposition, block, orientation, flag);
        }

        public final void updateNeighbourShapes(LevelAccessor generatoraccess, BlockPos blockposition, int i) {
            this.updateNeighbourShapes(generatoraccess, blockposition, i, 512);
        }

        public final void updateNeighbourShapes(LevelAccessor generatoraccess, BlockPos blockposition, int i, int j) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (Direction enumdirection : UPDATE_SHAPE_ORDER) {
                blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
                generatoraccess.neighborShapeChanged(enumdirection.getOpposite(), blockposition_mutableblockposition, blockposition, this.asState(), i, j);
            }
        }

        public final void updateIndirectNeighbourShapes(LevelAccessor generatoraccess, BlockPos blockposition, int i) {
            this.updateIndirectNeighbourShapes(generatoraccess, blockposition, i, 512);
        }

        public void updateIndirectNeighbourShapes(LevelAccessor generatoraccess, BlockPos blockposition, int i, int j) {
            this.getBlock().updateIndirectNeighbourShapes(this.asState(), generatoraccess, blockposition, i, j);
        }

        public void onPlace(Level world, BlockPos blockposition, BlockState iblockdata, boolean flag) {
            this.onPlace(world, blockposition, iblockdata, flag, null);
        }

        public void onPlace(Level world, BlockPos blockposition, BlockState iblockdata, boolean flag, @Nullable UseOnContext context) {
            this.getBlock().onPlace(this.asState(), world, blockposition, iblockdata, flag, context);
        }

        public void affectNeighborsAfterRemoval(ServerLevel worldserver, BlockPos blockposition, boolean flag) {
            this.getBlock().affectNeighborsAfterRemoval(this.asState(), worldserver, blockposition, flag);
        }

        public void onExplosionHit(ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
            this.getBlock().onExplosionHit(this.asState(), worldserver, blockposition, explosion, biconsumer);
        }

        public void tick(ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
            this.getBlock().tick(this.asState(), worldserver, blockposition, randomsource);
        }

        public void randomTick(ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
            this.getBlock().randomTick(this.asState(), worldserver, blockposition, randomsource);
        }

        public void entityInside(Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
            this.getBlock().entityInside(this.asState(), world, blockposition, entity, insideblockeffectapplier, flag);
        }

        public void spawnAfterBreak(ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
            this.getBlock().spawnAfterBreak(this.asState(), worldserver, blockposition, itemstack, flag);
        }

        public List<ItemStack> getDrops(LootParams.Builder lootparams_a) {
            return this.getBlock().getDrops(this.asState(), lootparams_a);
        }

        public InteractionResult useItemOn(ItemStack itemstack, Level world, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
            return this.getBlock().useItemOn(itemstack, this.asState(), world, movingobjectpositionblock.getBlockPos(), entityhuman, enumhand, movingobjectpositionblock);
        }

        public InteractionResult useWithoutItem(Level world, Player entityhuman, BlockHitResult movingobjectpositionblock) {
            return this.getBlock().useWithoutItem(this.asState(), world, movingobjectpositionblock.getBlockPos(), entityhuman, movingobjectpositionblock);
        }

        public void attack(Level world, BlockPos blockposition, Player entityhuman) {
            this.getBlock().attack(this.asState(), world, blockposition, entityhuman);
        }

        public boolean isSuffocating(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.isSuffocating.test(this.asState(), iblockaccess, blockposition);
        }

        public boolean isViewBlocking(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.isViewBlocking.test(this.asState(), iblockaccess, blockposition);
        }

        public BlockState updateShape(LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata, RandomSource randomsource) {
            return this.getBlock().updateShape(this.asState(), iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata, randomsource);
        }

        public boolean isPathfindable(PathComputationType pathmode) {
            return this.getBlock().isPathfindable(this.asState(), pathmode);
        }

        public boolean canBeReplaced(BlockPlaceContext blockactioncontext) {
            return this.getBlock().canBeReplaced(this.asState(), blockactioncontext);
        }

        public boolean canBeReplaced(Fluid fluidtype) {
            return this.getBlock().canBeReplaced(this.asState(), fluidtype);
        }

        public boolean canBeReplaced() {
            return this.replaceable;
        }

        public boolean canSurvive(LevelReader iworldreader, BlockPos blockposition) {
            return this.getBlock().canSurvive(this.asState(), iworldreader, blockposition);
        }

        public boolean hasPostProcess(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.hasPostProcess.test(this.asState(), iblockaccess, blockposition);
        }

        @Nullable
        public MenuProvider getMenuProvider(Level world, BlockPos blockposition) {
            return this.getBlock().getMenuProvider(this.asState(), world, blockposition);
        }

        public boolean is(TagKey<Block> tagkey) {
            return this.getBlock().builtInRegistryHolder().is(tagkey);
        }

        public boolean is(TagKey<Block> tagkey, Predicate<BlockStateBase> predicate) {
            return this.is(tagkey) && predicate.test(this);
        }

        public boolean is(HolderSet<Block> holderset) {
            return holderset.contains(this.getBlock().builtInRegistryHolder());
        }

        public boolean is(Holder<Block> holder) {
            return this.is(holder.value());
        }

        public Stream<TagKey<Block>> getTags() {
            return this.getBlock().builtInRegistryHolder().tags();
        }

        public boolean hasBlockEntity() {
            return this.getBlock() instanceof EntityBlock;
        }

        public boolean shouldChangedStateKeepBlockEntity(BlockState iblockdata) {
            return this.getBlock().shouldChangedStateKeepBlockEntity(iblockdata);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockEntityType<T> tileentitytypes) {
            return this.getBlock() instanceof EntityBlock ? ((EntityBlock)((Object)this.getBlock())).getTicker(world, this.asState(), tileentitytypes) : null;
        }

        public boolean is(Block block) {
            return this.getBlock() == block;
        }

        public boolean is(ResourceKey<Block> resourcekey) {
            return this.getBlock().builtInRegistryHolder().is(resourcekey);
        }

        public FluidState getFluidState() {
            return this.fluidState;
        }

        public boolean isRandomlyTicking() {
            return this.isRandomlyTicking;
        }

        public long getSeed(BlockPos blockposition) {
            return this.getBlock().getSeed(this.asState(), blockposition);
        }

        public SoundType getSoundType() {
            return this.getBlock().getSoundType(this.asState());
        }

        public void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
            this.getBlock().onProjectileHit(world, iblockdata, movingobjectpositionblock, iprojectile);
        }

        public boolean isFaceSturdy(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
            return this.isFaceSturdy(iblockaccess, blockposition, enumdirection, SupportType.FULL);
        }

        public boolean isFaceSturdy(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, SupportType enumblocksupport) {
            return this.cache != null ? this.cache.isFaceSturdy(enumdirection, enumblocksupport) : enumblocksupport.isSupporting(this.asState(), iblockaccess, blockposition, enumdirection);
        }

        public boolean isCollisionShapeFullBlock(BlockGetter iblockaccess, BlockPos blockposition) {
            return this.cache != null ? this.cache.isCollisionShapeFullBlock : this.getBlock().isCollisionShapeFullBlock(this.asState(), iblockaccess, blockposition);
        }

        public ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, boolean flag) {
            return this.getBlock().getCloneItemStack(iworldreader, blockposition, this.asState(), flag);
        }

        protected abstract BlockState asState();

        public boolean requiresCorrectToolForDrops() {
            return this.requiresCorrectToolForDrops;
        }

        public boolean shouldSpawnTerrainParticles() {
            return this.spawnTerrainParticles;
        }

        public NoteBlockInstrument instrument() {
            return this.instrument;
        }

        private static final class Cache {
            private static final Direction[] DIRECTIONS = Direction.values();
            private static final int SUPPORT_TYPE_COUNT = SupportType.values().length;
            protected final VoxelShape collisionShape;
            protected final boolean largeCollisionShape;
            private final boolean[] faceSturdy;
            protected final boolean isCollisionShapeFullBlock;

            Cache(BlockState iblockdata) {
                Block block = iblockdata.getBlock();
                this.collisionShape = block.getCollisionShape(iblockdata, EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty());
                if (!this.collisionShape.isEmpty() && iblockdata.hasOffsetFunction()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.BLOCK.getKey(block)));
                }
                this.largeCollisionShape = Arrays.stream(Direction.Axis.values()).anyMatch(enumdirection_enumaxis -> this.collisionShape.min((Direction.Axis)enumdirection_enumaxis) < 0.0 || this.collisionShape.max((Direction.Axis)enumdirection_enumaxis) > 1.0);
                this.faceSturdy = new boolean[DIRECTIONS.length * SUPPORT_TYPE_COUNT];
                for (Direction enumdirection : DIRECTIONS) {
                    for (SupportType enumblocksupport : SupportType.values()) {
                        this.faceSturdy[Cache.getFaceSupportIndex((Direction)enumdirection, (SupportType)enumblocksupport)] = enumblocksupport.isSupporting(iblockdata, EmptyBlockGetter.INSTANCE, BlockPos.ZERO, enumdirection);
                    }
                }
                this.isCollisionShapeFullBlock = Block.isShapeFullBlock(iblockdata.getCollisionShape(EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
            }

            public boolean isFaceSturdy(Direction enumdirection, SupportType enumblocksupport) {
                return this.faceSturdy[Cache.getFaceSupportIndex(enumdirection, enumblocksupport)];
            }

            private static int getFaceSupportIndex(Direction enumdirection, SupportType enumblocksupport) {
                return enumdirection.ordinal() * SUPPORT_TYPE_COUNT + enumblocksupport.ordinal();
            }
        }
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

