/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.FluidState;

public class LevelChunkSection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    public static final int BIOME_CONTAINER_BITS = 2;
    private short nonEmptyBlockCount;
    private short tickingBlockCount;
    private short tickingFluidCount;
    private final PalettedContainer<BlockState> states;
    private PalettedContainer<Holder<Biome>> i;

    private LevelChunkSection(LevelChunkSection chunksection) {
        this.nonEmptyBlockCount = chunksection.nonEmptyBlockCount;
        this.tickingBlockCount = chunksection.tickingBlockCount;
        this.tickingFluidCount = chunksection.tickingFluidCount;
        this.states = chunksection.states.copy();
        this.i = chunksection.i.copy();
    }

    public LevelChunkSection(PalettedContainer<BlockState> datapaletteblock, PalettedContainer<Holder<Biome>> palettedcontainerro) {
        this.states = datapaletteblock;
        this.i = palettedcontainerro;
        this.recalcBlockCounts();
    }

    public LevelChunkSection(PalettedContainerFactory palettedcontainerfactory) {
        this.states = palettedcontainerfactory.createForBlockStates();
        this.i = palettedcontainerfactory.createForBiomes();
    }

    public BlockState getBlockState(int i, int j, int k) {
        return this.states.get(i, j, k);
    }

    public FluidState getFluidState(int i, int j, int k) {
        return this.states.get(i, j, k).getFluidState();
    }

    public void acquire() {
        this.states.acquire();
    }

    public void release() {
        this.states.release();
    }

    public BlockState setBlockState(int i, int j, int k, BlockState iblockdata) {
        return this.setBlockState(i, j, k, iblockdata, true);
    }

    public BlockState setBlockState(int i, int j, int k, BlockState iblockdata, boolean flag) {
        BlockState iblockdata1 = flag ? this.states.getAndSet(i, j, k, iblockdata) : this.states.getAndSetUnchecked(i, j, k, iblockdata);
        FluidState fluid = iblockdata1.getFluidState();
        FluidState fluid1 = iblockdata.getFluidState();
        if (!iblockdata1.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (iblockdata1.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount - 1);
            }
        }
        if (!fluid.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount - 1);
        }
        if (!iblockdata.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (iblockdata.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount + 1);
            }
        }
        if (!fluid1.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount + 1);
        }
        return iblockdata1;
    }

    public boolean hasOnlyAir() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTickingBlocks() || this.isRandomlyTickingFluids();
    }

    public boolean isRandomlyTickingBlocks() {
        return this.tickingBlockCount > 0;
    }

    public boolean isRandomlyTickingFluids() {
        return this.tickingFluidCount > 0;
    }

    public void recalcBlockCounts() {
        class A
        implements PalettedContainer.CountConsumer<BlockState> {
            public int nonEmptyBlockCount;
            public int tickingBlockCount;
            public int tickingFluidCount;

            A(LevelChunkSection this$0) {
            }

            @Override
            public void accept(BlockState iblockdata, int i) {
                FluidState fluid = iblockdata.getFluidState();
                if (!iblockdata.isAir()) {
                    this.nonEmptyBlockCount += i;
                    if (iblockdata.isRandomlyTicking()) {
                        this.tickingBlockCount += i;
                    }
                }
                if (!fluid.isEmpty()) {
                    this.nonEmptyBlockCount += i;
                    if (fluid.isRandomlyTicking()) {
                        this.tickingFluidCount += i;
                    }
                }
            }
        }
        A a0 = new A(this);
        this.states.count(a0);
        this.nonEmptyBlockCount = (short)a0.nonEmptyBlockCount;
        this.tickingBlockCount = (short)a0.tickingBlockCount;
        this.tickingFluidCount = (short)a0.tickingFluidCount;
    }

    public PalettedContainer<BlockState> getStates() {
        return this.states;
    }

    public PalettedContainerRO<Holder<Biome>> getBiomes() {
        return this.i;
    }

    public void read(FriendlyByteBuf packetdataserializer) {
        this.nonEmptyBlockCount = packetdataserializer.readShort();
        this.states.read(packetdataserializer);
        PalettedContainer<Holder<Biome>> datapaletteblock = this.i.recreate();
        datapaletteblock.read(packetdataserializer);
        this.i = datapaletteblock;
    }

    public void readBiomes(FriendlyByteBuf packetdataserializer) {
        PalettedContainer<Holder<Biome>> datapaletteblock = this.i.recreate();
        datapaletteblock.read(packetdataserializer);
        this.i = datapaletteblock;
    }

    public void write(FriendlyByteBuf packetdataserializer) {
        packetdataserializer.writeShort(this.nonEmptyBlockCount);
        this.states.write(packetdataserializer);
        this.i.write(packetdataserializer);
    }

    public int getSerializedSize() {
        return 2 + this.states.getSerializedSize() + this.i.getSerializedSize();
    }

    public boolean maybeHas(Predicate<BlockState> predicate) {
        return this.states.maybeHas(predicate);
    }

    public Holder<Biome> getNoiseBiome(int i, int j, int k) {
        return this.i.get(i, j, k);
    }

    public void setBiome(int i, int j, int k, Holder<Biome> biome) {
        this.i.set(i, j, k, biome);
    }

    public void fillBiomesFromNoise(BiomeResolver biomeresolver, Climate.Sampler climate_sampler, int i, int j, int k) {
        PalettedContainer<Holder<Biome>> datapaletteblock = this.i.recreate();
        int l = 4;
        for (int i1 = 0; i1 < 4; ++i1) {
            for (int j1 = 0; j1 < 4; ++j1) {
                for (int k1 = 0; k1 < 4; ++k1) {
                    datapaletteblock.getAndSetUnchecked(i1, j1, k1, biomeresolver.getNoiseBiome(i + i1, j + j1, k + k1, climate_sampler));
                }
            }
        }
        this.i = datapaletteblock;
    }

    public LevelChunkSection copy() {
        return new LevelChunkSection(this);
    }
}

