/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public class UpgradeData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final UpgradeData EMPTY = new UpgradeData(EmptyBlockGetter.INSTANCE);
    private static final String TAG_INDICES = "Indices";
    private static final Direction8[] DIRECTIONS = Direction8.values();
    private static final Codec<List<SavedTick<Block>>> BLOCK_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.BLOCK.byNameCodec().orElse((Object)Blocks.AIR)).listOf();
    private static final Codec<List<SavedTick<Fluid>>> FLUID_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.FLUID.byNameCodec().orElse((Object)Fluids.EMPTY)).listOf();
    private final EnumSet<Direction8> sides = EnumSet.noneOf(Direction8.class);
    private final List<SavedTick<Block>> neighborBlockTicks = Lists.newArrayList();
    private final List<SavedTick<Fluid>> neighborFluidTicks = Lists.newArrayList();
    private final int[][] index;
    static final Map<Block, BlockFixer> MAP = new IdentityHashMap<Block, BlockFixer>();
    static final Set<BlockFixer> CHUNKY_FIXERS = Sets.newHashSet();

    private UpgradeData(LevelHeightAccessor var0) {
        this.index = new int[var0.getSectionsCount()][];
    }

    public UpgradeData(CompoundTag var02, LevelHeightAccessor var1) {
        this(var1);
        var02.getCompound(TAG_INDICES).ifPresent(var0 -> {
            for (int var1 = 0; var1 < this.index.length; ++var1) {
                this.index[var1] = var0.getIntArray(String.valueOf(var1)).orElse(null);
            }
        });
        int var2 = var02.getIntOr("Sides", 0);
        for (Direction8 var6 : Direction8.values()) {
            if ((var2 & 1 << var6.ordinal()) == 0) continue;
            this.sides.add(var6);
        }
        var02.read("neighbor_block_ticks", BLOCK_TICKS_CODEC).ifPresent(this.neighborBlockTicks::addAll);
        var02.read("neighbor_fluid_ticks", FLUID_TICKS_CODEC).ifPresent(this.neighborFluidTicks::addAll);
    }

    private UpgradeData(UpgradeData var0) {
        this.sides.addAll(var0.sides);
        this.neighborBlockTicks.addAll(var0.neighborBlockTicks);
        this.neighborFluidTicks.addAll(var0.neighborFluidTicks);
        this.index = new int[var0.index.length][];
        for (int var1 = 0; var1 < var0.index.length; ++var1) {
            int[] var2 = var0.index[var1];
            this.index[var1] = var2 != null ? IntArrays.copy((int[])var2) : null;
        }
    }

    public void upgrade(LevelChunk var0) {
        this.upgradeInside(var0);
        for (Direction8 var4 : DIRECTIONS) {
            UpgradeData.upgradeSides(var0, var4);
        }
        Level var12 = var0.getLevel();
        this.neighborBlockTicks.forEach(var1 -> {
            Block var2 = var1.type() == Blocks.AIR ? var12.getBlockState(var1.pos()).getBlock() : (Block)var1.type();
            var12.scheduleTick(var1.pos(), var2, var1.delay(), var1.priority());
        });
        this.neighborFluidTicks.forEach(var1 -> {
            Fluid var2 = var1.type() == Fluids.EMPTY ? var12.getFluidState(var1.pos()).getType() : (Fluid)var1.type();
            var12.scheduleTick(var1.pos(), var2, var1.delay(), var1.priority());
        });
        CHUNKY_FIXERS.forEach(var1 -> var1.processChunk(var12));
    }

    private static void upgradeSides(LevelChunk var0, Direction8 var1) {
        Level var2 = var0.getLevel();
        if (!var0.getUpgradeData().sides.remove((Object)var1)) {
            return;
        }
        Set<Direction> var3 = var1.getDirections();
        boolean var4 = false;
        int var5 = 15;
        boolean var6 = var3.contains(Direction.EAST);
        boolean var7 = var3.contains(Direction.WEST);
        boolean var8 = var3.contains(Direction.SOUTH);
        boolean var9 = var3.contains(Direction.NORTH);
        boolean var10 = var3.size() == 1;
        ChunkPos var11 = var0.getPos();
        int var12 = var11.getMinBlockX() + (var10 && (var9 || var8) ? 1 : (var7 ? 0 : 15));
        int var13 = var11.getMinBlockX() + (var10 && (var9 || var8) ? 14 : (var7 ? 0 : 15));
        int var14 = var11.getMinBlockZ() + (var10 && (var6 || var7) ? 1 : (var9 ? 0 : 15));
        int var15 = var11.getMinBlockZ() + (var10 && (var6 || var7) ? 14 : (var9 ? 0 : 15));
        Direction[] var16 = Direction.values();
        BlockPos.MutableBlockPos var17 = new BlockPos.MutableBlockPos();
        for (BlockPos var19 : BlockPos.betweenClosed(var12, var2.getMinY(), var14, var13, var2.getMaxY(), var15)) {
            BlockState var20;
            BlockState var21 = var20 = var2.getBlockState(var19);
            for (Direction var25 : var16) {
                var17.setWithOffset((Vec3i)var19, var25);
                var21 = UpgradeData.updateState(var21, var25, var2, var19, var17);
            }
            Block.updateOrDestroy(var20, var21, var2, var19, 18);
        }
    }

    private static BlockState updateState(BlockState var0, Direction var1, LevelAccessor var2, BlockPos var3, BlockPos var4) {
        return MAP.getOrDefault(var0.getBlock(), BlockFixers.DEFAULT).updateShape(var0, var1, var2.getBlockState(var4), var2, var3, var4);
    }

    private void upgradeInside(LevelChunk var0) {
        int var5;
        BlockPos.MutableBlockPos var1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos var2 = new BlockPos.MutableBlockPos();
        ChunkPos var3 = var0.getPos();
        Level var4 = var0.getLevel();
        for (var5 = 0; var5 < this.index.length; ++var5) {
            LevelChunkSection var6 = var0.getSection(var5);
            int[] var7 = this.index[var5];
            this.index[var5] = null;
            if (var7 == null || var7.length <= 0) continue;
            Direction[] var8 = Direction.values();
            PalettedContainer<BlockState> var9 = var6.getStates();
            int var10 = var0.getSectionYFromSectionIndex(var5);
            int var11 = SectionPos.sectionToBlockCoord(var10);
            for (int var15 : var7) {
                BlockState var19;
                int var16 = var15 & 0xF;
                int var17 = var15 >> 8 & 0xF;
                int var18 = var15 >> 4 & 0xF;
                var1.set(var3.getMinBlockX() + var16, var11 + var17, var3.getMinBlockZ() + var18);
                BlockState var20 = var19 = var9.get(var15);
                for (Direction var24 : var8) {
                    var2.setWithOffset((Vec3i)var1, var24);
                    if (SectionPos.blockToSectionCoord(var1.getX()) != var3.x || SectionPos.blockToSectionCoord(var1.getZ()) != var3.z) continue;
                    var20 = UpgradeData.updateState(var20, var24, var4, var1, var2);
                }
                Block.updateOrDestroy(var19, var20, var4, var1, 18);
            }
        }
        for (var5 = 0; var5 < this.index.length; ++var5) {
            if (this.index[var5] != null) {
                LOGGER.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{var4.getSectionYFromSectionIndex(var5), var3.x, var3.z});
            }
            this.index[var5] = null;
        }
    }

    public boolean isEmpty() {
        for (int[] var3 : this.index) {
            if (var3 == null) continue;
            return false;
        }
        return this.sides.isEmpty();
    }

    public CompoundTag write() {
        int var2;
        CompoundTag var0 = new CompoundTag();
        CompoundTag var1 = new CompoundTag();
        for (var2 = 0; var2 < this.index.length; ++var2) {
            String var3 = String.valueOf(var2);
            if (this.index[var2] == null || this.index[var2].length == 0) continue;
            var1.putIntArray(var3, this.index[var2]);
        }
        if (!var1.isEmpty()) {
            var0.put(TAG_INDICES, var1);
        }
        var2 = 0;
        for (Direction8 var4 : this.sides) {
            var2 |= 1 << var4.ordinal();
        }
        var0.putByte("Sides", (byte)var2);
        if (!this.neighborBlockTicks.isEmpty()) {
            var0.store("neighbor_block_ticks", BLOCK_TICKS_CODEC, this.neighborBlockTicks);
        }
        if (!this.neighborFluidTicks.isEmpty()) {
            var0.store("neighbor_fluid_ticks", FLUID_TICKS_CODEC, this.neighborFluidTicks);
        }
        return var0;
    }

    public UpgradeData copy() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return new UpgradeData(this);
    }

    static enum BlockFixers implements BlockFixer
    {
        BLACKLIST(new Block[]{Blocks.OBSERVER, Blocks.NETHER_PORTAL, Blocks.WHITE_CONCRETE_POWDER, Blocks.ORANGE_CONCRETE_POWDER, Blocks.MAGENTA_CONCRETE_POWDER, Blocks.LIGHT_BLUE_CONCRETE_POWDER, Blocks.YELLOW_CONCRETE_POWDER, Blocks.LIME_CONCRETE_POWDER, Blocks.PINK_CONCRETE_POWDER, Blocks.GRAY_CONCRETE_POWDER, Blocks.LIGHT_GRAY_CONCRETE_POWDER, Blocks.CYAN_CONCRETE_POWDER, Blocks.PURPLE_CONCRETE_POWDER, Blocks.BLUE_CONCRETE_POWDER, Blocks.BROWN_CONCRETE_POWDER, Blocks.GREEN_CONCRETE_POWDER, Blocks.RED_CONCRETE_POWDER, Blocks.BLACK_CONCRETE_POWDER, Blocks.ANVIL, Blocks.CHIPPED_ANVIL, Blocks.DAMAGED_ANVIL, Blocks.DRAGON_EGG, Blocks.GRAVEL, Blocks.SAND, Blocks.RED_SAND, Blocks.OAK_SIGN, Blocks.SPRUCE_SIGN, Blocks.BIRCH_SIGN, Blocks.ACACIA_SIGN, Blocks.CHERRY_SIGN, Blocks.JUNGLE_SIGN, Blocks.DARK_OAK_SIGN, Blocks.PALE_OAK_SIGN, Blocks.OAK_WALL_SIGN, Blocks.SPRUCE_WALL_SIGN, Blocks.BIRCH_WALL_SIGN, Blocks.ACACIA_WALL_SIGN, Blocks.JUNGLE_WALL_SIGN, Blocks.DARK_OAK_WALL_SIGN, Blocks.PALE_OAK_WALL_SIGN, Blocks.OAK_HANGING_SIGN, Blocks.SPRUCE_HANGING_SIGN, Blocks.BIRCH_HANGING_SIGN, Blocks.ACACIA_HANGING_SIGN, Blocks.JUNGLE_HANGING_SIGN, Blocks.DARK_OAK_HANGING_SIGN, Blocks.PALE_OAK_HANGING_SIGN, Blocks.OAK_WALL_HANGING_SIGN, Blocks.SPRUCE_WALL_HANGING_SIGN, Blocks.BIRCH_WALL_HANGING_SIGN, Blocks.ACACIA_WALL_HANGING_SIGN, Blocks.JUNGLE_WALL_HANGING_SIGN, Blocks.DARK_OAK_WALL_HANGING_SIGN, Blocks.PALE_OAK_WALL_HANGING_SIGN}){

            @Override
            public BlockState updateShape(BlockState var0, Direction var1, BlockState var2, LevelAccessor var3, BlockPos var4, BlockPos var5) {
                return var0;
            }
        }
        ,
        DEFAULT(new Block[0]){

            @Override
            public BlockState updateShape(BlockState var0, Direction var1, BlockState var2, LevelAccessor var3, BlockPos var4, BlockPos var5) {
                return var0.updateShape(var3, var3, var4, var1, var5, var3.getBlockState(var5), var3.getRandom());
            }
        }
        ,
        CHEST(new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST}){

            @Override
            public BlockState updateShape(BlockState var0, Direction var1, BlockState var2, LevelAccessor var3, BlockPos var4, BlockPos var5) {
                if (var2.is(var0.getBlock()) && var1.getAxis().isHorizontal() && var0.getValue(ChestBlock.TYPE) == ChestType.SINGLE && var2.getValue(ChestBlock.TYPE) == ChestType.SINGLE) {
                    Direction var6 = var0.getValue(ChestBlock.FACING);
                    if (var1.getAxis() != var6.getAxis() && var6 == var2.getValue(ChestBlock.FACING)) {
                        ChestType var7 = var1 == var6.getClockWise() ? ChestType.LEFT : ChestType.RIGHT;
                        var3.setBlock(var5, (BlockState)var2.setValue(ChestBlock.TYPE, var7.getOpposite()), 18);
                        if (var6 == Direction.NORTH || var6 == Direction.EAST) {
                            BlockEntity var8 = var3.getBlockEntity(var4);
                            BlockEntity var9 = var3.getBlockEntity(var5);
                            if (var8 instanceof ChestBlockEntity && var9 instanceof ChestBlockEntity) {
                                ChestBlockEntity.swapContents((ChestBlockEntity)var8, (ChestBlockEntity)var9);
                            }
                        }
                        return (BlockState)var0.setValue(ChestBlock.TYPE, var7);
                    }
                }
                return var0;
            }
        }
        ,
        LEAVES(true, new Block[]{Blocks.ACACIA_LEAVES, Blocks.CHERRY_LEAVES, Blocks.BIRCH_LEAVES, Blocks.PALE_OAK_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES}){
            private final ThreadLocal<List<ObjectSet<BlockPos>>> queue = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public BlockState updateShape(BlockState var0, Direction var1, BlockState var2, LevelAccessor var3, BlockPos var4, BlockPos var5) {
                BlockState var6 = var0.updateShape(var3, var3, var4, var1, var5, var3.getBlockState(var5), var3.getRandom());
                if (var0 != var6) {
                    int var7 = var6.getValue(BlockStateProperties.DISTANCE);
                    List<ObjectSet<BlockPos>> var8 = this.queue.get();
                    if (var8.isEmpty()) {
                        for (int var9 = 0; var9 < 7; ++var9) {
                            var8.add((ObjectSet<BlockPos>)new ObjectOpenHashSet());
                        }
                    }
                    var8.get(var7).add((Object)var4.immutable());
                }
                return var0;
            }

            @Override
            public void processChunk(LevelAccessor var0) {
                BlockPos.MutableBlockPos var1 = new BlockPos.MutableBlockPos();
                List<ObjectSet<BlockPos>> var2 = this.queue.get();
                for (int var3 = 2; var3 < var2.size(); ++var3) {
                    int var4 = var3 - 1;
                    ObjectSet<BlockPos> var5 = var2.get(var4);
                    ObjectSet<BlockPos> var6 = var2.get(var3);
                    for (BlockPos var8 : var5) {
                        BlockState var9 = var0.getBlockState(var8);
                        if (var9.getValue(BlockStateProperties.DISTANCE) < var4) continue;
                        var0.setBlock(var8, (BlockState)var9.setValue(BlockStateProperties.DISTANCE, var4), 18);
                        if (var3 == 7) continue;
                        for (Direction var13 : DIRECTIONS) {
                            var1.setWithOffset((Vec3i)var8, var13);
                            BlockState var14 = var0.getBlockState(var1);
                            if (!var14.hasProperty(BlockStateProperties.DISTANCE) || var9.getValue(BlockStateProperties.DISTANCE) <= var3) continue;
                            var6.add((Object)var1.immutable());
                        }
                    }
                }
                var2.clear();
            }
        }
        ,
        STEM_BLOCK(new Block[]{Blocks.MELON_STEM, Blocks.PUMPKIN_STEM}){

            @Override
            public BlockState updateShape(BlockState var0, Direction var1, BlockState var2, LevelAccessor var3, BlockPos var4, BlockPos var5) {
                if (var0.getValue(StemBlock.AGE) == 7) {
                    Block var6;
                    Block block = var6 = var0.is(Blocks.PUMPKIN_STEM) ? Blocks.PUMPKIN : Blocks.MELON;
                    if (var2.is(var6)) {
                        return (BlockState)(var0.is(Blocks.PUMPKIN_STEM) ? Blocks.ATTACHED_PUMPKIN_STEM : Blocks.ATTACHED_MELON_STEM).defaultBlockState().setValue(HorizontalDirectionalBlock.FACING, var1);
                    }
                }
                return var0;
            }
        };

        public static final Direction[] DIRECTIONS;

        BlockFixers(Block ... var2) {
            this(false, var2);
        }

        BlockFixers(boolean var2, Block ... var3) {
            for (Block var7 : var3) {
                MAP.put(var7, this);
            }
            if (var2) {
                CHUNKY_FIXERS.add(this);
            }
        }

        static {
            DIRECTIONS = Direction.values();
        }
    }

    public static interface BlockFixer {
        public BlockState updateShape(BlockState var1, Direction var2, BlockState var3, LevelAccessor var4, BlockPos var5, BlockPos var6);

        default public void processChunk(LevelAccessor var0) {
        }
    }
}

