/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;

public abstract class Column {
    public static Range around(int var0, int var1) {
        return new Range(var0 - 1, var1 + 1);
    }

    public static Range inside(int var0, int var1) {
        return new Range(var0, var1);
    }

    public static Column below(int var0) {
        return new Ray(var0, false);
    }

    public static Column fromHighest(int var0) {
        return new Ray(var0 + 1, false);
    }

    public static Column above(int var0) {
        return new Ray(var0, true);
    }

    public static Column fromLowest(int var0) {
        return new Ray(var0 - 1, true);
    }

    public static Column line() {
        return Line.INSTANCE;
    }

    public static Column create(OptionalInt var0, OptionalInt var1) {
        if (var0.isPresent() && var1.isPresent()) {
            return Column.inside(var0.getAsInt(), var1.getAsInt());
        }
        if (var0.isPresent()) {
            return Column.above(var0.getAsInt());
        }
        if (var1.isPresent()) {
            return Column.below(var1.getAsInt());
        }
        return Column.line();
    }

    public abstract OptionalInt getCeiling();

    public abstract OptionalInt getFloor();

    public abstract OptionalInt getHeight();

    public Column withFloor(OptionalInt var0) {
        return Column.create(var0, this.getCeiling());
    }

    public Column withCeiling(OptionalInt var0) {
        return Column.create(this.getFloor(), var0);
    }

    public static Optional<Column> scan(LevelSimulatedReader var0, BlockPos var1, int var2, Predicate<BlockState> var3, Predicate<BlockState> var4) {
        BlockPos.MutableBlockPos var5 = var1.mutable();
        if (!var0.isStateAtPosition(var1, var3)) {
            return Optional.empty();
        }
        int var6 = var1.getY();
        OptionalInt var7 = Column.scanDirection(var0, var2, var3, var4, var5, var6, Direction.UP);
        OptionalInt var8 = Column.scanDirection(var0, var2, var3, var4, var5, var6, Direction.DOWN);
        return Optional.of(Column.create(var8, var7));
    }

    private static OptionalInt scanDirection(LevelSimulatedReader var0, int var1, Predicate<BlockState> var2, Predicate<BlockState> var3, BlockPos.MutableBlockPos var4, int var5, Direction var6) {
        var4.setY(var5);
        for (int var7 = 1; var7 < var1 && var0.isStateAtPosition(var4, var2); ++var7) {
            var4.move(var6);
        }
        return var0.isStateAtPosition(var4, var3) ? OptionalInt.of(var4.getY()) : OptionalInt.empty();
    }

    public static final class Range
    extends Column {
        private final int floor;
        private final int ceiling;

        protected Range(int var0, int var1) {
            this.floor = var0;
            this.ceiling = var1;
            if (this.height() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + String.valueOf(this));
            }
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.of(this.ceiling);
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.of(this.floor);
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.of(this.height());
        }

        public int ceiling() {
            return this.ceiling;
        }

        public int floor() {
            return this.floor;
        }

        public int height() {
            return this.ceiling - this.floor - 1;
        }

        public String toString() {
            return "C(" + this.ceiling + "-" + this.floor + ")";
        }
    }

    public static final class Ray
    extends Column {
        private final int edge;
        private final boolean pointingUp;

        public Ray(int var0, boolean var1) {
            this.edge = var0;
            this.pointingUp = var1;
        }

        @Override
        public OptionalInt getCeiling() {
            return this.pointingUp ? OptionalInt.empty() : OptionalInt.of(this.edge);
        }

        @Override
        public OptionalInt getFloor() {
            return this.pointingUp ? OptionalInt.of(this.edge) : OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return this.pointingUp ? "C(" + this.edge + "-)" : "C(-" + this.edge + ")";
        }
    }

    public static final class Line
    extends Column {
        static final Line INSTANCE = new Line();

        private Line() {
        }

        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getFloor() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        public String toString() {
            return "C(-)";
        }
    }
}

