/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class RandomState {
    final PositionalRandomFactory random;
    private final HolderGetter<NormalNoise.NoiseParameters> noises;
    private final NoiseRouter router;
    private final Climate.Sampler sampler;
    private final SurfaceSystem surfaceSystem;
    private final PositionalRandomFactory aquiferRandom;
    private final PositionalRandomFactory oreRandom;
    private final Map<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise> noiseIntances;
    private final Map<ResourceLocation, PositionalRandomFactory> positionalRandoms;

    public static RandomState create(HolderGetter.Provider var0, ResourceKey<NoiseGeneratorSettings> var1, long var2) {
        return RandomState.create(var0.lookupOrThrow(Registries.NOISE_SETTINGS).getOrThrow(var1).value(), var0.lookupOrThrow(Registries.NOISE), var2);
    }

    public static RandomState create(NoiseGeneratorSettings var0, HolderGetter<NormalNoise.NoiseParameters> var1, long var2) {
        return new RandomState(var0, var1, var2);
    }

    private RandomState(NoiseGeneratorSettings var0, HolderGetter<NormalNoise.NoiseParameters> var1, long var2) {
        this.random = var0.getRandomSource().newInstance(var2).forkPositional();
        this.noises = var1;
        this.aquiferRandom = this.random.fromHashOf(ResourceLocation.withDefaultNamespace("aquifer")).forkPositional();
        this.oreRandom = this.random.fromHashOf(ResourceLocation.withDefaultNamespace("ore")).forkPositional();
        this.noiseIntances = new ConcurrentHashMap<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise>();
        this.positionalRandoms = new ConcurrentHashMap<ResourceLocation, PositionalRandomFactory>();
        this.surfaceSystem = new SurfaceSystem(this, var0.defaultBlock(), var0.seaLevel(), this.random);
        boolean var4 = var0.useLegacyRandomSource();
        class NoiseWiringHelper
        implements DensityFunction.Visitor {
            private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
            final /* synthetic */ long val$seed;
            final /* synthetic */ boolean val$useLegacyInit;

            NoiseWiringHelper(long l, boolean bl) {
                this.val$seed = l;
                this.val$useLegacyInit = bl;
            }

            private RandomSource newLegacyInstance(long var0) {
                return new LegacyRandomSource(this.val$seed + var0);
            }

            @Override
            public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder var0) {
                Holder<NormalNoise.NoiseParameters> var1 = var0.noiseData();
                if (this.val$useLegacyInit) {
                    if (var1.is(Noises.TEMPERATURE)) {
                        NormalNoise var2 = NormalNoise.createLegacyNetherBiome(this.newLegacyInstance(0L), new NormalNoise.NoiseParameters(-7, 1.0, 1.0));
                        return new DensityFunction.NoiseHolder(var1, var2);
                    }
                    if (var1.is(Noises.VEGETATION)) {
                        NormalNoise var2 = NormalNoise.createLegacyNetherBiome(this.newLegacyInstance(1L), new NormalNoise.NoiseParameters(-7, 1.0, 1.0));
                        return new DensityFunction.NoiseHolder(var1, var2);
                    }
                    if (var1.is(Noises.SHIFT)) {
                        NormalNoise var2 = NormalNoise.create(RandomState.this.random.fromHashOf(Noises.SHIFT.location()), new NormalNoise.NoiseParameters(0, 0.0, new double[0]));
                        return new DensityFunction.NoiseHolder(var1, var2);
                    }
                }
                NormalNoise var2 = RandomState.this.getOrCreateNoise(var1.unwrapKey().orElseThrow());
                return new DensityFunction.NoiseHolder(var1, var2);
            }

            private DensityFunction wrapNew(DensityFunction var0) {
                if (var0 instanceof BlendedNoise) {
                    BlendedNoise var1 = (BlendedNoise)var0;
                    RandomSource var2 = this.val$useLegacyInit ? this.newLegacyInstance(0L) : RandomState.this.random.fromHashOf(ResourceLocation.withDefaultNamespace("terrain"));
                    return var1.withNewRandom(var2);
                }
                if (var0 instanceof DensityFunctions.EndIslandDensityFunction) {
                    return new DensityFunctions.EndIslandDensityFunction(this.val$seed);
                }
                return var0;
            }

            @Override
            public DensityFunction apply(DensityFunction var0) {
                return this.wrapped.computeIfAbsent(var0, this::wrapNew);
            }
        }
        this.router = var0.noiseRouter().mapAll(new NoiseWiringHelper(var2, var4));
        DensityFunction.Visitor var5 = new DensityFunction.Visitor(this){
            private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();

            private DensityFunction wrapNew(DensityFunction var0) {
                if (var0 instanceof DensityFunctions.HolderHolder) {
                    DensityFunctions.HolderHolder var1 = (DensityFunctions.HolderHolder)var0;
                    return var1.function().value();
                }
                if (var0 instanceof DensityFunctions.Marker) {
                    DensityFunctions.Marker var1 = (DensityFunctions.Marker)var0;
                    return var1.wrapped();
                }
                return var0;
            }

            @Override
            public DensityFunction apply(DensityFunction var0) {
                return this.wrapped.computeIfAbsent(var0, this::wrapNew);
            }
        };
        this.sampler = new Climate.Sampler(this.router.temperature().mapAll(var5), this.router.vegetation().mapAll(var5), this.router.continents().mapAll(var5), this.router.erosion().mapAll(var5), this.router.depth().mapAll(var5), this.router.ridges().mapAll(var5), var0.spawnTarget());
    }

    public NormalNoise getOrCreateNoise(ResourceKey<NormalNoise.NoiseParameters> var0) {
        return this.noiseIntances.computeIfAbsent(var0, var1 -> Noises.instantiate(this.noises, this.random, var0));
    }

    public PositionalRandomFactory getOrCreateRandomFactory(ResourceLocation var0) {
        return this.positionalRandoms.computeIfAbsent(var0, var1 -> this.random.fromHashOf(var0).forkPositional());
    }

    public NoiseRouter router() {
        return this.router;
    }

    public Climate.Sampler sampler() {
        return this.sampler;
    }

    public SurfaceSystem surfaceSystem() {
        return this.surfaceSystem;
    }

    public PositionalRandomFactory aquiferRandom() {
        return this.aquiferRandom;
    }

    public PositionalRandomFactory oreRandom() {
        return this.oreRandom;
    }
}

