/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import java.util.concurrent.atomic.AtomicLong;

public final class RandomSupport {
    public static final long GOLDEN_RATIO_64 = -7046029254386353131L;
    public static final long SILVER_RATIO_64 = 7640891576956012809L;
    private static final HashFunction MD5_128 = Hashing.md5();
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);

    @VisibleForTesting
    public static long mixStafford13(long var0) {
        var0 = (var0 ^ var0 >>> 30) * -4658895280553007687L;
        var0 = (var0 ^ var0 >>> 27) * -7723592293110705685L;
        return var0 ^ var0 >>> 31;
    }

    public static Seed128bit upgradeSeedTo128bitUnmixed(long var0) {
        long var2 = var0 ^ 0x6A09E667F3BCC909L;
        long var4 = var2 + -7046029254386353131L;
        return new Seed128bit(var2, var4);
    }

    public static Seed128bit upgradeSeedTo128bit(long var0) {
        return RandomSupport.upgradeSeedTo128bitUnmixed(var0).mixed();
    }

    public static Seed128bit seedFromHashOf(String var0) {
        byte[] var1 = MD5_128.hashString((CharSequence)var0, Charsets.UTF_8).asBytes();
        long var2 = Longs.fromBytes((byte)var1[0], (byte)var1[1], (byte)var1[2], (byte)var1[3], (byte)var1[4], (byte)var1[5], (byte)var1[6], (byte)var1[7]);
        long var4 = Longs.fromBytes((byte)var1[8], (byte)var1[9], (byte)var1[10], (byte)var1[11], (byte)var1[12], (byte)var1[13], (byte)var1[14], (byte)var1[15]);
        return new Seed128bit(var2, var4);
    }

    public static long generateUniqueSeed() {
        return SEED_UNIQUIFIER.updateAndGet(var0 -> var0 * 1181783497276652981L) ^ System.nanoTime();
    }

    public record Seed128bit(long seedLo, long seedHi) {
        public Seed128bit xor(long var0, long var2) {
            return new Seed128bit(this.seedLo ^ var0, this.seedHi ^ var2);
        }

        public Seed128bit xor(Seed128bit var0) {
            return this.xor(var0.seedLo, var0.seedHi);
        }

        public Seed128bit mixed() {
            return new Seed128bit(RandomSupport.mixStafford13(this.seedLo), RandomSupport.mixStafford13(this.seedHi));
        }
    }
}

