/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SurfaceRules {
    public static final ConditionSource ON_FLOOR = SurfaceRules.stoneDepthCheck(0, false, CaveSurface.FLOOR);
    public static final ConditionSource UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, CaveSurface.FLOOR);
    public static final ConditionSource DEEP_UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, 6, CaveSurface.FLOOR);
    public static final ConditionSource VERY_DEEP_UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, 30, CaveSurface.FLOOR);
    public static final ConditionSource ON_CEILING = SurfaceRules.stoneDepthCheck(0, false, CaveSurface.CEILING);
    public static final ConditionSource UNDER_CEILING = SurfaceRules.stoneDepthCheck(0, true, CaveSurface.CEILING);

    public static ConditionSource stoneDepthCheck(int var0, boolean var1, CaveSurface var2) {
        return new StoneDepthCheck(var0, var1, 0, var2);
    }

    public static ConditionSource stoneDepthCheck(int var0, boolean var1, int var2, CaveSurface var3) {
        return new StoneDepthCheck(var0, var1, var2, var3);
    }

    public static ConditionSource not(ConditionSource var0) {
        return new NotConditionSource(var0);
    }

    public static ConditionSource yBlockCheck(VerticalAnchor var0, int var1) {
        return new YConditionSource(var0, var1, false);
    }

    public static ConditionSource yStartCheck(VerticalAnchor var0, int var1) {
        return new YConditionSource(var0, var1, true);
    }

    public static ConditionSource waterBlockCheck(int var0, int var1) {
        return new WaterConditionSource(var0, var1, false);
    }

    public static ConditionSource waterStartCheck(int var0, int var1) {
        return new WaterConditionSource(var0, var1, true);
    }

    @SafeVarargs
    public static ConditionSource isBiome(ResourceKey<Biome> ... var0) {
        return SurfaceRules.isBiome(List.of(var0));
    }

    private static BiomeConditionSource isBiome(List<ResourceKey<Biome>> var0) {
        return new BiomeConditionSource(var0);
    }

    public static ConditionSource noiseCondition(ResourceKey<NormalNoise.NoiseParameters> var0, double var1) {
        return SurfaceRules.noiseCondition(var0, var1, Double.MAX_VALUE);
    }

    public static ConditionSource noiseCondition(ResourceKey<NormalNoise.NoiseParameters> var0, double var1, double var3) {
        return new NoiseThresholdConditionSource(var0, var1, var3);
    }

    public static ConditionSource verticalGradient(String var0, VerticalAnchor var1, VerticalAnchor var2) {
        return new VerticalGradientConditionSource(ResourceLocation.parse(var0), var1, var2);
    }

    public static ConditionSource steep() {
        return Steep.INSTANCE;
    }

    public static ConditionSource hole() {
        return Hole.INSTANCE;
    }

    public static ConditionSource abovePreliminarySurface() {
        return AbovePreliminarySurface.INSTANCE;
    }

    public static ConditionSource temperature() {
        return Temperature.INSTANCE;
    }

    public static RuleSource ifTrue(ConditionSource var0, RuleSource var1) {
        return new TestRuleSource(var0, var1);
    }

    public static RuleSource sequence(RuleSource ... var0) {
        if (var0.length == 0) {
            throw new IllegalArgumentException("Need at least 1 rule for a sequence");
        }
        return new SequenceRuleSource(Arrays.asList(var0));
    }

    public static RuleSource state(BlockState var0) {
        return new BlockRuleSource(var0);
    }

    public static RuleSource bandlands() {
        return Bandlands.INSTANCE;
    }

    static <A> MapCodec<? extends A> register(Registry<MapCodec<? extends A>> var0, String var1, KeyDispatchDataCodec<? extends A> var2) {
        return Registry.register(var0, var1, var2.codec());
    }

    static final class StoneDepthCheck
    extends Record
    implements ConditionSource {
        final int offset;
        final boolean addSurfaceDepth;
        final int secondaryDepthRange;
        private final CaveSurface surfaceType;
        static final KeyDispatchDataCodec<StoneDepthCheck> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.fieldOf("offset").forGetter(StoneDepthCheck::offset), (App)Codec.BOOL.fieldOf("add_surface_depth").forGetter(StoneDepthCheck::addSurfaceDepth), (App)Codec.INT.fieldOf("secondary_depth_range").forGetter(StoneDepthCheck::secondaryDepthRange), (App)CaveSurface.CODEC.fieldOf("surface_type").forGetter(StoneDepthCheck::surfaceType)).apply((Applicative)var0, StoneDepthCheck::new)));

        StoneDepthCheck(int var0, boolean var1, int var2, CaveSurface var3) {
            this.offset = var0;
            this.addSurfaceDepth = var1;
            this.secondaryDepthRange = var2;
            this.surfaceType = var3;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            boolean var1 = this.surfaceType == CaveSurface.CEILING;
            class StoneDepthCondition
            extends LazyYCondition {
                final /* synthetic */ Context val$ruleContext;
                final /* synthetic */ boolean val$ceiling;

                StoneDepthCondition(Context context, boolean bl) {
                    this.val$ruleContext = context;
                    this.val$ceiling = bl;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    int var0 = this.val$ceiling ? this.context.stoneDepthBelow : this.context.stoneDepthAbove;
                    int var1 = StoneDepthCheck.this.addSurfaceDepth ? this.context.surfaceDepth : 0;
                    int var2 = StoneDepthCheck.this.secondaryDepthRange == 0 ? 0 : (int)Mth.map(this.context.getSurfaceSecondary(), -1.0, 1.0, 0.0, (double)StoneDepthCheck.this.secondaryDepthRange);
                    return var0 <= 1 + StoneDepthCheck.this.offset + var1 + var2;
                }
            }
            return new StoneDepthCondition(var0, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "offset", "addSurfaceDepth", "secondaryDepthRange", "surfaceType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "offset", "addSurfaceDepth", "secondaryDepthRange", "surfaceType"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "offset", "addSurfaceDepth", "secondaryDepthRange", "surfaceType"}, this, var0);
        }

        public int offset() {
            return this.offset;
        }

        public boolean addSurfaceDepth() {
            return this.addSurfaceDepth;
        }

        public int secondaryDepthRange() {
            return this.secondaryDepthRange;
        }

        public CaveSurface surfaceType() {
            return this.surfaceType;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record NotConditionSource(ConditionSource target) implements ConditionSource
    {
        static final KeyDispatchDataCodec<NotConditionSource> CODEC = KeyDispatchDataCodec.of(ConditionSource.CODEC.xmap(NotConditionSource::new, NotConditionSource::target).fieldOf("invert"));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            return new NotCondition((Condition)this.target.apply(var0));
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    public static interface ConditionSource
    extends Function<Context, Condition> {
        public static final Codec<ConditionSource> CODEC = BuiltInRegistries.MATERIAL_CONDITION.byNameCodec().dispatch(var0 -> var0.codec().codec(), Function.identity());

        public static MapCodec<? extends ConditionSource> bootstrap(Registry<MapCodec<? extends ConditionSource>> var0) {
            SurfaceRules.register(var0, "biome", BiomeConditionSource.CODEC);
            SurfaceRules.register(var0, "noise_threshold", NoiseThresholdConditionSource.CODEC);
            SurfaceRules.register(var0, "vertical_gradient", VerticalGradientConditionSource.CODEC);
            SurfaceRules.register(var0, "y_above", YConditionSource.CODEC);
            SurfaceRules.register(var0, "water", WaterConditionSource.CODEC);
            SurfaceRules.register(var0, "temperature", Temperature.CODEC);
            SurfaceRules.register(var0, "steep", Steep.CODEC);
            SurfaceRules.register(var0, "not", NotConditionSource.CODEC);
            SurfaceRules.register(var0, "hole", Hole.CODEC);
            SurfaceRules.register(var0, "above_preliminary_surface", AbovePreliminarySurface.CODEC);
            return SurfaceRules.register(var0, "stone_depth", StoneDepthCheck.CODEC);
        }

        public KeyDispatchDataCodec<? extends ConditionSource> codec();
    }

    static final class YConditionSource
    extends Record
    implements ConditionSource {
        final VerticalAnchor anchor;
        final int surfaceDepthMultiplier;
        final boolean addStoneDepth;
        static final KeyDispatchDataCodec<YConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)VerticalAnchor.CODEC.fieldOf("anchor").forGetter(YConditionSource::anchor), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(YConditionSource::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(YConditionSource::addStoneDepth)).apply((Applicative)var0, YConditionSource::new)));

        YConditionSource(VerticalAnchor var0, int var1, boolean var2) {
            this.anchor = var0;
            this.surfaceDepthMultiplier = var1;
            this.addStoneDepth = var2;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            class YCondition
            extends LazyYCondition {
                final /* synthetic */ Context val$ruleContext;

                YCondition(Context context) {
                    this.val$ruleContext = context;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.blockY + (YConditionSource.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= YConditionSource.this.anchor.resolveY(this.context.context) + this.context.surfaceDepth * YConditionSource.this.surfaceDepthMultiplier;
                }
            }
            return new YCondition(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this, var0);
        }

        public VerticalAnchor anchor() {
            return this.anchor;
        }

        public int surfaceDepthMultiplier() {
            return this.surfaceDepthMultiplier;
        }

        public boolean addStoneDepth() {
            return this.addStoneDepth;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static final class WaterConditionSource
    extends Record
    implements ConditionSource {
        final int offset;
        final int surfaceDepthMultiplier;
        final boolean addStoneDepth;
        static final KeyDispatchDataCodec<WaterConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.fieldOf("offset").forGetter(WaterConditionSource::offset), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(WaterConditionSource::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(WaterConditionSource::addStoneDepth)).apply((Applicative)var0, WaterConditionSource::new)));

        WaterConditionSource(int var0, int var1, boolean var2) {
            this.offset = var0;
            this.surfaceDepthMultiplier = var1;
            this.addStoneDepth = var2;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            class WaterCondition
            extends LazyYCondition {
                final /* synthetic */ Context val$ruleContext;

                WaterCondition(Context context) {
                    this.val$ruleContext = context;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.waterHeight == Integer.MIN_VALUE || this.context.blockY + (WaterConditionSource.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= this.context.waterHeight + WaterConditionSource.this.offset + this.context.surfaceDepth * WaterConditionSource.this.surfaceDepthMultiplier;
                }
            }
            return new WaterCondition(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this, var0);
        }

        public int offset() {
            return this.offset;
        }

        public int surfaceDepthMultiplier() {
            return this.surfaceDepthMultiplier;
        }

        public boolean addStoneDepth() {
            return this.addStoneDepth;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static final class BiomeConditionSource
    implements ConditionSource {
        static final KeyDispatchDataCodec<BiomeConditionSource> CODEC = KeyDispatchDataCodec.of(ResourceKey.codec(Registries.BIOME).listOf().fieldOf("biome_is").xmap(SurfaceRules::isBiome, var0 -> var0.biomes));
        private final List<ResourceKey<Biome>> biomes;
        final Predicate<ResourceKey<Biome>> biomeNameTest;

        BiomeConditionSource(List<ResourceKey<Biome>> var0) {
            this.biomes = var0;
            this.biomeNameTest = Set.copyOf(var0)::contains;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            class BiomeCondition
            extends LazyYCondition {
                final /* synthetic */ Context val$ruleContext;

                BiomeCondition(Context context) {
                    this.val$ruleContext = context;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    return this.context.biome.get().is(BiomeConditionSource.this.biomeNameTest);
                }
            }
            return new BiomeCondition(var0);
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof BiomeConditionSource) {
                BiomeConditionSource var1 = (BiomeConditionSource)var0;
                return this.biomes.equals(var1.biomes);
            }
            return false;
        }

        public int hashCode() {
            return this.biomes.hashCode();
        }

        public String toString() {
            return "BiomeConditionSource[biomes=" + String.valueOf(this.biomes) + "]";
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static final class NoiseThresholdConditionSource
    extends Record
    implements ConditionSource {
        private final ResourceKey<NormalNoise.NoiseParameters> noise;
        final double minThreshold;
        final double maxThreshold;
        static final KeyDispatchDataCodec<NoiseThresholdConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceKey.codec(Registries.NOISE).fieldOf("noise").forGetter(NoiseThresholdConditionSource::noise), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(NoiseThresholdConditionSource::minThreshold), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(NoiseThresholdConditionSource::maxThreshold)).apply((Applicative)var0, NoiseThresholdConditionSource::new)));

        NoiseThresholdConditionSource(ResourceKey<NormalNoise.NoiseParameters> var0, double var1, double var3) {
            this.noise = var0;
            this.minThreshold = var1;
            this.maxThreshold = var3;
        }

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            NormalNoise var1 = var0.randomState.getOrCreateNoise(this.noise);
            class NoiseThresholdCondition
            extends LazyXZCondition {
                final /* synthetic */ Context val$ruleContext;
                final /* synthetic */ NormalNoise val$noise;

                NoiseThresholdCondition(Context context, NormalNoise normalNoise) {
                    this.val$ruleContext = context;
                    this.val$noise = normalNoise;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    double var0 = this.val$noise.getValue(this.context.blockX, 0.0, this.context.blockZ);
                    return var0 >= NoiseThresholdConditionSource.this.minThreshold && var0 <= NoiseThresholdConditionSource.this.maxThreshold;
                }
            }
            return new NoiseThresholdCondition(var0, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this, var0);
        }

        public ResourceKey<NormalNoise.NoiseParameters> noise() {
            return this.noise;
        }

        public double minThreshold() {
            return this.minThreshold;
        }

        public double maxThreshold() {
            return this.maxThreshold;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record VerticalGradientConditionSource(ResourceLocation randomName, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove) implements ConditionSource
    {
        static final KeyDispatchDataCodec<VerticalGradientConditionSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceLocation.CODEC.fieldOf("random_name").forGetter(VerticalGradientConditionSource::randomName), (App)VerticalAnchor.CODEC.fieldOf("true_at_and_below").forGetter(VerticalGradientConditionSource::trueAtAndBelow), (App)VerticalAnchor.CODEC.fieldOf("false_at_and_above").forGetter(VerticalGradientConditionSource::falseAtAndAbove)).apply((Applicative)var0, VerticalGradientConditionSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            int var1 = this.trueAtAndBelow().resolveY(var0.context);
            int var2 = this.falseAtAndAbove().resolveY(var0.context);
            PositionalRandomFactory var3 = var0.randomState.getOrCreateRandomFactory(this.randomName());
            class VerticalGradientCondition
            extends LazyYCondition {
                final /* synthetic */ Context val$ruleContext;
                final /* synthetic */ int val$trueAtAndBelow;
                final /* synthetic */ int val$falseAtAndAbove;
                final /* synthetic */ PositionalRandomFactory val$randomFactory;

                VerticalGradientCondition(VerticalGradientConditionSource var0, Context context, int n, int n2, PositionalRandomFactory positionalRandomFactory) {
                    this.val$ruleContext = context;
                    this.val$trueAtAndBelow = n;
                    this.val$falseAtAndAbove = n2;
                    this.val$randomFactory = positionalRandomFactory;
                    super(context);
                }

                @Override
                protected boolean compute() {
                    int var0 = this.context.blockY;
                    if (var0 <= this.val$trueAtAndBelow) {
                        return true;
                    }
                    if (var0 >= this.val$falseAtAndAbove) {
                        return false;
                    }
                    double var1 = Mth.map((double)var0, (double)this.val$trueAtAndBelow, (double)this.val$falseAtAndAbove, 1.0, 0.0);
                    RandomSource var3 = this.val$randomFactory.at(this.context.blockX, var0, this.context.blockZ);
                    return (double)var3.nextFloat() < var1;
                }
            }
            return new VerticalGradientCondition(this, var0, var1, var2, var3);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static enum Steep implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Steep> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            return var0.steep;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum Hole implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Hole> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            return var0.hole;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum AbovePreliminarySurface implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<AbovePreliminarySurface> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            return var0.abovePreliminarySurface;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    static enum Temperature implements ConditionSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Temperature> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends ConditionSource> codec() {
            return CODEC;
        }

        @Override
        public Condition apply(Context var0) {
            return var0.temperature;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    record TestRuleSource(ConditionSource ifTrue, RuleSource thenRun) implements RuleSource
    {
        static final KeyDispatchDataCodec<TestRuleSource> CODEC = KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ConditionSource.CODEC.fieldOf("if_true").forGetter(TestRuleSource::ifTrue), (App)RuleSource.CODEC.fieldOf("then_run").forGetter(TestRuleSource::thenRun)).apply((Applicative)var0, TestRuleSource::new)));

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context var0) {
            return new TestRule((Condition)this.ifTrue.apply(var0), (SurfaceRule)this.thenRun.apply(var0));
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    public static interface RuleSource
    extends Function<Context, SurfaceRule> {
        public static final Codec<RuleSource> CODEC = BuiltInRegistries.MATERIAL_RULE.byNameCodec().dispatch(var0 -> var0.codec().codec(), Function.identity());

        public static MapCodec<? extends RuleSource> bootstrap(Registry<MapCodec<? extends RuleSource>> var0) {
            SurfaceRules.register(var0, "bandlands", Bandlands.CODEC);
            SurfaceRules.register(var0, "block", BlockRuleSource.CODEC);
            SurfaceRules.register(var0, "sequence", SequenceRuleSource.CODEC);
            return SurfaceRules.register(var0, "condition", TestRuleSource.CODEC);
        }

        public KeyDispatchDataCodec<? extends RuleSource> codec();
    }

    record SequenceRuleSource(List<RuleSource> sequence) implements RuleSource
    {
        static final KeyDispatchDataCodec<SequenceRuleSource> CODEC = KeyDispatchDataCodec.of(RuleSource.CODEC.listOf().xmap(SequenceRuleSource::new, SequenceRuleSource::sequence).fieldOf("sequence"));

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context var0) {
            if (this.sequence.size() == 1) {
                return (SurfaceRule)this.sequence.get(0).apply(var0);
            }
            ImmutableList.Builder var1 = ImmutableList.builder();
            for (RuleSource var3 : this.sequence) {
                var1.add((Object)((SurfaceRule)var3.apply(var0)));
            }
            return new SequenceRule((List<SurfaceRule>)var1.build());
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record BlockRuleSource(BlockState resultState, StateRule rule) implements RuleSource
    {
        static final KeyDispatchDataCodec<BlockRuleSource> CODEC = KeyDispatchDataCodec.of(BlockState.CODEC.xmap(BlockRuleSource::new, BlockRuleSource::resultState).fieldOf("result_state"));

        BlockRuleSource(BlockState var0) {
            this(var0, new StateRule(var0));
        }

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context var0) {
            return this.rule;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static enum Bandlands implements RuleSource
    {
        INSTANCE;

        static final KeyDispatchDataCodec<Bandlands> CODEC;

        @Override
        public KeyDispatchDataCodec<? extends RuleSource> codec() {
            return CODEC;
        }

        @Override
        public SurfaceRule apply(Context var0) {
            return var0.system::getBand;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    record SequenceRule(List<SurfaceRule> rules) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState tryApply(int var0, int var1, int var2) {
            for (SurfaceRule var4 : this.rules) {
                BlockState var5 = var4.tryApply(var0, var1, var2);
                if (var5 == null) continue;
                return var5;
            }
            return null;
        }
    }

    record TestRule(Condition condition, SurfaceRule followup) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState tryApply(int var0, int var1, int var2) {
            if (!this.condition.test()) {
                return null;
            }
            return this.followup.tryApply(var0, var1, var2);
        }
    }

    record StateRule(BlockState state) implements SurfaceRule
    {
        @Override
        public BlockState tryApply(int var0, int var1, int var2) {
            return this.state;
        }
    }

    protected static interface SurfaceRule {
        @Nullable
        public BlockState tryApply(int var1, int var2, int var3);
    }

    record NotCondition(Condition target) implements Condition
    {
        @Override
        public boolean test() {
            return !this.target.test();
        }
    }

    static abstract class LazyYCondition
    extends LazyCondition {
        protected LazyYCondition(Context var0) {
            super(var0);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateY;
        }
    }

    static abstract class LazyXZCondition
    extends LazyCondition {
        protected LazyXZCondition(Context var0) {
            super(var0);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateXZ;
        }
    }

    static abstract class LazyCondition
    implements Condition {
        protected final Context context;
        private long lastUpdate;
        @Nullable
        Boolean result;

        protected LazyCondition(Context var0) {
            this.context = var0;
            this.lastUpdate = this.getContextLastUpdate() - 1L;
        }

        @Override
        public boolean test() {
            long var0 = this.getContextLastUpdate();
            if (var0 == this.lastUpdate) {
                if (this.result == null) {
                    throw new IllegalStateException("Update triggered but the result is null");
                }
                return this.result;
            }
            this.lastUpdate = var0;
            this.result = this.compute();
            return this.result;
        }

        protected abstract long getContextLastUpdate();

        protected abstract boolean compute();
    }

    static interface Condition {
        public boolean test();
    }

    protected static final class Context {
        private static final int HOW_FAR_BELOW_PRELIMINARY_SURFACE_LEVEL_TO_BUILD_SURFACE = 8;
        private static final int SURFACE_CELL_BITS = 4;
        private static final int SURFACE_CELL_SIZE = 16;
        private static final int SURFACE_CELL_MASK = 15;
        final SurfaceSystem system;
        final Condition temperature = new TemperatureHelperCondition(this);
        final Condition steep = new SteepMaterialCondition(this);
        final Condition hole = new HoleCondition(this);
        final Condition abovePreliminarySurface = new AbovePreliminarySurfaceCondition();
        final RandomState randomState;
        final ChunkAccess chunk;
        private final NoiseChunk noiseChunk;
        private final Function<BlockPos, Holder<Biome>> biomeGetter;
        final WorldGenerationContext context;
        private long lastPreliminarySurfaceCellOrigin = Long.MAX_VALUE;
        private final int[] preliminarySurfaceCache = new int[4];
        long lastUpdateXZ = -9223372036854775807L;
        int blockX;
        int blockZ;
        int surfaceDepth;
        private long lastSurfaceDepth2Update = this.lastUpdateXZ - 1L;
        private double surfaceSecondary;
        private long lastMinSurfaceLevelUpdate = this.lastUpdateXZ - 1L;
        private int minSurfaceLevel;
        long lastUpdateY = -9223372036854775807L;
        final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Supplier<Holder<Biome>> biome;
        int blockY;
        int waterHeight;
        int stoneDepthBelow;
        int stoneDepthAbove;

        protected Context(SurfaceSystem var0, RandomState var1, ChunkAccess var2, NoiseChunk var3, Function<BlockPos, Holder<Biome>> var4, Registry<Biome> var5, WorldGenerationContext var6) {
            this.system = var0;
            this.randomState = var1;
            this.chunk = var2;
            this.noiseChunk = var3;
            this.biomeGetter = var4;
            this.context = var6;
        }

        protected void updateXZ(int var0, int var1) {
            ++this.lastUpdateXZ;
            ++this.lastUpdateY;
            this.blockX = var0;
            this.blockZ = var1;
            this.surfaceDepth = this.system.getSurfaceDepth(var0, var1);
        }

        protected void updateY(int var0, int var1, int var2, int var3, int var4, int var5) {
            ++this.lastUpdateY;
            this.biome = Suppliers.memoize(() -> this.biomeGetter.apply(this.pos.set(var3, var4, var5)));
            this.blockY = var4;
            this.waterHeight = var2;
            this.stoneDepthBelow = var1;
            this.stoneDepthAbove = var0;
        }

        protected double getSurfaceSecondary() {
            if (this.lastSurfaceDepth2Update != this.lastUpdateXZ) {
                this.lastSurfaceDepth2Update = this.lastUpdateXZ;
                this.surfaceSecondary = this.system.getSurfaceSecondary(this.blockX, this.blockZ);
            }
            return this.surfaceSecondary;
        }

        public int getSeaLevel() {
            return this.system.getSeaLevel();
        }

        private static int blockCoordToSurfaceCell(int var0) {
            return var0 >> 4;
        }

        private static int surfaceCellToBlockCoord(int var0) {
            return var0 << 4;
        }

        protected int getMinSurfaceLevel() {
            if (this.lastMinSurfaceLevelUpdate != this.lastUpdateXZ) {
                int var1;
                this.lastMinSurfaceLevelUpdate = this.lastUpdateXZ;
                int var0 = Context.blockCoordToSurfaceCell(this.blockX);
                long var2 = ChunkPos.asLong(var0, var1 = Context.blockCoordToSurfaceCell(this.blockZ));
                if (this.lastPreliminarySurfaceCellOrigin != var2) {
                    this.lastPreliminarySurfaceCellOrigin = var2;
                    this.preliminarySurfaceCache[0] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(var0), Context.surfaceCellToBlockCoord(var1));
                    this.preliminarySurfaceCache[1] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(var0 + 1), Context.surfaceCellToBlockCoord(var1));
                    this.preliminarySurfaceCache[2] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(var0), Context.surfaceCellToBlockCoord(var1 + 1));
                    this.preliminarySurfaceCache[3] = this.noiseChunk.preliminarySurfaceLevel(Context.surfaceCellToBlockCoord(var0 + 1), Context.surfaceCellToBlockCoord(var1 + 1));
                }
                int var4 = Mth.floor(Mth.lerp2((float)(this.blockX & 0xF) / 16.0f, (float)(this.blockZ & 0xF) / 16.0f, this.preliminarySurfaceCache[0], this.preliminarySurfaceCache[1], this.preliminarySurfaceCache[2], this.preliminarySurfaceCache[3]));
                this.minSurfaceLevel = var4 + this.surfaceDepth - 8;
            }
            return this.minSurfaceLevel;
        }

        static class TemperatureHelperCondition
        extends LazyYCondition {
            TemperatureHelperCondition(Context var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                return this.context.biome.get().value().coldEnoughToSnow(this.context.pos.set(this.context.blockX, this.context.blockY, this.context.blockZ), this.context.getSeaLevel());
            }
        }

        static class SteepMaterialCondition
        extends LazyXZCondition {
            SteepMaterialCondition(Context var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                int var10;
                int var0 = this.context.blockX & 0xF;
                int var1 = this.context.blockZ & 0xF;
                int var2 = Math.max(var1 - 1, 0);
                int var3 = Math.min(var1 + 1, 15);
                ChunkAccess var4 = this.context.chunk;
                int var5 = var4.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var0, var2);
                int var6 = var4.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var0, var3);
                if (var6 >= var5 + 4) {
                    return true;
                }
                int var7 = Math.max(var0 - 1, 0);
                int var8 = Math.min(var0 + 1, 15);
                int var9 = var4.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var7, var1);
                return var9 >= (var10 = var4.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var8, var1)) + 4;
            }
        }

        static final class HoleCondition
        extends LazyXZCondition {
            HoleCondition(Context var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                return this.context.surfaceDepth <= 0;
            }
        }

        final class AbovePreliminarySurfaceCondition
        implements Condition {
            AbovePreliminarySurfaceCondition() {
            }

            @Override
            public boolean test() {
                return Context.this.blockY >= Context.this.getMinSurfaceLevel();
            }
        }
    }
}

