/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.function.LongFunction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class WorldgenRandom
extends LegacyRandomSource {
    private final RandomSource randomSource;
    private int count;

    public WorldgenRandom(RandomSource var0) {
        super(0L);
        this.randomSource = var0;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public RandomSource fork() {
        return this.randomSource.fork();
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return this.randomSource.forkPositional();
    }

    @Override
    public int next(int var0) {
        ++this.count;
        RandomSource randomSource = this.randomSource;
        if (randomSource instanceof LegacyRandomSource) {
            LegacyRandomSource var1 = (LegacyRandomSource)randomSource;
            return var1.next(var0);
        }
        return (int)(this.randomSource.nextLong() >>> 64 - var0);
    }

    @Override
    public synchronized void setSeed(long var0) {
        if (this.randomSource == null) {
            return;
        }
        this.randomSource.setSeed(var0);
    }

    public long setDecorationSeed(long var0, int var2, int var3) {
        this.setSeed(var0);
        long var4 = this.nextLong() | 1L;
        long var6 = this.nextLong() | 1L;
        long var8 = (long)var2 * var4 + (long)var3 * var6 ^ var0;
        this.setSeed(var8);
        return var8;
    }

    public void setFeatureSeed(long var0, int var2, int var3) {
        long var4 = var0 + (long)var2 + (long)(10000 * var3);
        this.setSeed(var4);
    }

    public void setLargeFeatureSeed(long var0, int var2, int var3) {
        this.setSeed(var0);
        long var4 = this.nextLong();
        long var6 = this.nextLong();
        long var8 = (long)var2 * var4 ^ (long)var3 * var6 ^ var0;
        this.setSeed(var8);
    }

    public void setLargeFeatureWithSalt(long var0, int var2, int var3, int var4) {
        long var5 = (long)var2 * 341873128712L + (long)var3 * 132897987541L + var0 + (long)var4;
        this.setSeed(var5);
    }

    public static RandomSource seedSlimeChunk(int var0, int var1, long var2, long var4) {
        return RandomSource.create(var2 + (long)(var0 * var0 * 4987142) + (long)(var0 * 5947611) + (long)(var1 * var1) * 4392871L + (long)(var1 * 389711) ^ var4);
    }

    public static enum Algorithm {
        LEGACY(LegacyRandomSource::new),
        XOROSHIRO(XoroshiroRandomSource::new);

        private final LongFunction<RandomSource> constructor;

        private Algorithm(LongFunction var2) {
            this.constructor = var2;
        }

        public RandomSource newInstance(long var0) {
            return this.constructor.apply(var0);
        }
    }
}

