/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class RandomizedIntStateProvider
extends BlockStateProvider {
    public static final MapCodec<RandomizedIntStateProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockStateProvider.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)Codec.STRING.fieldOf("property").forGetter(var0 -> var0.propertyName), (App)IntProvider.CODEC.fieldOf("values").forGetter(var0 -> var0.values)).apply((Applicative)var02, RandomizedIntStateProvider::new));
    private final BlockStateProvider source;
    private final String propertyName;
    @Nullable
    private IntegerProperty property;
    private final IntProvider values;

    public RandomizedIntStateProvider(BlockStateProvider var0, IntegerProperty var1, IntProvider var2) {
        this.source = var0;
        this.property = var1;
        this.propertyName = var1.getName();
        this.values = var2;
        List<Integer> var3 = var1.getPossibleValues();
        for (int var4 = var2.getMinValue(); var4 <= var2.getMaxValue(); ++var4) {
            if (var3.contains(var4)) continue;
            throw new IllegalArgumentException("Property value out of range: " + var1.getName() + ": " + var4);
        }
    }

    public RandomizedIntStateProvider(BlockStateProvider var0, String var1, IntProvider var2) {
        this.source = var0;
        this.propertyName = var1;
        this.values = var2;
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.RANDOMIZED_INT_STATE_PROVIDER;
    }

    @Override
    public BlockState getState(RandomSource var0, BlockPos var1) {
        BlockState var2 = this.source.getState(var0, var1);
        if (this.property == null || !var2.hasProperty(this.property)) {
            IntegerProperty var3 = RandomizedIntStateProvider.findProperty(var2, this.propertyName);
            if (var3 == null) {
                return var2;
            }
            this.property = var3;
        }
        return (BlockState)var2.setValue(this.property, this.values.sample(var0));
    }

    @Nullable
    private static IntegerProperty findProperty(BlockState var02, String var12) {
        Collection<Property<?>> var2 = var02.getProperties();
        Optional<IntegerProperty> var3 = var2.stream().filter(var1 -> var1.getName().equals(var12)).filter(var0 -> var0 instanceof IntegerProperty).map(var0 -> (IntegerProperty)var0).findAny();
        return var3.orElse(null);
    }
}

