/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RandomOffsetPlacement
extends PlacementModifier {
    public static final MapCodec<RandomOffsetPlacement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)IntProvider.codec(-16, 16).fieldOf("xz_spread").forGetter(var0 -> var0.xzSpread), (App)IntProvider.codec(-16, 16).fieldOf("y_spread").forGetter(var0 -> var0.ySpread)).apply((Applicative)var02, RandomOffsetPlacement::new));
    private final IntProvider xzSpread;
    private final IntProvider ySpread;

    public static RandomOffsetPlacement of(IntProvider var0, IntProvider var1) {
        return new RandomOffsetPlacement(var0, var1);
    }

    public static RandomOffsetPlacement vertical(IntProvider var0) {
        return new RandomOffsetPlacement(ConstantInt.of(0), var0);
    }

    public static RandomOffsetPlacement horizontal(IntProvider var0) {
        return new RandomOffsetPlacement(var0, ConstantInt.of(0));
    }

    private RandomOffsetPlacement(IntProvider var0, IntProvider var1) {
        this.xzSpread = var0;
        this.ySpread = var1;
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext var0, RandomSource var1, BlockPos var2) {
        int var3 = var2.getX() + this.xzSpread.sample(var1);
        int var4 = var2.getY() + this.ySpread.sample(var1);
        int var5 = var2.getZ() + this.xzSpread.sample(var1);
        return Stream.of(new BlockPos(var3, var4, var5));
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.RANDOM_OFFSET;
    }
}

