/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class StructurePiecesBuilder
implements StructurePieceAccessor {
    private final List<StructurePiece> pieces = Lists.newArrayList();

    @Override
    public void addPiece(StructurePiece var0) {
        this.pieces.add(var0);
    }

    @Override
    @Nullable
    public StructurePiece findCollisionPiece(BoundingBox var0) {
        return StructurePiece.findCollisionPiece(this.pieces, var0);
    }

    @Deprecated
    public void offsetPiecesVertically(int var0) {
        for (StructurePiece var2 : this.pieces) {
            var2.move(0, var0, 0);
        }
    }

    @Deprecated
    public int moveBelowSeaLevel(int var0, int var1, RandomSource var2, int var3) {
        int var4 = var0 - var3;
        BoundingBox var5 = this.getBoundingBox();
        int var6 = var5.getYSpan() + var1 + 1;
        if (var6 < var4) {
            var6 += var2.nextInt(var4 - var6);
        }
        int var7 = var6 - var5.maxY();
        this.offsetPiecesVertically(var7);
        return var7;
    }

    public void moveInsideHeights(RandomSource var0, int var1, int var2) {
        BoundingBox var3 = this.getBoundingBox();
        int var4 = var2 - var1 + 1 - var3.getYSpan();
        int var5 = var4 > 1 ? var1 + var0.nextInt(var4) : var1;
        int var6 = var5 - var3.minY();
        this.offsetPiecesVertically(var6);
    }

    public PiecesContainer build() {
        return new PiecesContainer(this.pieces);
    }

    public void clear() {
        this.pieces.clear();
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return StructurePiece.createBoundingBox(this.pieces.stream());
    }
}

