/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class RandomSpreadStructurePlacement
extends StructurePlacement {
    public static final MapCodec<RandomSpreadStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(var0 -> RandomSpreadStructurePlacement.placementCodec(var0).and(var0.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType))).apply((Applicative)var0, RandomSpreadStructurePlacement::new)).validate(RandomSpreadStructurePlacement::validate);
    private final int spacing;
    private final int separation;
    private final RandomSpreadType spreadType;

    private static DataResult<RandomSpreadStructurePlacement> validate(RandomSpreadStructurePlacement var0) {
        if (var0.spacing <= var0.separation) {
            return DataResult.error(() -> "Spacing has to be larger than separation");
        }
        return DataResult.success((Object)var0);
    }

    public RandomSpreadStructurePlacement(Vec3i var0, StructurePlacement.FrequencyReductionMethod var1, float var2, int var3, Optional<StructurePlacement.ExclusionZone> var4, int var5, int var6, RandomSpreadType var7) {
        super(var0, var1, var2, var3, var4);
        this.spacing = var5;
        this.separation = var6;
        this.spreadType = var7;
    }

    public RandomSpreadStructurePlacement(int var0, int var1, RandomSpreadType var2, int var3) {
        this(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, var3, Optional.empty(), var0, var1, var2);
    }

    public int spacing() {
        return this.spacing;
    }

    public int separation() {
        return this.separation;
    }

    public RandomSpreadType spreadType() {
        return this.spreadType;
    }

    public ChunkPos getPotentialStructureChunk(long var0, int var2, int var3) {
        int var4 = Math.floorDiv(var2, this.spacing);
        int var5 = Math.floorDiv(var3, this.spacing);
        WorldgenRandom var6 = new WorldgenRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureWithSalt(var0, var4, var5, this.salt());
        int var7 = this.spacing - this.separation;
        int var8 = this.spreadType.evaluate(var6, var7);
        int var9 = this.spreadType.evaluate(var6, var7);
        return new ChunkPos(var4 * this.spacing + var8, var5 * this.spacing + var9);
    }

    @Override
    protected boolean isPlacementChunk(ChunkGeneratorStructureState var0, int var1, int var2) {
        ChunkPos var3 = this.getPotentialStructureChunk(var0.getLevelSeed(), var1, var2);
        return var3.x == var1 && var3.z == var2;
    }

    @Override
    public StructurePlacementType<?> type() {
        return StructurePlacementType.RANDOM_SPREAD;
    }
}

