/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.entity.EntityType;

public class MineshaftPieces {
    private static final int DEFAULT_SHAFT_WIDTH = 3;
    private static final int DEFAULT_SHAFT_HEIGHT = 3;
    private static final int DEFAULT_SHAFT_LENGTH = 5;
    private static final int MAX_PILLAR_HEIGHT = 20;
    private static final int MAX_CHAIN_HEIGHT = 50;
    private static final int MAX_DEPTH = 8;
    public static final int MAGIC_START_Y = 50;

    private static MineShaftPiece createRandomShaftPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, @Nullable Direction enumdirection, int l, MineshaftStructure.Type mineshaftstructure_a) {
        int i1 = randomsource.nextInt(100);
        if (i1 >= 80) {
            BoundingBox structureboundingbox = MineShaftCrossing.findCrossing(structurepieceaccessor, randomsource, i, j, k, enumdirection);
            if (structureboundingbox != null) {
                return new MineShaftCrossing(l, structureboundingbox, enumdirection, mineshaftstructure_a);
            }
        } else if (i1 >= 70) {
            BoundingBox structureboundingbox1 = MineShaftStairs.findStairs(structurepieceaccessor, randomsource, i, j, k, enumdirection);
            if (structureboundingbox1 != null) {
                return new MineShaftStairs(l, structureboundingbox1, enumdirection, mineshaftstructure_a);
            }
        } else {
            BoundingBox structureboundingbox2 = MineShaftCorridor.findCorridorSize(structurepieceaccessor, randomsource, i, j, k, enumdirection);
            if (structureboundingbox2 != null) {
                return new MineShaftCorridor(l, randomsource, structureboundingbox2, enumdirection, mineshaftstructure_a);
            }
        }
        return null;
    }

    static MineShaftPiece generateAndAddPiece(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
        if (l > 8) {
            return null;
        }
        if (Math.abs(i - structurepiece.getBoundingBox().minX()) <= 80 && Math.abs(k - structurepiece.getBoundingBox().minZ()) <= 80) {
            MineshaftStructure.Type mineshaftstructure_a = ((MineShaftPiece)structurepiece).type;
            MineShaftPiece mineshaftpieces_c = MineshaftPieces.createRandomShaftPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l + 1, mineshaftstructure_a);
            if (mineshaftpieces_c != null) {
                structurepieceaccessor.addPiece(mineshaftpieces_c);
                mineshaftpieces_c.addChildren(structurepiece, structurepieceaccessor, randomsource);
            }
            return mineshaftpieces_c;
        }
        return null;
    }

    public static class MineShaftCrossing
    extends MineShaftPiece {
        private final Direction direction;
        private final boolean isTwoFloored;

        public MineShaftCrossing(CompoundTag nbttagcompound) {
            super(StructurePieceType.MINE_SHAFT_CROSSING, nbttagcompound);
            this.isTwoFloored = nbttagcompound.getBooleanOr("tf", false);
            this.direction = nbttagcompound.read("D", Direction.LEGACY_ID_CODEC_2D).orElse(Direction.SOUTH);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("tf", this.isTwoFloored);
            nbttagcompound.store("D", Direction.LEGACY_ID_CODEC_2D, this.direction);
        }

        public MineShaftCrossing(int i, BoundingBox structureboundingbox, @Nullable Direction enumdirection, MineshaftStructure.Type mineshaftstructure_a) {
            super(StructurePieceType.MINE_SHAFT_CROSSING, i, mineshaftstructure_a, structureboundingbox);
            this.direction = enumdirection;
            this.isTwoFloored = structureboundingbox.getYSpan() > 3;
        }

        @Nullable
        public static BoundingBox findCrossing(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection) {
            int l = randomsource.nextInt(4) == 0 ? 6 : 2;
            BoundingBox structureboundingbox = switch (enumdirection) {
                default -> new BoundingBox(-1, 0, -4, 3, l, 0);
                case Direction.SOUTH -> new BoundingBox(-1, 0, 0, 3, l, 4);
                case Direction.WEST -> new BoundingBox(-4, 0, -1, 0, l, 3);
                case Direction.EAST -> new BoundingBox(0, 0, -1, 4, l, 3);
            };
            structureboundingbox.move(i, j, k);
            return structurepieceaccessor.findCollisionPiece(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i = this.getGenDepth();
            switch (this.direction) {
                default: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, Direction.EAST, i);
                }
            }
            if (this.isTwoFloored) {
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() - 1, Direction.NORTH, i);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, Direction.WEST, i);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, Direction.EAST, i);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                }
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                BlockState iblockdata = this.type.getPlanksState();
                if (this.isTwoFloored) {
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.maxY() - 2, this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.maxY() - 2, this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3, this.boundingBox.minZ() + 1, this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                } else {
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                }
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                int i = this.boundingBox.minY() - 1;
                for (int j = this.boundingBox.minX(); j <= this.boundingBox.maxX(); ++j) {
                    for (int k = this.boundingBox.minZ(); k <= this.boundingBox.maxZ(); ++k) {
                        this.setPlanksBlock(generatoraccessseed, structureboundingbox, iblockdata, j, i, k);
                    }
                }
            }
        }

        private void placeSupportPillar(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l) {
            if (!this.getBlock(generatoraccessseed, i, l + 1, k, structureboundingbox).isAir()) {
                this.generateBox(generatoraccessseed, structureboundingbox, i, j, k, i, l, k, this.type.getPlanksState(), CAVE_AIR, false);
            }
        }
    }

    public static class MineShaftStairs
    extends MineShaftPiece {
        public MineShaftStairs(int i, BoundingBox structureboundingbox, Direction enumdirection, MineshaftStructure.Type mineshaftstructure_a) {
            super(StructurePieceType.MINE_SHAFT_STAIRS, i, mineshaftstructure_a, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public MineShaftStairs(CompoundTag nbttagcompound) {
            super(StructurePieceType.MINE_SHAFT_STAIRS, nbttagcompound);
        }

        @Nullable
        public static BoundingBox findStairs(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection) {
            BoundingBox structureboundingbox = switch (enumdirection) {
                default -> new BoundingBox(0, -5, -8, 2, 2, 0);
                case Direction.SOUTH -> new BoundingBox(0, -5, 0, 2, 2, 8);
                case Direction.WEST -> new BoundingBox(-8, -5, 0, 0, 2, 2);
                case Direction.EAST -> new BoundingBox(0, -5, 0, 8, 2, 2);
            };
            structureboundingbox.move(i, j, k);
            return structurepieceaccessor.findCollisionPiece(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i = this.getGenDepth();
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    default: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ(), Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), Direction.EAST, i);
                    }
                }
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 2, 7, 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 7, 2, 2, 8, CAVE_AIR, CAVE_AIR, false);
                for (int i = 0; i < 5; ++i) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, CAVE_AIR, CAVE_AIR, false);
                }
            }
        }
    }

    public static class MineShaftCorridor
    extends MineShaftPiece {
        private final boolean hasRails;
        private final boolean spiderCorridor;
        private boolean hasPlacedSpider;
        private final int numSections;

        public MineShaftCorridor(CompoundTag nbttagcompound) {
            super(StructurePieceType.MINE_SHAFT_CORRIDOR, nbttagcompound);
            this.hasRails = nbttagcompound.getBooleanOr("hr", false);
            this.spiderCorridor = nbttagcompound.getBooleanOr("sc", false);
            this.hasPlacedSpider = nbttagcompound.getBooleanOr("hps", false);
            this.numSections = nbttagcompound.getIntOr("Num", 0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("hr", this.hasRails);
            nbttagcompound.putBoolean("sc", this.spiderCorridor);
            nbttagcompound.putBoolean("hps", this.hasPlacedSpider);
            nbttagcompound.putInt("Num", this.numSections);
        }

        public MineShaftCorridor(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection, MineshaftStructure.Type mineshaftstructure_a) {
            super(StructurePieceType.MINE_SHAFT_CORRIDOR, i, mineshaftstructure_a, structureboundingbox);
            this.setOrientation(enumdirection);
            this.hasRails = randomsource.nextInt(3) == 0;
            this.spiderCorridor = !this.hasRails && randomsource.nextInt(23) == 0;
            this.numSections = this.getOrientation().getAxis() == Direction.Axis.Z ? structureboundingbox.getZSpan() / 5 : structureboundingbox.getXSpan() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static BoundingBox findCorridorSize(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection) {
            int l = randomsource.nextInt(3) + 2;
            while (l > 0) {
                int i1 = l * 5;
                BoundingBox structureboundingbox = switch (enumdirection) {
                    default -> new BoundingBox(0, 0, -(i1 - 1), 2, 2, 0);
                    case Direction.SOUTH -> new BoundingBox(0, 0, 0, 2, 2, i1 - 1);
                    case Direction.WEST -> new BoundingBox(-(i1 - 1), 0, 0, 0, 2, 2);
                    case Direction.EAST -> new BoundingBox(0, 0, 0, i1 - 1, 2, 2);
                };
                structureboundingbox.move(i, j, k);
                if (structurepieceaccessor.findCollisionPiece(structureboundingbox) == null) {
                    return structureboundingbox;
                }
                --l;
            }
            return null;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            block24: {
                int i = this.getGenDepth();
                int j = randomsource.nextInt(4);
                Direction enumdirection = this.getOrientation();
                if (enumdirection != null) {
                    switch (enumdirection) {
                        default: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, enumdirection, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, enumdirection, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() - 3, Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), enumdirection, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), enumdirection, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumdirection != Direction.NORTH && enumdirection != Direction.SOUTH) {
                    int k = this.boundingBox.minX() + 3;
                    while (k + 3 <= this.boundingBox.maxX()) {
                        int l = randomsource.nextInt(5);
                        if (l == 0) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, k, this.boundingBox.minY(), this.boundingBox.minZ() - 1, Direction.NORTH, i + 1);
                        } else if (l == 1) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, k, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, Direction.SOUTH, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int i1 = this.boundingBox.minZ() + 3;
                    while (i1 + 3 <= this.boundingBox.maxZ()) {
                        int j1 = randomsource.nextInt(5);
                        if (j1 == 0) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), i1, Direction.WEST, i + 1);
                        } else if (j1 == 1) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), i1, Direction.EAST, i + 1);
                        }
                        i1 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean createChest(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, int i, int j, int k, ResourceKey<LootTable> resourcekey) {
            BlockPos.MutableBlockPos blockposition = this.getWorldPos(i, j, k);
            if (structureboundingbox.isInside(blockposition) && generatoraccessseed.getBlockState(blockposition).isAir() && !generatoraccessseed.getBlockState(((BlockPos)blockposition).below()).isAir()) {
                BlockState iblockdata = (BlockState)Blocks.RAIL.defaultBlockState().setValue(RailBlock.SHAPE, randomsource.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST);
                this.placeBlock(generatoraccessseed, iblockdata, i, j, k, structureboundingbox);
                MinecartChest entityminecartchest = net.minecraft.world.entity.EntityType.CHEST_MINECART.create(generatoraccessseed.getLevel(), EntitySpawnReason.CHUNK_GENERATION);
                if (entityminecartchest != null) {
                    entityminecartchest.setInitialPos((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5);
                    entityminecartchest.setLootTable(resourcekey, randomsource.nextLong());
                    generatoraccessseed.addFreshEntity(entityminecartchest);
                }
                return true;
            }
            return false;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                boolean i = false;
                int j = 2;
                boolean k = false;
                int l = 2;
                int i1 = this.numSections * 5 - 1;
                BlockState iblockdata = this.type.getPlanksState();
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 2, 1, i1, CAVE_AIR, CAVE_AIR, false);
                this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.8f, 0, 2, 0, 2, 2, i1, CAVE_AIR, CAVE_AIR, false, false);
                if (this.spiderCorridor) {
                    this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.COBWEB.defaultBlockState(), CAVE_AIR, false, true);
                }
                for (int j1 = 0; j1 < this.numSections; ++j1) {
                    int k1 = 2 + j1 * 5;
                    this.placeSupport(generatoraccessseed, structureboundingbox, 0, 0, k1, 2, 2, randomsource);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 0, 2, k1 - 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 2, 2, k1 - 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 0, 2, k1 + 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 2, 2, k1 + 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 0, 2, k1 - 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 2, 2, k1 - 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 0, 2, k1 + 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 2, 2, k1 + 2);
                    if (randomsource.nextInt(100) == 0) {
                        this.createChest(generatoraccessseed, structureboundingbox, randomsource, 2, 0, k1 - 1, BuiltInLootTables.ABANDONED_MINESHAFT);
                    }
                    if (randomsource.nextInt(100) == 0) {
                        this.createChest(generatoraccessseed, structureboundingbox, randomsource, 0, 0, k1 + 1, BuiltInLootTables.ABANDONED_MINESHAFT);
                    }
                    if (!this.spiderCorridor || this.hasPlacedSpider) continue;
                    boolean l1 = true;
                    int i2 = k1 - 1 + randomsource.nextInt(3);
                    BlockPos.MutableBlockPos blockposition1 = this.getWorldPos(1, 0, i2);
                    if (!structureboundingbox.isInside(blockposition1) || !this.isInterior(generatoraccessseed, 1, 0, i2, structureboundingbox)) continue;
                    this.hasPlacedSpider = true;
                    this.placeCraftSpawner(generatoraccessseed, blockposition1, EntityType.CAVE_SPIDER, 2);
                }
                for (int j2 = 0; j2 <= 2; ++j2) {
                    for (int k2 = 0; k2 <= i1; ++k2) {
                        this.setPlanksBlock(generatoraccessseed, structureboundingbox, iblockdata, j2, -1, k2);
                    }
                }
                int l2 = 2;
                this.placeDoubleLowerOrUpperSupport(generatoraccessseed, structureboundingbox, 0, -1, 2);
                if (this.numSections > 1) {
                    int i3 = i1 - 2;
                    this.placeDoubleLowerOrUpperSupport(generatoraccessseed, structureboundingbox, 0, -1, i3);
                }
                if (this.hasRails) {
                    BlockState iblockdata1 = (BlockState)Blocks.RAIL.defaultBlockState().setValue(RailBlock.SHAPE, RailShape.NORTH_SOUTH);
                    for (int j3 = 0; j3 <= i1; ++j3) {
                        BlockState iblockdata2 = this.getBlock(generatoraccessseed, 1, -1, j3, structureboundingbox);
                        if (iblockdata2.isAir() || !iblockdata2.isSolidRender()) continue;
                        float f = this.isInterior(generatoraccessseed, 1, 0, j3, structureboundingbox) ? 0.7f : 0.9f;
                        this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, f, 1, 0, j3, iblockdata1);
                    }
                }
            }
        }

        private void placeDoubleLowerOrUpperSupport(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k) {
            BlockState iblockdata = this.type.getWoodState();
            BlockState iblockdata1 = this.type.getPlanksState();
            if (this.getBlock(generatoraccessseed, i, j, k, structureboundingbox).is(iblockdata1.getBlock())) {
                this.fillPillarDownOrChainUp(generatoraccessseed, iblockdata, i, j, k, structureboundingbox);
            }
            if (this.getBlock(generatoraccessseed, i + 2, j, k, structureboundingbox).is(iblockdata1.getBlock())) {
                this.fillPillarDownOrChainUp(generatoraccessseed, iblockdata, i + 2, j, k, structureboundingbox);
            }
        }

        @Override
        protected void fillColumnDown(WorldGenLevel generatoraccessseed, BlockState iblockdata, int i, int j, int k, BoundingBox structureboundingbox) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = this.getWorldPos(i, j, k);
            if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
                int l = blockposition_mutableblockposition.getY();
                while (this.isReplaceableByStructures(generatoraccessseed.getBlockState(blockposition_mutableblockposition)) && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinY() + 1) {
                    blockposition_mutableblockposition.move(Direction.DOWN);
                }
                if (this.canPlaceColumnOnTopOf(generatoraccessseed, blockposition_mutableblockposition, generatoraccessseed.getBlockState(blockposition_mutableblockposition))) {
                    while (blockposition_mutableblockposition.getY() < l) {
                        blockposition_mutableblockposition.move(Direction.UP);
                        generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
                    }
                }
            }
        }

        protected void fillPillarDownOrChainUp(WorldGenLevel generatoraccessseed, BlockState iblockdata, int i, int j, int k, BoundingBox structureboundingbox) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = this.getWorldPos(i, j, k);
            if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
                int l = blockposition_mutableblockposition.getY();
                int i1 = 1;
                boolean flag = true;
                boolean flag1 = true;
                while (flag || flag1) {
                    if (flag) {
                        boolean flag2;
                        blockposition_mutableblockposition.setY(l - i1);
                        BlockState iblockdata1 = generatoraccessseed.getBlockState(blockposition_mutableblockposition);
                        boolean bl = flag2 = this.isReplaceableByStructures(iblockdata1) && !iblockdata1.is(Blocks.LAVA);
                        if (!flag2 && this.canPlaceColumnOnTopOf(generatoraccessseed, blockposition_mutableblockposition, iblockdata1)) {
                            MineShaftCorridor.fillColumnBetween(generatoraccessseed, iblockdata, blockposition_mutableblockposition, l - i1 + 1, l);
                            return;
                        }
                        boolean bl2 = flag = i1 <= 20 && flag2 && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinY() + 1;
                    }
                    if (flag1) {
                        blockposition_mutableblockposition.setY(l + i1);
                        BlockState iblockdata2 = generatoraccessseed.getBlockState(blockposition_mutableblockposition);
                        boolean flag3 = this.isReplaceableByStructures(iblockdata2);
                        if (!flag3 && this.canHangChainBelow(generatoraccessseed, blockposition_mutableblockposition, iblockdata2)) {
                            generatoraccessseed.setBlock(blockposition_mutableblockposition.setY(l + 1), this.type.getFenceState(), 2);
                            MineShaftCorridor.fillColumnBetween(generatoraccessseed, Blocks.IRON_CHAIN.defaultBlockState(), blockposition_mutableblockposition, l + 2, l + i1);
                            return;
                        }
                        flag1 = i1 <= 50 && flag3 && blockposition_mutableblockposition.getY() < generatoraccessseed.getMaxY();
                    }
                    ++i1;
                }
            }
        }

        private static void fillColumnBetween(WorldGenLevel generatoraccessseed, BlockState iblockdata, BlockPos.MutableBlockPos blockposition_mutableblockposition, int i, int j) {
            for (int k = i; k < j; ++k) {
                generatoraccessseed.setBlock(blockposition_mutableblockposition.setY(k), iblockdata, 2);
            }
        }

        private boolean canPlaceColumnOnTopOf(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
            return iblockdata.isFaceSturdy(iworldreader, blockposition, Direction.UP);
        }

        private boolean canHangChainBelow(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
            return Block.canSupportCenter(iworldreader, blockposition, Direction.DOWN) && !(iblockdata.getBlock() instanceof FallingBlock);
        }

        private void placeSupport(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l, int i1, RandomSource randomsource) {
            if (this.isSupportingBox(generatoraccessseed, structureboundingbox, i, i1, l, k)) {
                BlockState iblockdata = this.type.getPlanksState();
                BlockState iblockdata1 = this.type.getFenceState();
                this.generateBox(generatoraccessseed, structureboundingbox, i, j, k, i, l - 1, k, (BlockState)iblockdata1.setValue(FenceBlock.WEST, true), CAVE_AIR, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i1, j, k, i1, l - 1, k, (BlockState)iblockdata1.setValue(FenceBlock.EAST, true), CAVE_AIR, false);
                if (randomsource.nextInt(4) == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, i, l, k, i, l, k, iblockdata, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, i1, l, k, i1, l, k, iblockdata, CAVE_AIR, false);
                } else {
                    this.generateBox(generatoraccessseed, structureboundingbox, i, l, k, i1, l, k, iblockdata, CAVE_AIR, false);
                    this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.05f, i + 1, l, k - 1, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH));
                    this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.05f, i + 1, l, k + 1, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.NORTH));
                }
            }
        }

        private void maybePlaceCobWeb(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, RandomSource randomsource, float f, int i, int j, int k) {
            if (this.isInterior(generatoraccessseed, i, j, k, structureboundingbox) && randomsource.nextFloat() < f && this.hasSturdyNeighbours(generatoraccessseed, structureboundingbox, i, j, k, 2)) {
                this.placeBlock(generatoraccessseed, Blocks.COBWEB.defaultBlockState(), i, j, k, structureboundingbox);
            }
        }

        private boolean hasSturdyNeighbours(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, int i, int j, int k, int l) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = this.getWorldPos(i, j, k);
            int i1 = 0;
            for (Direction enumdirection : Direction.values()) {
                blockposition_mutableblockposition.move(enumdirection);
                if (structureboundingbox.isInside(blockposition_mutableblockposition) && generatoraccessseed.getBlockState(blockposition_mutableblockposition).isFaceSturdy(generatoraccessseed, blockposition_mutableblockposition, enumdirection.getOpposite()) && ++i1 >= l) {
                    return true;
                }
                blockposition_mutableblockposition.move(enumdirection.getOpposite());
            }
            return false;
        }
    }

    private static abstract class MineShaftPiece
    extends StructurePiece {
        protected MineshaftStructure.Type type;

        public MineShaftPiece(StructurePieceType worldgenfeaturestructurepiecetype, int i, MineshaftStructure.Type mineshaftstructure_a, BoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i, structureboundingbox);
            this.type = mineshaftstructure_a;
        }

        public MineShaftPiece(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.type = MineshaftStructure.Type.byId(nbttagcompound.getIntOr("MST", 0));
        }

        @Override
        protected boolean canBeReplaced(LevelReader iworldreader, int i, int j, int k, BoundingBox structureboundingbox) {
            BlockState iblockdata = this.getBlock(iworldreader, i, j, k, structureboundingbox);
            return !iblockdata.is(this.type.getPlanksState().getBlock()) && !iblockdata.is(this.type.getWoodState().getBlock()) && !iblockdata.is(this.type.getFenceState().getBlock()) && !iblockdata.is(Blocks.IRON_CHAIN);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            nbttagcompound.putInt("MST", this.type.ordinal());
        }

        protected boolean isSupportingBox(BlockGetter iblockaccess, BoundingBox structureboundingbox, int i, int j, int k, int l) {
            for (int i1 = i; i1 <= j; ++i1) {
                if (!this.getBlock(iblockaccess, i1, k + 1, l, structureboundingbox).isAir()) continue;
                return false;
            }
            return true;
        }

        protected boolean isInInvalidLocation(LevelAccessor generatoraccess, BoundingBox structureboundingbox) {
            int j1;
            int i1;
            int i = Math.max(this.boundingBox.minX() - 1, structureboundingbox.minX());
            int j = Math.max(this.boundingBox.minY() - 1, structureboundingbox.minY());
            int k = Math.max(this.boundingBox.minZ() - 1, structureboundingbox.minZ());
            int l = Math.min(this.boundingBox.maxX() + 1, structureboundingbox.maxX());
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos((i + l) / 2, (j + (i1 = Math.min(this.boundingBox.maxY() + 1, structureboundingbox.maxY()))) / 2, (k + (j1 = Math.min(this.boundingBox.maxZ() + 1, structureboundingbox.maxZ()))) / 2);
            if (generatoraccess.getBiome(blockposition_mutableblockposition).is(BiomeTags.MINESHAFT_BLOCKING)) {
                return true;
            }
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = k; l1 <= j1; ++l1) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, j, l1)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, i1, l1)).liquid()) continue;
                    return true;
                }
            }
            for (int i2 = i; i2 <= l; ++i2) {
                for (int j2 = j; j2 <= i1; ++j2) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(i2, j2, k)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(i2, j2, j1)).liquid()) continue;
                    return true;
                }
            }
            for (int k2 = k; k2 <= j1; ++k2) {
                for (int l2 = j; l2 <= i1; ++l2) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(i, l2, k2)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(l, l2, k2)).liquid()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void setPlanksBlock(WorldGenLevel generatoraccessseed, BoundingBox structureboundingbox, BlockState iblockdata, int i, int j, int k) {
            BlockPos.MutableBlockPos blockposition;
            BlockState iblockdata1;
            if (this.isInterior(generatoraccessseed, i, j, k, structureboundingbox) && !(iblockdata1 = generatoraccessseed.getBlockState(blockposition = this.getWorldPos(i, j, k))).isFaceSturdy(generatoraccessseed, blockposition, Direction.UP)) {
                generatoraccessseed.setBlock(blockposition, iblockdata, 2);
            }
        }
    }

    public static class MineShaftRoom
    extends MineShaftPiece {
        private final List<BoundingBox> childEntranceBoxes = Lists.newLinkedList();

        public MineShaftRoom(int i, RandomSource randomsource, int j, int k, MineshaftStructure.Type mineshaftstructure_a) {
            super(StructurePieceType.MINE_SHAFT_ROOM, i, mineshaftstructure_a, new BoundingBox(j, 50, k, j + 7 + randomsource.nextInt(6), 54 + randomsource.nextInt(6), k + 7 + randomsource.nextInt(6)));
            this.type = mineshaftstructure_a;
        }

        public MineShaftRoom(CompoundTag nbttagcompound) {
            super(StructurePieceType.MINE_SHAFT_ROOM, nbttagcompound);
            this.childEntranceBoxes.addAll(nbttagcompound.read("Entrances", BoundingBox.CODEC.listOf()).orElse(List.of()));
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int k;
            int i = this.getGenDepth();
            int j = this.boundingBox.getYSpan() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.boundingBox.getXSpan() && (k += randomsource.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k += 4) {
                MineShaftPiece mineshaftpieces_c = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + k, this.boundingBox.minY() + randomsource.nextInt(j) + 1, this.boundingBox.minZ() - 1, Direction.NORTH, i);
                if (mineshaftpieces_c == null) continue;
                BoundingBox structureboundingbox = mineshaftpieces_c.getBoundingBox();
                this.childEntranceBoxes.add(new BoundingBox(structureboundingbox.minX(), structureboundingbox.minY(), this.boundingBox.minZ(), structureboundingbox.maxX(), structureboundingbox.maxY(), this.boundingBox.minZ() + 1));
            }
            for (k = 0; k < this.boundingBox.getXSpan() && (k += randomsource.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k += 4) {
                MineShaftPiece mineshaftpieces_c1 = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + k, this.boundingBox.minY() + randomsource.nextInt(j) + 1, this.boundingBox.maxZ() + 1, Direction.SOUTH, i);
                if (mineshaftpieces_c1 == null) continue;
                BoundingBox structureboundingbox1 = mineshaftpieces_c1.getBoundingBox();
                this.childEntranceBoxes.add(new BoundingBox(structureboundingbox1.minX(), structureboundingbox1.minY(), this.boundingBox.maxZ() - 1, structureboundingbox1.maxX(), structureboundingbox1.maxY(), this.boundingBox.maxZ()));
            }
            for (k = 0; k < this.boundingBox.getZSpan() && (k += randomsource.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k += 4) {
                MineShaftPiece mineshaftpieces_c2 = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + randomsource.nextInt(j) + 1, this.boundingBox.minZ() + k, Direction.WEST, i);
                if (mineshaftpieces_c2 == null) continue;
                BoundingBox structureboundingbox2 = mineshaftpieces_c2.getBoundingBox();
                this.childEntranceBoxes.add(new BoundingBox(this.boundingBox.minX(), structureboundingbox2.minY(), structureboundingbox2.minZ(), this.boundingBox.minX() + 1, structureboundingbox2.maxY(), structureboundingbox2.maxZ()));
            }
            for (k = 0; k < this.boundingBox.getZSpan() && (k += randomsource.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k += 4) {
                MineShaftPiece structurepiece1 = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + randomsource.nextInt(j) + 1, this.boundingBox.minZ() + k, Direction.EAST, i);
                if (structurepiece1 == null) continue;
                BoundingBox structureboundingbox3 = structurepiece1.getBoundingBox();
                this.childEntranceBoxes.add(new BoundingBox(this.boundingBox.maxX() - 1, structureboundingbox3.minY(), structureboundingbox3.minZ(), this.boundingBox.maxX(), structureboundingbox3.maxY(), structureboundingbox3.maxZ()));
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY() + 1, this.boundingBox.minZ(), this.boundingBox.maxX(), Math.min(this.boundingBox.minY() + 3, this.boundingBox.maxY()), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                for (BoundingBox structureboundingbox1 : this.childEntranceBoxes) {
                    this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.maxY() - 2, structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), CAVE_AIR, CAVE_AIR, false);
                }
                this.generateUpperHalfSphere(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY() + 4, this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, false);
            }
        }

        @Override
        public void move(int i, int j, int k) {
            super.move(i, j, k);
            for (BoundingBox structureboundingbox : this.childEntranceBoxes) {
                structureboundingbox.move(i, j, k);
            }
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.store("Entrances", BoundingBox.CODEC.listOf(), this.childEntranceBoxes);
        }
    }
}

