/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final int MIN_Y_INDEX = 15;
    private final List<Setup> setups;
    public static final MapCodec<RuinedPortalStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(RuinedPortalStructure.settingsCodec(var02), (App)ExtraCodecs.nonEmptyList(Setup.CODEC.listOf()).fieldOf("setups").forGetter(var0 -> var0.setups)).apply((Applicative)var02, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.StructureSettings var0, List<Setup> var1) {
        super(var0);
        this.setups = var1;
    }

    public RuinedPortalStructure(Structure.StructureSettings var0, Setup var1) {
        this(var0, List.of(var1));
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        RuinedPortalPiece.Properties var1 = new RuinedPortalPiece.Properties();
        WorldgenRandom var2 = var0.random();
        Setup var3 = null;
        if (this.setups.size() > 1) {
            float var4 = 0.0f;
            for (Setup setup : this.setups) {
                var4 += setup.weight();
            }
            float var5 = var2.nextFloat();
            for (Setup setup : this.setups) {
                if (!((var5 -= setup.weight() / var4) < 0.0f)) continue;
                var3 = setup;
                break;
            }
        } else {
            var3 = this.setups.get(0);
        }
        if (var3 == null) {
            throw new IllegalStateException();
        }
        Setup var4 = var3;
        var1.airPocket = RuinedPortalStructure.sample(var2, var4.airPocketProbability());
        var1.mossiness = var4.mossiness();
        var1.overgrown = var4.overgrown();
        var1.vines = var4.vines();
        var1.replaceWithBlackstone = var4.replaceWithBlackstone();
        ResourceLocation var5 = var2.nextFloat() < 0.05f ? ResourceLocation.withDefaultNamespace(STRUCTURE_LOCATION_GIANT_PORTALS[var2.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : ResourceLocation.withDefaultNamespace(STRUCTURE_LOCATION_PORTALS[var2.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structureTemplate = var0.structureTemplateManager().getOrCreate(var5);
        Rotation rotation = Util.getRandom(Rotation.values(), (RandomSource)var2);
        Mirror var8 = var2.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos var9 = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        ChunkGenerator var10 = var0.chunkGenerator();
        LevelHeightAccessor var112 = var0.heightAccessor();
        RandomState var12 = var0.randomState();
        BlockPos var13 = var0.chunkPos().getWorldPosition();
        BoundingBox var14 = structureTemplate.getBoundingBox(var13, rotation, var9, var8);
        BlockPos var15 = var14.getCenter();
        int var16 = var10.getBaseHeight(var15.getX(), var15.getZ(), RuinedPortalPiece.getHeightMapType(var4.placement()), var112, var12) - 1;
        int var17 = RuinedPortalStructure.findSuitableY(var2, var10, var4.placement(), var1.airPocket, var16, var14.getYSpan(), var14, var112, var12);
        BlockPos var18 = new BlockPos(var13.getX(), var17, var13.getZ());
        return Optional.of(new Structure.GenerationStub(var18, var11 -> {
            if (var4.canBeCold()) {
                var1.cold = RuinedPortalStructure.isCold(var18, var0.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock(var18.getX()), QuartPos.fromBlock(var18.getY()), QuartPos.fromBlock(var18.getZ()), var12.sampler()), var10.getSeaLevel());
            }
            var11.addPiece(new RuinedPortalPiece(var0.structureTemplateManager(), var18, var4.placement(), var1, var5, structureTemplate, rotation, var8, var9));
        }));
    }

    private static boolean sample(WorldgenRandom var0, float var1) {
        if (var1 == 0.0f) {
            return false;
        }
        if (var1 == 1.0f) {
            return true;
        }
        return var0.nextFloat() < var1;
    }

    private static boolean isCold(BlockPos var0, Holder<Biome> var1, int var2) {
        return var1.value().coldEnoughToSnow(var0, var2);
    }

    private static int findSuitableY(RandomSource var0, ChunkGenerator var1, RuinedPortalPiece.VerticalPlacement var2, boolean var32, int var4, int var5, BoundingBox var6, LevelHeightAccessor var7, RandomState var8) {
        int var14;
        int var10 = var7.getMinY() + 15;
        if (var2 == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            var9 = var32 ? Mth.randomBetweenInclusive(var0, 32, 100) : (var0.nextFloat() < 0.5f ? Mth.randomBetweenInclusive(var0, 27, 29) : Mth.randomBetweenInclusive(var0, 29, 100));
        } else if (var2 == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.getRandomWithinInterval(var0, 70, var11);
        } else if (var2 == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.getRandomWithinInterval(var0, var10, var11);
        } else {
            var9 = var2 == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? var4 - var5 + Mth.randomBetweenInclusive(var0, 2, 8) : var4;
        }
        ImmutableList var11 = ImmutableList.of((Object)new BlockPos(var6.minX(), 0, var6.minZ()), (Object)new BlockPos(var6.maxX(), 0, var6.minZ()), (Object)new BlockPos(var6.minX(), 0, var6.maxZ()), (Object)new BlockPos(var6.maxX(), 0, var6.maxZ()));
        List var12 = var11.stream().map(var3 -> var1.getBaseColumn(var3.getX(), var3.getZ(), var7, var8)).collect(Collectors.toList());
        Heightmap.Types var13 = var2 == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        block0: for (var14 = var9; var14 > var10; --var14) {
            int var15 = 0;
            for (NoiseColumn var17 : var12) {
                BlockState var18 = var17.getBlock(var14);
                if (!var13.isOpaque().test(var18) || ++var15 != 3) continue;
                break block0;
            }
        }
        return var14;
    }

    private static int getRandomWithinInterval(RandomSource var0, int var1, int var2) {
        if (var1 < var2) {
            return Mth.randomBetweenInclusive(var0, var1, var2);
        }
        return var2;
    }

    @Override
    public StructureType<?> type() {
        return StructureType.RUINED_PORTAL;
    }

    public record Setup(RuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean canBeCold, boolean replaceWithBlackstone, float weight) {
        public static final Codec<Setup> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(Setup::canBeCold), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(Setup::replaceWithBlackstone), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)var0, Setup::new));
    }
}

