/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.SwampHutPiece;

public class SwampHutStructure
extends Structure {
    public static final MapCodec<SwampHutStructure> CODEC = SwampHutStructure.simpleCodec(SwampHutStructure::new);

    public SwampHutStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        return SwampHutStructure.onTopOfChunkCenter(var0, Heightmap.Types.WORLD_SURFACE_WG, var1 -> SwampHutStructure.generatePieces(var1, var0));
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        var0.addPiece(new SwampHutPiece(var1.random(), var1.chunkPos().getMinBlockX(), var1.chunkPos().getMinBlockZ()));
    }

    @Override
    public StructureType<?> type() {
        return StructureType.SWAMP_HUT;
    }
}

