/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class ProcessorRule {
    public static final Passthrough DEFAULT_BLOCK_ENTITY_MODIFIER = Passthrough.INSTANCE;
    public static final Codec<ProcessorRule> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RuleTest.CODEC.fieldOf("input_predicate").forGetter(var0 -> var0.inputPredicate), (App)RuleTest.CODEC.fieldOf("location_predicate").forGetter(var0 -> var0.locPredicate), (App)PosRuleTest.CODEC.lenientOptionalFieldOf("position_predicate", (Object)PosAlwaysTrueTest.INSTANCE).forGetter(var0 -> var0.posPredicate), (App)BlockState.CODEC.fieldOf("output_state").forGetter(var0 -> var0.outputState), (App)RuleBlockEntityModifier.CODEC.lenientOptionalFieldOf("block_entity_modifier", (Object)DEFAULT_BLOCK_ENTITY_MODIFIER).forGetter(var0 -> var0.blockEntityModifier)).apply((Applicative)var02, ProcessorRule::new));
    private final RuleTest inputPredicate;
    private final RuleTest locPredicate;
    private final PosRuleTest posPredicate;
    private final BlockState outputState;
    private final RuleBlockEntityModifier blockEntityModifier;

    public ProcessorRule(RuleTest var0, RuleTest var1, BlockState var2) {
        this(var0, var1, PosAlwaysTrueTest.INSTANCE, var2);
    }

    public ProcessorRule(RuleTest var0, RuleTest var1, PosRuleTest var2, BlockState var3) {
        this(var0, var1, var2, var3, DEFAULT_BLOCK_ENTITY_MODIFIER);
    }

    public ProcessorRule(RuleTest var0, RuleTest var1, PosRuleTest var2, BlockState var3, RuleBlockEntityModifier var4) {
        this.inputPredicate = var0;
        this.locPredicate = var1;
        this.posPredicate = var2;
        this.outputState = var3;
        this.blockEntityModifier = var4;
    }

    public boolean test(BlockState var0, BlockState var1, BlockPos var2, BlockPos var3, BlockPos var4, RandomSource var5) {
        return this.inputPredicate.test(var0, var5) && this.locPredicate.test(var1, var5) && this.posPredicate.test(var2, var3, var4, var5);
    }

    public BlockState getOutputState() {
        return this.outputState;
    }

    @Nullable
    public CompoundTag getOutputTag(RandomSource var0, @Nullable CompoundTag var1) {
        return this.blockEntityModifier.apply(var0, var1);
    }
}

