/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class NormalNoise {
    private static final double INPUT_FACTOR = 1.0181268882175227;
    private static final double TARGET_DEVIATION = 0.3333333333333333;
    private final double valueFactor;
    private final PerlinNoise first;
    private final PerlinNoise second;
    private final double maxValue;
    private final NoiseParameters parameters;

    @Deprecated
    public static NormalNoise createLegacyNetherBiome(RandomSource var0, NoiseParameters var1) {
        return new NormalNoise(var0, var1, false);
    }

    public static NormalNoise create(RandomSource var0, int var1, double ... var2) {
        return NormalNoise.create(var0, new NoiseParameters(var1, (DoubleList)new DoubleArrayList(var2)));
    }

    public static NormalNoise create(RandomSource var0, NoiseParameters var1) {
        return new NormalNoise(var0, var1, true);
    }

    private NormalNoise(RandomSource var0, NoiseParameters var1, boolean var2) {
        int var3 = var1.firstOctave;
        DoubleList var4 = var1.amplitudes;
        this.parameters = var1;
        if (var2) {
            this.first = PerlinNoise.create(var0, var3, var4);
            this.second = PerlinNoise.create(var0, var3, var4);
        } else {
            this.first = PerlinNoise.createLegacyForLegacyNetherBiome(var0, var3, var4);
            this.second = PerlinNoise.createLegacyForLegacyNetherBiome(var0, var3, var4);
        }
        int var5 = Integer.MAX_VALUE;
        int var6 = Integer.MIN_VALUE;
        DoubleListIterator var7 = var4.iterator();
        while (var7.hasNext()) {
            int var8 = var7.nextIndex();
            double var9 = var7.nextDouble();
            if (var9 == 0.0) continue;
            var5 = Math.min(var5, var8);
            var6 = Math.max(var6, var8);
        }
        this.valueFactor = 0.16666666666666666 / NormalNoise.expectedDeviation(var6 - var5);
        this.maxValue = (this.first.maxValue() + this.second.maxValue()) * this.valueFactor;
    }

    public double maxValue() {
        return this.maxValue;
    }

    private static double expectedDeviation(int var0) {
        return 0.1 * (1.0 + 1.0 / (double)(var0 + 1));
    }

    public double getValue(double var0, double var2, double var4) {
        double var6 = var0 * 1.0181268882175227;
        double var8 = var2 * 1.0181268882175227;
        double var10 = var4 * 1.0181268882175227;
        return (this.first.getValue(var0, var2, var4) + this.second.getValue(var6, var8, var10)) * this.valueFactor;
    }

    public NoiseParameters parameters() {
        return this.parameters;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        var0.append("NormalNoise {");
        var0.append("first: ");
        this.first.parityConfigString(var0);
        var0.append(", second: ");
        this.second.parityConfigString(var0);
        var0.append("}");
    }

    public static final class NoiseParameters
    extends Record {
        final int firstOctave;
        final DoubleList amplitudes;
        public static final Codec<NoiseParameters> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("firstOctave").forGetter(NoiseParameters::firstOctave), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(NoiseParameters::amplitudes)).apply((Applicative)var0, NoiseParameters::new));
        public static final Codec<Holder<NoiseParameters>> CODEC = RegistryFileCodec.create(Registries.NOISE, DIRECT_CODEC);

        public NoiseParameters(int var0, List<Double> var1) {
            this(var0, (DoubleList)new DoubleArrayList(var1));
        }

        public NoiseParameters(int var0, double var1, double ... var3) {
            this(var0, (DoubleList)Util.make(new DoubleArrayList(var3), var2 -> var2.add(0, var1)));
        }

        public NoiseParameters(int var0, DoubleList var1) {
            this.firstOctave = var0;
            this.amplitudes = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseParameters.class, "firstOctave;amplitudes", "firstOctave", "amplitudes"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseParameters.class, "firstOctave;amplitudes", "firstOctave", "amplitudes"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseParameters.class, "firstOctave;amplitudes", "firstOctave", "amplitudes"}, this, var0);
        }

        public int firstOctave() {
            return this.firstOctave;
        }

        public DoubleList amplitudes() {
            return this.amplitudes;
        }
    }
}

