/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<BlockStatePairKey>(200){

            protected void rehash(int i) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> blockstatelist_a) {
        blockstatelist_a.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter iblockaccess, BlockPos blockposition, FluidState fluid) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
            FluidState fluid1 = iblockaccess.getFluidState(blockposition_mutableblockposition);
            if (!this.affectsFlow(fluid1)) continue;
            float f = fluid1.getOwnHeight();
            float f1 = 0.0f;
            if (f == 0.0f) {
                Vec3i blockposition1;
                FluidState fluid2;
                if (!iblockaccess.getBlockState(blockposition_mutableblockposition).blocksMotion() && this.affectsFlow(fluid2 = iblockaccess.getFluidState((BlockPos)(blockposition1 = blockposition_mutableblockposition.below()))) && (f = fluid2.getOwnHeight()) > 0.0f) {
                    f1 = fluid.getOwnHeight() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = fluid.getOwnHeight() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)enumdirection.getStepX() * f1);
            d1 += (double)((float)enumdirection.getStepZ() * f1);
        }
        Vec3 vec3d = new Vec3(d0, 0.0, d1);
        if (fluid.getValue(FALLING).booleanValue()) {
            for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
                blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection1);
                if (!this.isSolidFace(iblockaccess, blockposition_mutableblockposition, enumdirection1) && !this.isSolidFace(iblockaccess, (BlockPos)blockposition_mutableblockposition.above(), enumdirection1)) continue;
                vec3d = vec3d.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.normalize();
    }

    private boolean affectsFlow(FluidState fluid) {
        return fluid.isEmpty() || fluid.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        BlockState iblockdata = iblockaccess.getBlockState(blockposition);
        FluidState fluid = iblockaccess.getFluidState(blockposition);
        return fluid.getType().isSame(this) ? false : (enumdirection == Direction.UP ? true : (iblockdata.getBlock() instanceof IceBlock ? false : iblockdata.isFaceSturdy(iblockaccess, blockposition, enumdirection)));
    }

    protected void spread(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, FluidState fluid) {
        if (!fluid.isEmpty()) {
            FluidState fluid2;
            Fluid fluidtype;
            FluidState fluid1;
            BlockState iblockdata1;
            BlockPos blockposition1 = blockposition.below();
            if (this.canMaybePassThrough(worldserver, blockposition, iblockdata, Direction.DOWN, blockposition1, iblockdata1 = worldserver.getBlockState(blockposition1), fluid1 = iblockdata1.getFluidState()) && fluid1.canBeReplacedWith(worldserver, blockposition1, fluidtype = (fluid2 = this.getNewLiquid(worldserver, blockposition1, iblockdata1)).getType(), Direction.DOWN) && FlowingFluid.canHoldSpecificFluid(worldserver, blockposition1, iblockdata1, fluidtype)) {
                CraftBlock source = CraftBlock.at(worldserver, blockposition);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.spreadTo(worldserver, blockposition1, iblockdata1, Direction.DOWN, fluid2);
                if (this.sourceNeighborCount(worldserver, blockposition) >= 3) {
                    this.spreadToSides(worldserver, blockposition, fluid, iblockdata);
                }
                return;
            }
            if (fluid.isSource() || !this.isWaterHole(worldserver, blockposition, iblockdata, blockposition1, iblockdata1)) {
                this.spreadToSides(worldserver, blockposition, fluid, iblockdata);
            }
        }
    }

    private void spreadToSides(ServerLevel worldserver, BlockPos blockposition, FluidState fluid, BlockState iblockdata) {
        int i = fluid.getAmount() - this.getDropOff(worldserver);
        if (fluid.getValue(FALLING).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.getSpread(worldserver, blockposition, iblockdata);
            for (Map.Entry<Direction, FluidState> map_entry : map.entrySet()) {
                Direction enumdirection = map_entry.getKey();
                FluidState fluid1 = map_entry.getValue();
                BlockPos blockposition1 = blockposition.relative(enumdirection);
                CraftBlock source = CraftBlock.at(worldserver, blockposition);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(enumdirection));
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.spreadTo(worldserver, blockposition1, worldserver.getBlockState(blockposition1), enumdirection, fluid1);
            }
        }
    }

    protected FluidState getNewLiquid(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata) {
        BlockPos.MutableBlockPos blockposition2;
        BlockState iblockdata3;
        FluidState fluid2;
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos blockposition1 = blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
            BlockState iblockdata1 = worldserver.getBlockState(blockposition1);
            FluidState fluid = iblockdata1.getFluidState();
            if (!fluid.getType().isSame(this) || !FlowingFluid.canPassThroughWall(enumdirection, worldserver, blockposition, iblockdata, blockposition1, iblockdata1)) continue;
            if (fluid.isSource()) {
                ++j;
            }
            i = Math.max(i, fluid.getAmount());
        }
        if (j >= 2 && this.canConvertToSource(worldserver)) {
            BlockState iblockdata2 = worldserver.getBlockState(blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, Direction.DOWN));
            FluidState fluid1 = iblockdata2.getFluidState();
            if (iblockdata2.isSolid() || this.isSourceBlockOfThisType(fluid1)) {
                return this.getSource(false);
            }
        }
        if (!(fluid2 = (iblockdata3 = worldserver.getBlockState(blockposition2 = blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, Direction.UP))).getFluidState()).isEmpty() && fluid2.getType().isSame(this) && FlowingFluid.canPassThroughWall(Direction.UP, worldserver, blockposition, iblockdata, blockposition2, iblockdata3)) {
            return this.getFlowing(8, true);
        }
        int k = i - this.getDropOff(worldserver);
        if (k <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.getFlowing(k, false);
    }

    private static boolean canPassThroughWall(Direction enumdirection, BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, BlockPos blockposition1, BlockState iblockdata1) {
        if (!(SharedConstants.DEBUG_DISABLE_LIQUID_SPREADING || SharedConstants.DEBUG_ONLY_GENERATE_HALF_THE_WORLD && blockposition1.getZ() < 0)) {
            boolean flag;
            BlockStatePairKey fluidtypeflowing_a;
            VoxelShape voxelshape = iblockdata1.getCollisionShape(iblockaccess, blockposition1);
            if (voxelshape == Shapes.block()) {
                return false;
            }
            VoxelShape voxelshape1 = iblockdata.getCollisionShape(iblockaccess, blockposition);
            if (voxelshape1 == Shapes.block()) {
                return false;
            }
            if (voxelshape1 == Shapes.empty() && voxelshape == Shapes.empty()) {
                return true;
            }
            Object2ByteLinkedOpenHashMap<BlockStatePairKey> object2bytelinkedopenhashmap = !iblockdata.getBlock().hasDynamicShape() && !iblockdata1.getBlock().hasDynamicShape() ? OCCLUSION_CACHE.get() : null;
            if (object2bytelinkedopenhashmap != null) {
                fluidtypeflowing_a = new BlockStatePairKey(iblockdata, iblockdata1, enumdirection);
                byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)fluidtypeflowing_a);
                if (b0 != 127) {
                    return b0 != 0;
                }
            } else {
                fluidtypeflowing_a = null;
            }
            boolean bl = flag = !Shapes.mergedFaceOccludes(voxelshape1, voxelshape, enumdirection);
            if (object2bytelinkedopenhashmap != null) {
                if (object2bytelinkedopenhashmap.size() == 200) {
                    object2bytelinkedopenhashmap.removeLastByte();
                }
                object2bytelinkedopenhashmap.putAndMoveToFirst((Object)fluidtypeflowing_a, (byte)(flag ? 1 : 0));
            }
            return flag;
        }
        return false;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int i, boolean flag) {
        return (FluidState)((FluidState)this.getFlowing().defaultFluidState().setValue(LEVEL, i)).setValue(FALLING, flag);
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean flag) {
        return (FluidState)this.getSource().defaultFluidState().setValue(FALLING, flag);
    }

    protected abstract boolean canConvertToSource(ServerLevel var1);

    protected void spreadTo(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata, Direction enumdirection, FluidState fluid) {
        Block block = iblockdata.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer = (LiquidBlockContainer)((Object)block);
            ifluidcontainer.placeLiquid(generatoraccess, blockposition, iblockdata, fluid);
        } else {
            if (!iblockdata.isAir()) {
                this.beforeDestroyingBlock(generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.setBlock(blockposition, fluid.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    protected int getSlopeDistance(LevelReader iworldreader, BlockPos blockposition, int i, Direction enumdirection, BlockState iblockdata, SpreadContext fluidtypeflowing_b) {
        int j = 1000;
        for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
            int k;
            if (enumdirection1 == enumdirection) continue;
            BlockPos blockposition1 = blockposition.relative(enumdirection1);
            BlockState iblockdata1 = fluidtypeflowing_b.getBlockState(blockposition1);
            FluidState fluid = iblockdata1.getFluidState();
            if (!this.canPassThrough(iworldreader, this.getFlowing(), blockposition, iblockdata, enumdirection1, blockposition1, iblockdata1, fluid)) continue;
            if (fluidtypeflowing_b.isHole(blockposition1)) {
                return i;
            }
            if (i >= this.getSlopeFindDistance(iworldreader) || (k = this.getSlopeDistance(iworldreader, blockposition1, i + 1, enumdirection1.getOpposite(), iblockdata1, fluidtypeflowing_b)) >= j) continue;
            j = k;
        }
        return j;
    }

    boolean isWaterHole(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, BlockPos blockposition1, BlockState iblockdata1) {
        return !FlowingFluid.canPassThroughWall(Direction.DOWN, iblockaccess, blockposition, iblockdata, blockposition1, iblockdata1) ? false : (iblockdata1.getFluidState().getType().isSame(this) ? true : FlowingFluid.canHoldFluid(iblockaccess, blockposition1, iblockdata1, this.getFlowing()));
    }

    private boolean canPassThrough(BlockGetter iblockaccess, Fluid fluidtype, BlockPos blockposition, BlockState iblockdata, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, FluidState fluid) {
        return this.canMaybePassThrough(iblockaccess, blockposition, iblockdata, enumdirection, blockposition1, iblockdata1, fluid) && FlowingFluid.canHoldSpecificFluid(iblockaccess, blockposition1, iblockdata1, fluidtype);
    }

    private boolean canMaybePassThrough(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, FluidState fluid) {
        return !this.isSourceBlockOfThisType(fluid) && FlowingFluid.canHoldAnyFluid(iblockdata1) && FlowingFluid.canPassThroughWall(enumdirection, iblockaccess, blockposition, iblockdata, blockposition1, iblockdata1);
    }

    private boolean isSourceBlockOfThisType(FluidState fluid) {
        return fluid.getType().isSame(this) && fluid.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader iworldreader, BlockPos blockposition) {
        int i = 0;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            FluidState fluid = iworldreader.getFluidState(blockposition1);
            if (!this.isSourceBlockOfThisType(fluid)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> getSpread(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        SpreadContext fluidtypeflowing_b = null;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            int j;
            FluidState fluid1;
            FluidState fluid;
            BlockState iblockdata1;
            BlockPos blockposition1;
            if (!this.canMaybePassThrough(worldserver, blockposition, iblockdata, enumdirection, blockposition1 = blockposition.relative(enumdirection), iblockdata1 = worldserver.getBlockState(blockposition1), fluid = iblockdata1.getFluidState()) || !FlowingFluid.canHoldSpecificFluid(worldserver, blockposition1, iblockdata1, (fluid1 = this.getNewLiquid(worldserver, blockposition1, iblockdata1)).getType())) continue;
            if (fluidtypeflowing_b == null) {
                fluidtypeflowing_b = new SpreadContext(worldserver, blockposition);
            }
            if ((j = fluidtypeflowing_b.isHole(blockposition1) ? 0 : this.getSlopeDistance(worldserver, blockposition1, 1, enumdirection.getOpposite(), iblockdata1, fluidtypeflowing_b)) < i) {
                map.clear();
            }
            if (j > i) continue;
            if (fluid.canBeReplacedWith(worldserver, blockposition1, fluid1.getType(), enumdirection)) {
                map.put(enumdirection, fluid1);
            }
            i = j;
        }
        return map;
    }

    private static boolean canHoldAnyFluid(BlockState iblockdata) {
        Block block = iblockdata.getBlock();
        return block instanceof LiquidBlockContainer ? true : (iblockdata.blocksMotion() ? false : !(block instanceof DoorBlock) && !iblockdata.is(BlockTags.SIGNS) && !iblockdata.is(Blocks.LADDER) && !iblockdata.is(Blocks.SUGAR_CANE) && !iblockdata.is(Blocks.BUBBLE_COLUMN) && !iblockdata.is(Blocks.NETHER_PORTAL) && !iblockdata.is(Blocks.END_PORTAL) && !iblockdata.is(Blocks.END_GATEWAY) && !iblockdata.is(Blocks.STRUCTURE_VOID));
    }

    private static boolean canHoldFluid(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, Fluid fluidtype) {
        return FlowingFluid.canHoldAnyFluid(iblockdata) && FlowingFluid.canHoldSpecificFluid(iblockaccess, blockposition, iblockdata, fluidtype);
    }

    private static boolean canHoldSpecificFluid(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, Fluid fluidtype) {
        Block block = iblockdata.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer = (LiquidBlockContainer)((Object)block);
            return ifluidcontainer.canPlaceLiquid(null, iblockaccess, blockposition, iblockdata, fluidtype);
        }
        return true;
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level world, BlockPos blockposition, FluidState fluid, FluidState fluid1) {
        return this.getTickDelay(world);
    }

    @Override
    public void tick(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, FluidState fluid) {
        if (!fluid.isSource()) {
            FluidState fluid1 = this.getNewLiquid(worldserver, blockposition, worldserver.getBlockState(blockposition));
            int i = this.getSpreadDelay(worldserver, blockposition, fluid, fluid1);
            if (fluid1.isEmpty()) {
                fluid = fluid1;
                iblockdata = Blocks.AIR.defaultBlockState();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(worldserver, blockposition, iblockdata);
                if (event.isCancelled()) {
                    return;
                }
                iblockdata = ((CraftBlockData)event.getNewData()).getState();
                worldserver.setBlock(blockposition, iblockdata, 3);
            } else if (fluid1 != fluid) {
                fluid = fluid1;
                iblockdata = fluid1.createLegacyBlock();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(worldserver, blockposition, iblockdata);
                if (event.isCancelled()) {
                    return;
                }
                iblockdata = ((CraftBlockData)event.getNewData()).getState();
                worldserver.setBlock(blockposition, iblockdata, 3);
                worldserver.scheduleTick(blockposition, fluid1.getType(), i);
            }
        }
        this.spread(worldserver, blockposition, iblockdata, fluid);
    }

    protected static int getLegacyLevel(FluidState fluid) {
        return fluid.isSource() ? 0 : 8 - Math.min(fluid.getAmount(), 8) + (fluid.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState fluid, BlockGetter iblockaccess, BlockPos blockposition) {
        return fluid.getType().isSame(iblockaccess.getFluidState(blockposition.above()).getType());
    }

    @Override
    public float getHeight(FluidState fluid, BlockGetter iblockaccess, BlockPos blockposition) {
        return FlowingFluid.hasSameAbove(fluid, iblockaccess, blockposition) ? 1.0f : fluid.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState fluid) {
        return (float)fluid.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState fluid, BlockGetter iblockaccess, BlockPos blockposition) {
        return fluid.getAmount() == 9 && FlowingFluid.hasSameAbove(fluid, iblockaccess, blockposition) ? Shapes.block() : this.shapes.computeIfAbsent(fluid, fluid1 -> Shapes.box(0.0, 0.0, 0.0, 1.0, fluid1.getHeight(iblockaccess, blockposition), 1.0));
    }

    private record BlockStatePairKey(BlockState first, BlockState second, Direction direction) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof BlockStatePairKey) {
                BlockStatePairKey fluidtypeflowing_a = (BlockStatePairKey)object;
                if (this.first == fluidtypeflowing_a.first && this.second == fluidtypeflowing_a.second && this.direction == fluidtypeflowing_a.direction) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            int i = System.identityHashCode(this.first);
            i = 31 * i + System.identityHashCode(this.second);
            i = 31 * i + this.direction.hashCode();
            return i;
        }
    }

    protected class SpreadContext {
        private final BlockGetter level;
        private final BlockPos origin;
        private final Short2ObjectMap<BlockState> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap holeCache = new Short2BooleanOpenHashMap();

        SpreadContext(BlockGetter iblockaccess, BlockPos blockposition) {
            this.level = iblockaccess;
            this.origin = blockposition;
        }

        public BlockState getBlockState(BlockPos blockposition) {
            return this.getBlockState(blockposition, this.getCacheKey(blockposition));
        }

        private BlockState getBlockState(BlockPos blockposition, short short0) {
            return (BlockState)this.stateCache.computeIfAbsent(short0, short1 -> this.level.getBlockState(blockposition));
        }

        public boolean isHole(BlockPos blockposition) {
            return this.holeCache.computeIfAbsent(this.getCacheKey(blockposition), short0 -> {
                BlockState iblockdata = this.getBlockState(blockposition, short0);
                BlockPos blockposition1 = blockposition.below();
                BlockState iblockdata1 = this.level.getBlockState(blockposition1);
                return FlowingFluid.this.isWaterHole(this.level, blockposition, iblockdata, blockposition1, iblockdata1);
            });
        }

        private short getCacheKey(BlockPos blockposition) {
            int i = blockposition.getX() - this.origin.getX();
            int j = blockposition.getZ() - this.origin.getZ();
            return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
        }
    }
}

