/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.OptionalDynamic;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.TimerCallbacks;
import net.minecraft.world.level.timers.TimerQueue;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class PrimaryLevelData
implements ServerLevelData,
WorldData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String LEVEL_NAME = "LevelName";
    protected static final String PLAYER = "Player";
    protected static final String WORLD_GEN_SETTINGS = "WorldGenSettings";
    public LevelSettings settings;
    private final WorldOptions worldOptions;
    private final SpecialWorldProperty specialWorldProperty;
    private final Lifecycle worldGenSettingsLifecycle;
    private LevelData.RespawnData respawnData;
    private long gameTime;
    private long dayTime;
    @Nullable
    private final CompoundTag loadedPlayerTag;
    private final int version;
    private int clearWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private boolean initialized;
    private boolean difficultyLocked;
    @Deprecated
    private Optional<WorldBorder.Settings> legacyWorldBorderSettings;
    private EndDragonFight.Data endDragonFightData;
    @Nullable
    private CompoundTag customBossEvents;
    private int wanderingTraderSpawnDelay;
    private int wanderingTraderSpawnChance;
    @Nullable
    private UUID wanderingTraderId;
    private final Set<String> knownServerBrands;
    private boolean wasModded;
    private final Set<String> removedFeatureFlags;
    private final TimerQueue<MinecraftServer> scheduledEvents;
    public Registry<LevelStem> customDimensions;
    private ServerLevel world;
    protected Tag pdc;

    public void setWorld(ServerLevel world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private PrimaryLevelData(@Nullable CompoundTag nbttagcompound, boolean flag, LevelData.RespawnData worlddata_a, long i, long j, int k, int l, int i1, boolean flag1, int j1, boolean flag2, boolean flag3, boolean flag4, Optional<WorldBorder.Settings> optional, int k1, int l1, @Nullable UUID uuid, Set<String> set, Set<String> set1, TimerQueue<MinecraftServer> customfunctioncallbacktimerqueue, @Nullable CompoundTag nbttagcompound1, EndDragonFight.Data enderdragonbattle_a, LevelSettings worldsettings, WorldOptions worldoptions, SpecialWorldProperty worlddataserver_a, Lifecycle lifecycle) {
        this.wasModded = flag;
        this.respawnData = worlddata_a;
        this.gameTime = i;
        this.dayTime = j;
        this.version = k;
        this.clearWeatherTime = l;
        this.rainTime = i1;
        this.raining = flag1;
        this.thunderTime = j1;
        this.thundering = flag2;
        this.initialized = flag3;
        this.difficultyLocked = flag4;
        this.legacyWorldBorderSettings = optional;
        this.wanderingTraderSpawnDelay = k1;
        this.wanderingTraderSpawnChance = l1;
        this.wanderingTraderId = uuid;
        this.knownServerBrands = set;
        this.removedFeatureFlags = set1;
        this.loadedPlayerTag = nbttagcompound;
        this.scheduledEvents = customfunctioncallbacktimerqueue;
        this.customBossEvents = nbttagcompound1;
        this.endDragonFightData = enderdragonbattle_a;
        this.settings = worldsettings;
        this.worldOptions = worldoptions;
        this.specialWorldProperty = worlddataserver_a;
        this.worldGenSettingsLifecycle = lifecycle;
    }

    public PrimaryLevelData(LevelSettings worldsettings, WorldOptions worldoptions, SpecialWorldProperty worlddataserver_a, Lifecycle lifecycle) {
        this(null, false, LevelData.RespawnData.DEFAULT, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, Optional.empty(), 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new TimerQueue<MinecraftServer>(TimerCallbacks.SERVER_CALLBACKS), null, EndDragonFight.Data.DEFAULT, worldsettings.copy(), worldoptions, worlddataserver_a, lifecycle);
    }

    public static <T> PrimaryLevelData parse(Dynamic<T> dynamic, LevelSettings worldsettings, SpecialWorldProperty worlddataserver_a, WorldOptions worldoptions, Lifecycle lifecycle) {
        long i = dynamic.get("Time").asLong(0L);
        OptionalDynamic optionaldynamic = dynamic.get(PLAYER);
        Codec<CompoundTag> codec = CompoundTag.CODEC;
        Objects.requireNonNull(codec);
        CompoundTag nbttagcompound = optionaldynamic.flatMap(arg_0 -> codec.parse(arg_0)).result().orElse(null);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        LevelData.RespawnData worlddata_a = dynamic.get("spawn").read(LevelData.RespawnData.CODEC).result().orElse(LevelData.RespawnData.DEFAULT);
        long j = dynamic.get("DayTime").asLong(i);
        int k = LevelVersion.parse(dynamic).levelDataVersion();
        int l = dynamic.get("clearWeatherTime").asInt(0);
        int i1 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int j1 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        Optional optional = WorldBorder.Settings.CODEC.parse(dynamic.get("world_border").orElseEmptyMap()).result();
        int k1 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int l1 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.CODEC).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        TimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new TimerQueue<MinecraftServer>(TimerCallbacks.SERVER_CALLBACKS, dynamic.get("ScheduledEvents").asStream());
        CompoundTag nbttagcompound1 = (CompoundTag)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EndDragonFight.Data.CODEC);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        return new PrimaryLevelData(nbttagcompound, flag, worlddata_a, i, j, k, l, i1, flag1, j1, flag2, flag3, flag4, optional, k1, l1, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EndDragonFight.Data.DEFAULT), worldsettings, worldoptions, worlddataserver_a, lifecycle);
    }

    @Override
    public CompoundTag createTag(RegistryAccess iregistrycustom, @Nullable CompoundTag nbttagcompound) {
        if (nbttagcompound == null) {
            nbttagcompound = this.loadedPlayerTag;
        }
        CompoundTag nbttagcompound1 = new CompoundTag();
        this.setTagData(iregistrycustom, nbttagcompound1, nbttagcompound);
        return nbttagcompound1;
    }

    private void setTagData(RegistryAccess iregistrycustom, CompoundTag nbttagcompound, @Nullable CompoundTag nbttagcompound1) {
        nbttagcompound.put("ServerBrands", PrimaryLevelData.stringCollectionToTag(this.knownServerBrands));
        nbttagcompound.putBoolean("WasModded", this.wasModded);
        if (!this.removedFeatureFlags.isEmpty()) {
            nbttagcompound.put("removed_features", PrimaryLevelData.stringCollectionToTag(this.removedFeatureFlags));
        }
        CompoundTag nbttagcompound2 = new CompoundTag();
        nbttagcompound2.putString("Name", SharedConstants.getCurrentVersion().name());
        nbttagcompound2.putInt("Id", SharedConstants.getCurrentVersion().dataVersion().version());
        nbttagcompound2.putBoolean("Snapshot", !SharedConstants.getCurrentVersion().stable());
        nbttagcompound2.putString("Series", SharedConstants.getCurrentVersion().dataVersion().series());
        nbttagcompound.put("Version", nbttagcompound2);
        NbtUtils.addCurrentDataVersion(nbttagcompound);
        RegistryOps<Tag> dynamicops = iregistrycustom.createSerializationContext(NbtOps.INSTANCE);
        DataResult<Tag> dataresult = WorldGenSettings.encode(dynamicops, this.worldOptions, new WorldDimensions((Registry<LevelStem>)(this.customDimensions != null ? this.customDimensions : iregistrycustom.lookupOrThrow(Registries.LEVEL_STEM))));
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(Util.prefix("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> nbttagcompound.put(WORLD_GEN_SETTINGS, (Tag)nbtbase));
        nbttagcompound.putInt("GameType", this.settings.gameType().getId());
        nbttagcompound.store("spawn", LevelData.RespawnData.CODEC, this.respawnData);
        nbttagcompound.putLong("Time", this.gameTime);
        nbttagcompound.putLong("DayTime", this.dayTime);
        nbttagcompound.putLong("LastPlayed", Util.getEpochMillis());
        nbttagcompound.putString(LEVEL_NAME, this.settings.levelName());
        nbttagcompound.putInt("version", 19133);
        nbttagcompound.putInt("clearWeatherTime", this.clearWeatherTime);
        nbttagcompound.putInt("rainTime", this.rainTime);
        nbttagcompound.putBoolean("raining", this.raining);
        nbttagcompound.putInt("thunderTime", this.thunderTime);
        nbttagcompound.putBoolean("thundering", this.thundering);
        nbttagcompound.putBoolean("hardcore", this.settings.hardcore());
        nbttagcompound.putBoolean("allowCommands", this.settings.allowCommands());
        nbttagcompound.putBoolean("initialized", this.initialized);
        this.legacyWorldBorderSettings.ifPresent(worldborder_c -> nbttagcompound.store("world_border", WorldBorder.Settings.CODEC, worldborder_c));
        nbttagcompound.putByte("Difficulty", (byte)this.settings.difficulty().getId());
        nbttagcompound.putBoolean("DifficultyLocked", this.difficultyLocked);
        nbttagcompound.put("GameRules", this.settings.gameRules().createTag());
        nbttagcompound.store("DragonFight", EndDragonFight.Data.CODEC, this.endDragonFightData);
        if (nbttagcompound1 != null) {
            nbttagcompound.put(PLAYER, nbttagcompound1);
        }
        nbttagcompound.store(WorldDataConfiguration.MAP_CODEC, this.settings.getDataConfiguration());
        if (this.customBossEvents != null) {
            nbttagcompound.put("CustomBossEvents", this.customBossEvents);
        }
        nbttagcompound.put("ScheduledEvents", this.scheduledEvents.store());
        nbttagcompound.putInt("WanderingTraderSpawnDelay", this.wanderingTraderSpawnDelay);
        nbttagcompound.putInt("WanderingTraderSpawnChance", this.wanderingTraderSpawnChance);
        nbttagcompound.storeNullable("WanderingTraderId", UUIDUtil.CODEC, this.wanderingTraderId);
        nbttagcompound.putString("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(nbttagcompound);
    }

    private static ListTag stringCollectionToTag(Set<String> set) {
        ListTag nbttaglist = new ListTag();
        Stream<StringTag> stream = set.stream().map(StringTag::valueOf);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public LevelData.RespawnData getRespawnData() {
        return this.respawnData;
    }

    @Override
    public long getGameTime() {
        return this.gameTime;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    @Override
    @Nullable
    public CompoundTag getLoadedPlayerTag() {
        return this.loadedPlayerTag;
    }

    @Override
    public void setGameTime(long i) {
        this.gameTime = i;
    }

    @Override
    public void setDayTime(long i) {
        this.dayTime = i;
    }

    @Override
    public void setSpawn(LevelData.RespawnData worlddata_a) {
        this.respawnData = worlddata_a;
    }

    @Override
    public String getLevelName() {
        return this.settings.levelName();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getClearWeatherTime() {
        return this.clearWeatherTime;
    }

    @Override
    public void setClearWeatherTime(int i) {
        this.clearWeatherTime = i;
    }

    @Override
    public boolean isThundering() {
        return this.thundering;
    }

    @Override
    public void setThundering(boolean flag) {
        if (this.thundering == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.getLevelName());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.thundering = flag;
    }

    @Override
    public int getThunderTime() {
        return this.thunderTime;
    }

    @Override
    public void setThunderTime(int i) {
        this.thunderTime = i;
    }

    @Override
    public boolean isRaining() {
        return this.raining;
    }

    @Override
    public void setRaining(boolean flag) {
        if (this.raining == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.getLevelName());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.raining = flag;
    }

    @Override
    public int getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(int i) {
        this.rainTime = i;
    }

    @Override
    public GameType getGameType() {
        return this.settings.gameType();
    }

    @Override
    public void setGameType(GameType enumgamemode) {
        this.settings = this.settings.withGameType(enumgamemode);
    }

    @Override
    public boolean isHardcore() {
        return this.settings.hardcore();
    }

    @Override
    public boolean isAllowCommands() {
        return this.settings.allowCommands();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean flag) {
        this.initialized = flag;
    }

    @Override
    public GameRules getGameRules() {
        return this.settings.gameRules();
    }

    @Override
    public Optional<WorldBorder.Settings> getLegacyWorldBorderSettings() {
        return this.legacyWorldBorderSettings;
    }

    @Override
    public void setLegacyWorldBorderSettings(Optional<WorldBorder.Settings> optional) {
        this.legacyWorldBorderSettings = optional;
    }

    @Override
    public Difficulty getDifficulty() {
        return this.settings.difficulty();
    }

    @Override
    public void setDifficulty(Difficulty enumdifficulty) {
        this.settings = this.settings.withDifficulty(enumdifficulty);
        ClientboundChangeDifficultyPacket packet = new ClientboundChangeDifficultyPacket(this.getDifficulty(), this.isDifficultyLocked());
        for (ServerPlayer player : this.world.players()) {
            player.connection.send(packet);
        }
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean flag) {
        this.difficultyLocked = flag;
    }

    @Override
    public TimerQueue<MinecraftServer> getScheduledEvents() {
        return this.scheduledEvents;
    }

    @Override
    public void fillCrashReportCategory(CrashReportCategory crashreportsystemdetails, LevelHeightAccessor levelheightaccessor) {
        ServerLevelData.super.fillCrashReportCategory(crashreportsystemdetails, levelheightaccessor);
        WorldData.super.fillCrashReportCategory(crashreportsystemdetails);
    }

    @Override
    public WorldOptions worldGenOptions() {
        return this.worldOptions;
    }

    @Override
    public boolean isFlatWorld() {
        return this.specialWorldProperty == SpecialWorldProperty.FLAT;
    }

    @Override
    public boolean isDebugWorld() {
        return this.specialWorldProperty == SpecialWorldProperty.DEBUG;
    }

    @Override
    public Lifecycle worldGenSettingsLifecycle() {
        return this.worldGenSettingsLifecycle;
    }

    @Override
    public EndDragonFight.Data endDragonFightData() {
        return this.endDragonFightData;
    }

    @Override
    public void setEndDragonFightData(EndDragonFight.Data enderdragonbattle_a) {
        this.endDragonFightData = enderdragonbattle_a;
    }

    @Override
    public WorldDataConfiguration getDataConfiguration() {
        return this.settings.getDataConfiguration();
    }

    @Override
    public void setDataConfiguration(WorldDataConfiguration worlddataconfiguration) {
        this.settings = this.settings.withDataConfiguration(worlddataconfiguration);
    }

    @Override
    @Nullable
    public CompoundTag getCustomBossEvents() {
        return this.customBossEvents;
    }

    @Override
    public void setCustomBossEvents(@Nullable CompoundTag nbttagcompound) {
        this.customBossEvents = nbttagcompound;
    }

    @Override
    public int getWanderingTraderSpawnDelay() {
        return this.wanderingTraderSpawnDelay;
    }

    @Override
    public void setWanderingTraderSpawnDelay(int i) {
        this.wanderingTraderSpawnDelay = i;
    }

    @Override
    public int getWanderingTraderSpawnChance() {
        return this.wanderingTraderSpawnChance;
    }

    @Override
    public void setWanderingTraderSpawnChance(int i) {
        this.wanderingTraderSpawnChance = i;
    }

    @Override
    @Nullable
    public UUID getWanderingTraderId() {
        return this.wanderingTraderId;
    }

    @Override
    public void setWanderingTraderId(UUID uuid) {
        this.wanderingTraderId = uuid;
    }

    @Override
    public void setModdedInfo(String s, boolean flag) {
        this.knownServerBrands.add(s);
        this.wasModded |= flag;
    }

    @Override
    public boolean wasModded() {
        return this.wasModded;
    }

    @Override
    public Set<String> getKnownServerBrands() {
        return ImmutableSet.copyOf(this.knownServerBrands);
    }

    @Override
    public Set<String> getRemovedFeatureFlags() {
        return Set.copyOf(this.removedFeatureFlags);
    }

    @Override
    public ServerLevelData overworldData() {
        return this;
    }

    @Override
    public LevelSettings getLevelSettings() {
        return this.settings.copy();
    }

    public void checkName(String name) {
        if (!this.settings.levelName.equals(name)) {
            this.settings.levelName = name;
        }
    }

    @Deprecated
    public static enum SpecialWorldProperty {
        NONE,
        FLAT,
        DEBUG;

    }
}

