/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DynamicLoot
extends LootPoolSingletonContainer {
    public static final MapCodec<DynamicLoot> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(var0 -> var0.name)).and(DynamicLoot.singletonFields(var02)).apply((Applicative)var02, DynamicLoot::new));
    private final ResourceLocation name;

    private DynamicLoot(ResourceLocation var0, int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4) {
        super(var1, var2, var3, var4);
        this.name = var0;
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.DYNAMIC;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootContext var1) {
        var1.addDynamicDrops(this.name, var0);
    }

    public static LootPoolSingletonContainer.Builder<?> dynamicEntry(ResourceLocation var0) {
        return DynamicLoot.simpleBuilder((var1, var2, var3, var4) -> new DynamicLoot(var0, var1, var2, var3, var4));
    }
}

