/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyComponentsFunction
extends LootItemConditionalFunction {
    private static final ExtraCodecs.LateBoundIdMapper<String, Source<?>> SOURCES = new ExtraCodecs.LateBoundIdMapper();
    public static final MapCodec<CopyComponentsFunction> CODEC;
    private final Source<?> source;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    private final Predicate<DataComponentType<?>> bakedPredicate;

    CopyComponentsFunction(List<LootItemCondition> var0, Source<?> var13, Optional<List<DataComponentType<?>>> var2, Optional<List<DataComponentType<?>>> var3) {
        super(var0);
        this.source = var13;
        this.include = var2.map(List::copyOf);
        this.exclude = var3.map(List::copyOf);
        ArrayList var4 = new ArrayList(2);
        var3.ifPresent(var12 -> var4.add(var1 -> !var12.contains(var1)));
        var2.ifPresent(var1 -> var4.add(var1::contains));
        this.bakedPredicate = Util.allOf(var4);
    }

    public LootItemFunctionType<CopyComponentsFunction> getType() {
        return LootItemFunctions.COPY_COMPONENTS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        DataComponentGetter var2 = this.source.get(var1);
        if (var2 != null) {
            if (var2 instanceof DataComponentMap) {
                DataComponentMap var32 = (DataComponentMap)var2;
                var0.applyComponents(var32.filter(this.bakedPredicate));
            } else {
                Collection var4 = this.exclude.orElse(List.of());
                this.include.map(Collection::stream).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.listElements().map(Holder::value)).forEach(var3 -> {
                    if (var4.contains(var3)) {
                        return;
                    }
                    TypedDataComponent var4 = var2.getTyped(var3);
                    if (var4 != null) {
                        var0.set(var4);
                    }
                });
            }
        }
        return var0;
    }

    public static Builder copyComponentsFromEntity(ContextKey<? extends Entity> var0) {
        return new Builder(new EntitySource(var0));
    }

    public static Builder copyComponentsFromBlockEntity(ContextKey<? extends BlockEntity> var0) {
        return new Builder(new BlockEntitySource(var0));
    }

    static {
        for (LootContext.EntityTarget entityTarget : LootContext.EntityTarget.values()) {
            SOURCES.put(entityTarget.getSerializedName(), new EntitySource(entityTarget.getParam()));
        }
        for (Enum enum_ : LootContext.BlockEntityTarget.values()) {
            SOURCES.put(((LootContext.BlockEntityTarget)enum_).getSerializedName(), new BlockEntitySource(((LootContext.BlockEntityTarget)enum_).getParam()));
        }
        for (Enum enum_ : LootContext.ItemStackTarget.values()) {
            SOURCES.put(((LootContext.ItemStackTarget)enum_).getSerializedName(), new ItemStackSource(((LootContext.ItemStackTarget)enum_).getParam()));
        }
        CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyComponentsFunction.commonFields(var02).and(var02.group((App)SOURCES.codec((Codec<String>)Codec.STRING).fieldOf("source").forGetter(var0 -> var0.source), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter(var0 -> var0.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter(var0 -> var0.exclude))).apply((Applicative)var02, CopyComponentsFunction::new));
    }

    public static interface Source<T> {
        public ContextKey<? extends T> contextParam();

        public DataComponentGetter get(T var1);

        @Nullable
        default public DataComponentGetter get(LootContext var0) {
            T var1 = var0.getOptionalParameter(this.contextParam());
            return var1 != null ? this.get(var1) : null;
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Source<?> source;
        private Optional<ImmutableList.Builder<DataComponentType<?>>> include = Optional.empty();
        private Optional<ImmutableList.Builder<DataComponentType<?>>> exclude = Optional.empty();

        Builder(Source<?> var0) {
            this.source = var0;
        }

        public Builder include(DataComponentType<?> var0) {
            if (this.include.isEmpty()) {
                this.include = Optional.of(ImmutableList.builder());
            }
            this.include.get().add(var0);
            return this;
        }

        public Builder exclude(DataComponentType<?> var0) {
            if (this.exclude.isEmpty()) {
                this.exclude = Optional.of(ImmutableList.builder());
            }
            this.exclude.get().add(var0);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyComponentsFunction(this.getConditions(), this.source, this.include.map(ImmutableList.Builder::build), this.exclude.map(ImmutableList.Builder::build));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }

    record EntitySource(ContextKey<? extends Entity> contextParam) implements Source<Entity>
    {
        @Override
        public DataComponentGetter get(Entity var0) {
            return var0;
        }
    }

    record BlockEntitySource(ContextKey<? extends BlockEntity> contextParam) implements Source<BlockEntity>
    {
        @Override
        public DataComponentGetter get(BlockEntity var0) {
            return var0.collectComponents();
        }
    }

    record ItemStackSource(ContextKey<? extends ItemStack> contextParam) implements Source<ItemStack>
    {
        @Override
        public DataComponentGetter get(ItemStack var0) {
            return var0.getComponents();
        }
    }
}

