/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.SubShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SliceShape
extends VoxelShape {
    private final VoxelShape delegate;
    private final Direction.Axis axis;
    private static final DoubleList SLICE_COORDS = new CubePointRange(1);

    public SliceShape(VoxelShape var0, Direction.Axis var1, int var2) {
        super(SliceShape.makeSlice(var0.shape, var1, var2));
        this.delegate = var0;
        this.axis = var1;
    }

    private static DiscreteVoxelShape makeSlice(DiscreteVoxelShape var0, Direction.Axis var1, int var2) {
        return new SubShape(var0, var1.choose(var2, 0, 0), var1.choose(0, var2, 0), var1.choose(0, 0, var2), var1.choose(var2 + 1, var0.xSize, var0.xSize), var1.choose(var0.ySize, var2 + 1, var0.ySize), var1.choose(var0.zSize, var0.zSize, var2 + 1));
    }

    @Override
    public DoubleList getCoords(Direction.Axis var0) {
        if (var0 == this.axis) {
            return SLICE_COORDS;
        }
        return this.delegate.getCoords(var0);
    }
}

