/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R6.CraftArt;
import org.bukkit.craftbukkit.v1_21_R6.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R6.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R6.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R6.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static RegistryAccess registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final net.minecraft.core.Registry<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, Holder<M>, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(RegistryAccess registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static RegistryAccess getMinecraftRegistry() {
        return registry;
    }

    public static <E> net.minecraft.core.Registry<E> getMinecraftRegistry(ResourceKey<net.minecraft.core.Registry<E>> key) {
        return CraftRegistry.getMinecraftRegistry().lookupOrThrow(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, ResourceKey<net.minecraft.core.Registry<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).location()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> Holder<M> bukkitToMinecraftHolder(B bukkit, ResourceKey<net.minecraft.core.Registry<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Holder holder = registry.wrapAsHolder(CraftRegistry.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    private static <M, B> BiFunction<NamespacedKey, Holder<M>, B> wrap(BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return (namespacedKey, holder) -> minecraftToBukkit.apply((NamespacedKey)namespacedKey, (Object)holder.value());
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, RegistryAccess registryHolder) {
        if (bukkitClass == Art.class) {
            return new CraftRegistry((Class<CraftArt>)Art.class, registryHolder.lookupOrThrow(Registries.PAINTING_VARIANT), CraftArt::new, FieldRename.NONE);
        }
        if (bukkitClass == Attribute.class) {
            return new CraftRegistry((Class<CraftAttribute>)Attribute.class, registryHolder.lookupOrThrow(Registries.ATTRIBUTE), CraftAttribute::new, FieldRename.ATTRIBUTE_RENAME);
        }
        if (bukkitClass == Biome.class) {
            return new CraftRegistry((Class<CraftBiome>)Biome.class, registryHolder.lookupOrThrow(Registries.BIOME), CraftBiome::new, FieldRename.BIOME_RENAME);
        }
        if (bukkitClass == org.bukkit.enchantments.Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, Enchantment>((Class<CraftEnchantment>)org.bukkit.enchantments.Enchantment.class, (net.minecraft.core.Registry<Enchantment>)registryHolder.lookupOrThrow(Registries.ENCHANTMENT), CraftRegistry.wrap(CraftEnchantment::new), FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == Fluid.class) {
            return new CraftRegistry((Class<CraftFluid>)Fluid.class, registryHolder.lookupOrThrow(Registries.FLUID), CraftFluid::new, FieldRename.NONE);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, net.minecraft.world.level.gameevent.GameEvent>((Class<CraftGameEvent>)GameEvent.class, (net.minecraft.core.Registry<net.minecraft.world.level.gameevent.GameEvent>)registryHolder.lookupOrThrow(Registries.GAME_EVENT), CraftRegistry.wrap(CraftGameEvent::new), FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry((Class<CraftMusicInstrument>)MusicInstrument.class, registryHolder.lookupOrThrow(Registries.INSTRUMENT), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry((Class<CraftMenuType>)MenuType.class, registryHolder.lookupOrThrow(Registries.MENU), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, MobEffect>((Class<CraftPotionEffectType>)PotionEffectType.class, (net.minecraft.core.Registry<MobEffect>)registryHolder.lookupOrThrow(Registries.MOB_EFFECT), CraftRegistry.wrap(CraftPotionEffectType::new), FieldRename.NONE);
        }
        if (bukkitClass == Sound.class) {
            return new CraftRegistry((Class<CraftSound>)Sound.class, registryHolder.lookupOrThrow(Registries.SOUND_EVENT), CraftSound::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, net.minecraft.world.level.levelgen.structure.Structure>((Class<CraftStructure>)Structure.class, (net.minecraft.core.Registry<net.minecraft.world.level.levelgen.structure.Structure>)registryHolder.lookupOrThrow(Registries.STRUCTURE), CraftRegistry.wrap(CraftStructure::new), FieldRename.NONE);
        }
        if (bukkitClass == org.bukkit.generator.structure.StructureType.class) {
            return new CraftRegistry<CraftStructureType, StructureType>((Class<CraftStructureType>)org.bukkit.generator.structure.StructureType.class, (net.minecraft.core.Registry<StructureType>)registryHolder.lookupOrThrow(Registries.STRUCTURE_TYPE), CraftRegistry.wrap(CraftStructureType::new), FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry((Class<CraftVillager.CraftType>)Villager.Type.class, registryHolder.lookupOrThrow(Registries.VILLAGER_TYPE), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry((Class<CraftVillager.CraftProfession>)Villager.Profession.class, registryHolder.lookupOrThrow(Registries.VILLAGER_PROFESSION), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry((Class<CraftTrimMaterial>)TrimMaterial.class, registryHolder.lookupOrThrow(Registries.TRIM_MATERIAL), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry((Class<CraftTrimPattern>)TrimPattern.class, registryHolder.lookupOrThrow(Registries.TRIM_PATTERN), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry((Class<CraftDamageType>)DamageType.class, registryHolder.lookupOrThrow(Registries.DAMAGE_TYPE), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry((Class<CraftJukeboxSong>)JukeboxSong.class, registryHolder.lookupOrThrow(Registries.JUKEBOX_SONG), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry((Class<CraftWolf.CraftVariant>)Wolf.Variant.class, registryHolder.lookupOrThrow(Registries.WOLF_VARIANT), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry((Class<CraftBlockType>)BlockType.class, registryHolder.lookupOrThrow(Registries.BLOCK), CraftBlockType::new, FieldRename.BLOCK_TYPE_RENAME);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry((Class<CraftItemType>)ItemType.class, registryHolder.lookupOrThrow(Registries.ITEM), CraftItemType::new, FieldRename.ITEM_TYPE_RENAME);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry((Class<CraftFrog.CraftVariant>)Frog.Variant.class, registryHolder.lookupOrThrow(Registries.FROG_VARIANT), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry((Class<CraftCat.CraftType>)Cat.Type.class, registryHolder.lookupOrThrow(Registries.CAT_VARIANT), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Pig.Variant.class) {
            return new CraftRegistry((Class<CraftPig.CraftVariant>)Pig.Variant.class, registryHolder.lookupOrThrow(Registries.PIG_VARIANT), CraftPig.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cow.Variant.class) {
            return new CraftRegistry((Class<CraftCow.CraftVariant>)Cow.Variant.class, registryHolder.lookupOrThrow(Registries.COW_VARIANT), CraftCow.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Chicken.Variant.class) {
            return new CraftRegistry((Class<CraftChicken.CraftVariant>)Chicken.Variant.class, registryHolder.lookupOrThrow(Registries.CHICKEN_VARIANT), CraftChicken.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry((Class<CraftMapCursor.CraftType>)MapCursor.Type.class, registryHolder.lookupOrThrow(Registries.MAP_DECORATION_TYPE), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry((Class<CraftPatternType>)PatternType.class, registryHolder.lookupOrThrow(Registries.BANNER_PATTERN), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, net.minecraft.core.Registry<M> minecraftRegistry, BiFunction<NamespacedKey, Holder<M>, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.get(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.key(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.keySet().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, Holder<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

