/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.EntitySnapshot;

public class CraftEntityFactory
implements EntityFactory {
    private final RegistryAccess registry;

    public CraftEntityFactory(RegistryAccess registry) {
        this.registry = registry;
    }

    public EntitySnapshot createEntitySnapshot(String input) {
        CompoundTag tag;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input string cannot be null");
        try {
            tag = TagParser.parseCompoundFully(input);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Could not parse Entity: " + input, e);
        }
        ValueInput value = TagValueInput.create(ProblemReporter.DISCARDING, (HolderLookup.Provider)this.registry, tag);
        EntityType type = EntityType.by(value).orElse(null);
        if (type == null) {
            throw new IllegalArgumentException("Could not parse Entity: " + input);
        }
        return CraftEntitySnapshot.create(tag, CraftEntityType.minecraftToBukkit(type));
    }
}

