/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.util;

import java.util.function.Supplier;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftAccessLocationInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftBlockEntityInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftDoubleChestInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftMerchantInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftStandardInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.BeaconView;
import org.bukkit.inventory.view.BrewingStandView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.FurnaceView;
import org.bukkit.inventory.view.LecternView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.StonecutterView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;

public final class CraftMenus {
    public static void openMerchantMenu(ServerPlayer player, MerchantMenu merchant) {
        Merchant minecraftMerchant = ((CraftMerchant)merchant.getBukkitView().getMerchant()).getMerchant();
        int level = 1;
        if (minecraftMerchant instanceof Villager) {
            Villager villager = (Villager)minecraftMerchant;
            level = villager.getVillagerData().level();
        }
        if (minecraftMerchant.getTradingPlayer() != null) {
            minecraftMerchant.getTradingPlayer().closeContainer();
        }
        minecraftMerchant.setTradingPlayer(player);
        player.connection.send(new ClientboundOpenScreenPacket(merchant.containerId, net.minecraft.world.inventory.MenuType.MERCHANT, merchant.getTitle()));
        player.containerMenu = merchant;
        player.initMenu(merchant);
        MerchantOffers merchantrecipelist = minecraftMerchant.getOffers();
        if (!merchantrecipelist.isEmpty()) {
            player.sendMerchantOffers(merchant.containerId, merchantrecipelist, level, minecraftMerchant.getVillagerXp(), minecraftMerchant.showProgressBar(), minecraftMerchant.canRestock());
        }
    }

    public static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> getMenuTypeData(CraftMenuType<?, ?> menuType) {
        net.minecraft.world.inventory.MenuType handle = (net.minecraft.world.inventory.MenuType)menuType.getHandle();
        if (menuType == MenuType.GENERIC_9X6) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftDoubleChestInventoryViewBuilder>(InventoryView.class, () -> new CraftDoubleChestInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.GENERIC_9X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.CHEST, null)));
        }
        if (menuType == MenuType.GENERIC_3X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.DISPENSER, DispenserBlockEntity::new)));
        }
        if (menuType == MenuType.CRAFTER_3X3) {
            return CraftMenus.asType(new MenuTypeData<CrafterView, CraftBlockEntityInventoryViewBuilder>(CrafterView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.CRAFTER, CrafterBlockEntity::new)));
        }
        if (menuType == MenuType.ANVIL) {
            return CraftMenus.asType(new MenuTypeData<AnvilView, CraftAccessLocationInventoryViewBuilder>(AnvilView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, AnvilMenu::new)));
        }
        if (menuType == MenuType.BEACON) {
            return CraftMenus.asType(new MenuTypeData<BeaconView, CraftBlockEntityInventoryViewBuilder>(BeaconView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BEACON, BeaconBlockEntity::new)));
        }
        if (menuType == MenuType.BLAST_FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BLAST_FURNACE, BlastFurnaceBlockEntity::new)));
        }
        if (menuType == MenuType.BREWING_STAND) {
            return CraftMenus.asType(new MenuTypeData<BrewingStandView, CraftBlockEntityInventoryViewBuilder>(BrewingStandView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.BREWING_STAND, BrewingStandBlockEntity::new)));
        }
        if (menuType == MenuType.CRAFTING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, CraftingMenu::new)));
        }
        if (menuType == MenuType.ENCHANTMENT) {
            return CraftMenus.asType(new MenuTypeData<EnchantmentView, CraftAccessLocationInventoryViewBuilder>(EnchantmentView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, EnchantmentMenu::new)));
        }
        if (menuType == MenuType.FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.FURNACE, FurnaceBlockEntity::new)));
        }
        if (menuType == MenuType.GRINDSTONE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, GrindstoneMenu::new)));
        }
        if (menuType == MenuType.HOPPER) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.HOPPER, HopperBlockEntity::new)));
        }
        if (menuType == MenuType.LECTERN) {
            return CraftMenus.asType(new MenuTypeData<LecternView, CraftBlockEntityInventoryViewBuilder>(LecternView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.LECTERN, LecternBlockEntity::new)));
        }
        if (menuType == MenuType.LOOM) {
            return CraftMenus.asType(new MenuTypeData<LoomView, CraftStandardInventoryViewBuilder>(LoomView.class, () -> new CraftStandardInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.MERCHANT) {
            return CraftMenus.asType(new MenuTypeData<MerchantView, CraftMerchantInventoryViewBuilder>(MerchantView.class, () -> new CraftMerchantInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.SHULKER_BOX) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.SHULKER_BOX, null)));
        }
        if (menuType == MenuType.SMITHING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, SmithingMenu::new)));
        }
        if (menuType == MenuType.SMOKER) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.SMOKER, SmokerBlockEntity::new)));
        }
        if (menuType == MenuType.CARTOGRAPHY_TABLE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, CartographyTableMenu::new)));
        }
        if (menuType == MenuType.STONECUTTER) {
            return CraftMenus.asType(new MenuTypeData<StonecutterView, CraftAccessLocationInventoryViewBuilder>(StonecutterView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, StonecutterMenu::new)));
        }
        return CraftMenus.asType(new MenuTypeData<InventoryView, CraftStandardInventoryViewBuilder>(InventoryView.class, () -> new CraftStandardInventoryViewBuilder(handle)));
    }

    private static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> asType(MenuTypeData<?, ?> data) {
        return data;
    }

    public record MenuTypeData<V extends InventoryView, B extends InventoryViewBuilder<V>>(Class<V> viewClass, Supplier<B> viewBuilder) {
    }
}

