/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final fjd handle;
    private final NamespacedKey key;

    public static LootTable minecraftToBukkit(amj minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(minecraft));
    }

    public static LootTable minecraftToBukkit(ami<fjd> minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftLootTable.minecraftToBukkitKey(minecraft));
    }

    public static NamespacedKey minecraftToBukkitKey(ami<fjd> minecraft) {
        return minecraft == null ? null : CraftNamespacedKey.fromMinecraft(minecraft.a());
    }

    public static ami<fjd> bukkitToMinecraft(LootTable table) {
        return table == null ? null : CraftLootTable.bukkitKeyToMinecraft(table.getKey());
    }

    public static ami<fjd> bukkitKeyToMinecraft(NamespacedKey key) {
        return key == null ? null : ami.a(mp.bz, CraftNamespacedKey.toMinecraft(key));
    }

    public CraftLootTable(NamespacedKey key, fjd handle) {
        this.handle = handle;
        this.key = key;
    }

    public fjd getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fjb nmsContext = this.convertContext(context, random);
        ObjectArrayList<dhp> nmsItems = this.handle.a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (dhp item : nmsItems) {
            if (item.f()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fjb nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        cbj handle = craftInventory.getInventory();
        this.getHandle().fillInventory(handle, nmsContext, random.nextLong(), true);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private fjb convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        awx handle = ((CraftWorld)loc.getWorld()).getHandle();
        fjb.a builder = new fjb.a(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, fls.h, CraftLocation.toVec3D(loc));
        if (this.getHandle() != fjd.f) {
            if (context.getLootedEntity() != null) {
                cdv nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, fls.a, nmsLootedEntity);
                this.setMaybe(builder, fls.e, handle.an().p());
                this.setMaybe(builder, fls.h, nmsLootedEntity.dD());
            }
            if (context.getKiller() != null) {
                czl nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, fls.f, nmsKiller);
                this.setMaybe(builder, fls.e, handle.an().a(nmsKiller));
                this.setMaybe(builder, fls.d, nmsKiller);
                this.setMaybe(builder, fls.k, nmsKiller.fQ());
            }
        }
        bgu.a nmsBuilder = new bgu.a();
        for (bgt<?> param : this.getHandle().a().a()) {
            nmsBuilder.a(param);
        }
        for (bgt<?> param : this.getHandle().a().b()) {
            if (this.getHandle().a().a().contains(param)) continue;
            nmsBuilder.b(param);
        }
        return builder.a(this.getHandle().a());
    }

    private <T> void setMaybe(fjb.a builder, bgt<T> param, T value) {
        if (this.getHandle().a().a().contains(param) || this.getHandle().a().b().contains(param)) {
            builder.a(param, value);
        }
    }

    public static LootContext convertContext(fiy info) {
        CraftEntity killer;
        foh position = info.c(fls.h);
        if (position == null) {
            position = info.c(fls.a).dD();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.d().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.a(fls.f) && (killer = info.c(fls.f).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.a(fls.a)) {
            contextBuilder.lootedEntity((Entity)info.c(fls.a).getBukkitEntity());
        }
        contextBuilder.luck(info.c());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }
}

