/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;

public class CraftServerLinks
implements ServerLinks {
    private final aro server;
    private anb serverLinks;

    public CraftServerLinks(aro server) {
        this(server, null);
    }

    public CraftServerLinks(anb serverLinks) {
        this(null, serverLinks);
    }

    private CraftServerLinks(aro server, anb serverLinks) {
        this.server = server;
        this.serverLinks = serverLinks;
    }

    public ServerLinks.ServerLink getLink(ServerLinks.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        return this.getServerLinks().a(CraftServerLinks.fromBukkit(type)).map(CraftServerLink::new).orElse(null);
    }

    public List<ServerLinks.ServerLink> getLinks() {
        return this.getServerLinks().c().stream().map(nms -> new CraftServerLink((anb.a)nms)).toList();
    }

    public ServerLinks.ServerLink setLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        ServerLinks.ServerLink existing = this.getLink(type);
        if (existing != null) {
            this.removeLink(existing);
        }
        return this.addLink(type, url);
    }

    public ServerLinks.ServerLink addLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(anb.a.a(CraftServerLinks.fromBukkit(type), url));
        this.addLink(link);
        return link;
    }

    public ServerLinks.ServerLink addLink(String displayName, URI url) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"displayName cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(anb.a.a(CraftChatMessage.fromStringOrNull(displayName), url));
        this.addLink(link);
        return link;
    }

    private void addLink(CraftServerLink link) {
        ArrayList<anb.a> lst = new ArrayList<anb.a>(this.getServerLinks().c());
        lst.add(link.handle);
        this.setLinks(new anb(lst));
    }

    public boolean removeLink(ServerLinks.ServerLink link) {
        Preconditions.checkArgument((link != null ? 1 : 0) != 0, (Object)"link cannot be null");
        ArrayList<anb.a> lst = new ArrayList<anb.a>(this.getServerLinks().c());
        boolean result = lst.remove(((CraftServerLink)link).handle);
        this.setLinks(new anb(lst));
        return result;
    }

    public ServerLinks copy() {
        return new CraftServerLinks(this.getServerLinks());
    }

    public anb getServerLinks() {
        return this.server != null ? this.server.bx() : this.serverLinks;
    }

    private void setLinks(anb links) {
        if (this.server != null) {
            this.server.y = links;
        } else {
            this.serverLinks = links;
        }
    }

    private static anb.b fromBukkit(ServerLinks.Type type) {
        return anb.b.values()[type.ordinal()];
    }

    private static ServerLinks.Type fromNMS(anb.b nms) {
        return ServerLinks.Type.values()[nms.ordinal()];
    }

    public static class CraftServerLink
    implements ServerLinks.ServerLink {
        private final anb.a handle;

        public CraftServerLink(anb.a handle) {
            this.handle = handle;
        }

        public ServerLinks.Type getType() {
            return this.handle.b().left().map(CraftServerLinks::fromNMS).orElse(null);
        }

        public String getDisplayName() {
            return CraftChatMessage.fromComponent(this.handle.a());
        }

        public URI getUrl() {
            return this.handle.c();
        }
    }
}

