/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBed;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBell;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftComparator;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndPortal;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftMovingPiston;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSuspiciousSand;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTestBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTestInstance;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftVault;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, ja blockPosition, ejm blockData, egg tileEntity) {
            if (tileEntity != null) {
                return new CraftBlockEntityState<egg>(world, tileEntity);
            }
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftBlockType.minecraftToBukkit(blockData.b()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends egg, B extends CraftBlockEntityState<T>> void register(Material blockType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<ja, ejm, T> tileEntityConstructor) {
        CraftBlockStates.register(Collections.singletonList(blockType), blockStateType, blockStateConstructor, tileEntityConstructor);
    }

    private static <T extends egg, B extends CraftBlockEntityState<T>> void register(List<Material> blockTypes, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<ja, ejm, T> tileEntityConstructor) {
        BlockEntityStateFactory<T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, tileEntityConstructor);
        for (Material blockType : blockTypes) {
            CraftBlockStates.register(blockType, factory);
        }
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static egg createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(ja.c, CraftBlockType.bukkitToMinecraft(material).m());
        }
        return null;
    }

    public static BlockState getBlockState(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        ja blockPosition = craftBlock.getPosition();
        ejm blockData = craftBlock.getNMS();
        egg tileEntity = craftBlock.getHandle().c_(blockPosition);
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
        blockState.setWorldHandle(craftBlock.getHandle());
        return blockState;
    }

    @Deprecated
    public static BlockState getBlockState(ja blockPosition, Material material, @Nullable up blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(drt world, ja blockPosition, Material material, @Nullable up blockEntityTag) {
        return CraftBlockStates.getBlockState(world.L_(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(jy registry, ja blockPosition, Material material, @Nullable up blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        ejm blockData = CraftBlockType.bukkitToMinecraft(material).m();
        return CraftBlockStates.getBlockState(registry, blockPosition, blockData, blockEntityTag);
    }

    @Deprecated
    public static BlockState getBlockState(ejm blockData, @Nullable up blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), ja.c, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(drt world, ja blockPosition, ejm blockData, @Nullable up blockEntityTag) {
        return CraftBlockStates.getBlockState(world.L_(), blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(jy registry, ja blockPosition, ejm blockData, @Nullable up blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        egg tileEntity = blockEntityTag == null ? null : egg.a(blockPosition, blockData, blockEntityTag, registry);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    private static CraftBlockState getBlockState(World world, ja blockPosition, ejm blockData, egg tileEntity) {
        Material material = CraftBlockType.minecraftToBukkit(blockData.b());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material);
        return factory.createBlockState(world, blockPosition, blockData, tileEntity);
    }

    public static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(drr world, ja pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    public static CraftBlockState getBlockState(drr world, ja pos, int flag) {
        return new CraftBlockState(CraftBlock.at(world, pos), flag);
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BAMBOO_SIGN, Material.BAMBOO_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CHERRY_SIGN, Material.CHERRY_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.MANGROVE_SIGN, Material.MANGROVE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.PALE_OAK_SIGN, Material.PALE_OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN), CraftSign.class, CraftSign::new, ehx::new);
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_HANGING_SIGN, Material.ACACIA_WALL_HANGING_SIGN, Material.BAMBOO_HANGING_SIGN, Material.BAMBOO_WALL_HANGING_SIGN, Material.BIRCH_HANGING_SIGN, Material.BIRCH_WALL_HANGING_SIGN, Material.CHERRY_HANGING_SIGN, Material.CHERRY_WALL_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN, Material.CRIMSON_WALL_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.DARK_OAK_WALL_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN, Material.JUNGLE_WALL_HANGING_SIGN, Material.MANGROVE_HANGING_SIGN, Material.MANGROVE_WALL_HANGING_SIGN, Material.OAK_HANGING_SIGN, Material.OAK_WALL_HANGING_SIGN, Material.PALE_OAK_HANGING_SIGN, Material.PALE_OAK_WALL_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN, Material.SPRUCE_WALL_HANGING_SIGN, Material.WARPED_HANGING_SIGN, Material.WARPED_WALL_HANGING_SIGN), CraftHangingSign.class, CraftHangingSign::new, ehi::new);
        CraftBlockStates.register(Arrays.asList(Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD), CraftSkull.class, CraftSkull::new, ehz::new);
        CraftBlockStates.register(Arrays.asList(Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK), CraftCommandBlock.class, CraftCommandBlock::new, egr::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BANNER, Material.BLACK_WALL_BANNER, Material.BLUE_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_BANNER, Material.BROWN_WALL_BANNER, Material.CYAN_BANNER, Material.CYAN_WALL_BANNER, Material.GRAY_BANNER, Material.GRAY_WALL_BANNER, Material.GREEN_BANNER, Material.GREEN_WALL_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.LIME_BANNER, Material.LIME_WALL_BANNER, Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER, Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER, Material.PINK_BANNER, Material.PINK_WALL_BANNER, Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER, Material.RED_BANNER, Material.RED_WALL_BANNER, Material.WHITE_BANNER, Material.WHITE_WALL_BANNER, Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER), CraftBanner.class, CraftBanner::new, efu::new);
        CraftBlockStates.register(Arrays.asList(Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX), CraftShulkerBox.class, CraftShulkerBox::new, ehw::new);
        CraftBlockStates.register(Arrays.asList(Material.BLACK_BED, Material.BLUE_BED, Material.BROWN_BED, Material.CYAN_BED, Material.GRAY_BED, Material.GREEN_BED, Material.LIGHT_BLUE_BED, Material.LIGHT_GRAY_BED, Material.LIME_BED, Material.MAGENTA_BED, Material.ORANGE_BED, Material.PINK_BED, Material.PURPLE_BED, Material.RED_BED, Material.WHITE_BED, Material.YELLOW_BED), CraftBed.class, CraftBed::new, egc::new);
        CraftBlockStates.register(Arrays.asList(Material.BEEHIVE, Material.BEE_NEST), CraftBeehive.class, CraftBeehive::new, egd::new);
        CraftBlockStates.register(Arrays.asList(Material.CAMPFIRE, Material.SOUL_CAMPFIRE), CraftCampfire.class, CraftCampfire::new, egn::new);
        CraftBlockStates.register(Arrays.asList(Material.ACACIA_SHELF, Material.BAMBOO_SHELF, Material.BIRCH_SHELF, Material.CHERRY_SHELF, Material.CRIMSON_SHELF, Material.DARK_OAK_SHELF, Material.JUNGLE_SHELF, Material.MANGROVE_SHELF, Material.OAK_SHELF, Material.PALE_OAK_SHELF, Material.SPRUCE_SHELF, Material.WARPED_SHELF), CraftShelf.class, CraftShelf::new, ehv::new);
        CraftBlockStates.register(Arrays.asList(Material.COPPER_GOLEM_STATUE, Material.EXPOSED_COPPER_GOLEM_STATUE, Material.WEATHERED_COPPER_GOLEM_STATUE, Material.OXIDIZED_COPPER_GOLEM_STATUE, Material.WAXED_COPPER_GOLEM_STATUE, Material.WAXED_EXPOSED_COPPER_GOLEM_STATUE, Material.WAXED_WEATHERED_COPPER_GOLEM_STATUE, Material.WAXED_OXIDIZED_COPPER_GOLEM_STATUE), CraftCopperGolemStatue.class, CraftCopperGolemStatue::new, egv::new);
        CraftBlockStates.register(Material.BARREL, CraftBarrel.class, CraftBarrel::new, efy::new);
        CraftBlockStates.register(Material.BEACON, CraftBeacon.class, CraftBeacon::new, egb::new);
        CraftBlockStates.register(Material.BELL, CraftBell.class, CraftBell::new, ege::new);
        CraftBlockStates.register(Material.BLAST_FURNACE, CraftBlastFurnace.class, CraftBlastFurnace::new, egf::new);
        CraftBlockStates.register(Material.BREWING_STAND, CraftBrewingStand.class, CraftBrewingStand::new, egk::new);
        CraftBlockStates.register(Arrays.asList(Material.CHEST, Material.COPPER_CHEST, Material.EXPOSED_COPPER_CHEST, Material.WEATHERED_COPPER_CHEST, Material.OXIDIZED_COPPER_CHEST, Material.WAXED_COPPER_CHEST, Material.WAXED_EXPOSED_COPPER_CHEST, Material.WAXED_WEATHERED_COPPER_CHEST, Material.WAXED_OXIDIZED_COPPER_CHEST), CraftChest.class, CraftChest::new, ego::new);
        CraftBlockStates.register(Material.CHISELED_BOOKSHELF, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new, egq::new);
        CraftBlockStates.register(Material.COMPARATOR, CraftComparator.class, CraftComparator::new, egs::new);
        CraftBlockStates.register(Material.CONDUIT, CraftConduit.class, CraftConduit::new, egt::new);
        CraftBlockStates.register(Material.CREAKING_HEART, CraftCreakingHeart.class, CraftCreakingHeart::new, egx::new);
        CraftBlockStates.register(Material.DAYLIGHT_DETECTOR, CraftDaylightDetector.class, CraftDaylightDetector::new, egy::new);
        CraftBlockStates.register(Material.DECORATED_POT, CraftDecoratedPot.class, CraftDecoratedPot::new, egz::new);
        CraftBlockStates.register(Material.DISPENSER, CraftDispenser.class, CraftDispenser::new, ehc::new);
        CraftBlockStates.register(Material.DROPPER, CraftDropper.class, CraftDropper::new, ehd::new);
        CraftBlockStates.register(Material.ENCHANTING_TABLE, CraftEnchantingTable.class, CraftEnchantingTable::new, ehe::new);
        CraftBlockStates.register(Material.ENDER_CHEST, CraftEnderChest.class, CraftEnderChest::new, ehf::new);
        CraftBlockStates.register(Material.END_GATEWAY, CraftEndGateway.class, CraftEndGateway::new, eif::new);
        CraftBlockStates.register(Material.END_PORTAL, CraftEndPortal.class, CraftEndPortal::new, eig::new);
        CraftBlockStates.register(Material.FURNACE, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new, ehh::new);
        CraftBlockStates.register(Material.HOPPER, CraftHopper.class, CraftHopper::new, ehk::new);
        CraftBlockStates.register(Material.JIGSAW, CraftJigsaw.class, CraftJigsaw::new, ehl::new);
        CraftBlockStates.register(Material.JUKEBOX, CraftJukebox.class, CraftJukebox::new, ehm::new);
        CraftBlockStates.register(Material.LECTERN, CraftLectern.class, CraftLectern::new, ehn::new);
        CraftBlockStates.register(Material.MOVING_PISTON, CraftMovingPiston.class, CraftMovingPiston::new, ejg::new);
        CraftBlockStates.register(Material.SCULK_CATALYST, CraftSculkCatalyst.class, CraftSculkCatalyst::new, ehs::new);
        CraftBlockStates.register(Material.CALIBRATED_SCULK_SENSOR, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new, egm::new);
        CraftBlockStates.register(Material.SCULK_SENSOR, CraftSculkSensor.class, CraftSculkSensor::new, eht::new);
        CraftBlockStates.register(Material.SCULK_SHRIEKER, CraftSculkShrieker.class, CraftSculkShrieker::new, ehu::new);
        CraftBlockStates.register(Material.SMOKER, CraftSmoker.class, CraftSmoker::new, eia::new);
        CraftBlockStates.register(Material.SPAWNER, CraftCreatureSpawner.class, CraftCreatureSpawner::new, eib::new);
        CraftBlockStates.register(Material.STRUCTURE_BLOCK, CraftStructureBlock.class, CraftStructureBlock::new, eic::new);
        CraftBlockStates.register(Material.SUSPICIOUS_SAND, CraftSuspiciousSand.class, CraftSuspiciousSand::new, egl::new);
        CraftBlockStates.register(Material.SUSPICIOUS_GRAVEL, CraftBrushableBlock.class, CraftBrushableBlock::new, egl::new);
        CraftBlockStates.register(Material.TRAPPED_CHEST, CraftChest.class, CraftChest::new, eii::new);
        CraftBlockStates.register(Material.CRAFTER, CraftCrafter.class, CraftCrafter::new, egw::new);
        CraftBlockStates.register(Material.TRIAL_SPAWNER, CraftTrialSpawner.class, CraftTrialSpawner::new, eij::new);
        CraftBlockStates.register(Material.VAULT, CraftVault.class, CraftVault::new, eis::new);
        CraftBlockStates.register(Material.TEST_BLOCK, CraftTestBlock.class, CraftTestBlock::new, eid::new);
        CraftBlockStates.register(Material.TEST_INSTANCE_BLOCK, CraftTestInstance.class, CraftTestInstance::new, eie::new);
    }

    private static class BlockEntityStateFactory<T extends egg, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final BiFunction<ja, ejm, T> tileEntityConstructor;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BiFunction<ja, ejm, T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
        }

        @Override
        public final B createBlockState(World world, ja blockPosition, ejm blockData, egg tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(ja blockPosition, ejm blockData) {
            return (T)((egg)this.tileEntityConstructor.apply(blockPosition, blockData));
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, ja var2, ejm var3, egg var4);
    }
}

