/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends eft>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((eft)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((eft)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((eft)this.getSnapshot()).y;
    }

    public void setBurnTime(short burnTime) {
        ((eft)this.getSnapshot()).y = burnTime;
        this.data = (ejm)this.data.b(dtq.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((eft)this.getSnapshot()).A;
    }

    public void setCookTime(short cookTime) {
        ((eft)this.getSnapshot()).A = cookTime;
    }

    public int getCookTimeTotal() {
        return ((eft)this.getSnapshot()).B;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((eft)this.getSnapshot()).B = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        ((eft)this.getSnapshot()).C.reference2IntEntrySet().fastForEach(entrySet -> {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft(((ami)entrySet.getKey()).a()));
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                recipesUsed.put((Object)cookingRecipe, (Object)entrySet.getValue());
            }
        });
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);
}

