/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.damage;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;

public class CraftDamageSource
implements DamageSource {
    private final cci damageSource;
    private final DamageType damageType;

    public CraftDamageSource(cci damageSource) {
        this.damageSource = damageSource;
        this.damageType = CraftDamageType.minecraftHolderToBukkit(damageSource.l());
    }

    public cci getHandle() {
        return this.damageSource;
    }

    public World getCausingEntityWorld() {
        Entity causingEntity = this.getCausingEntity();
        return causingEntity != null ? causingEntity.getWorld() : null;
    }

    public Block getDirectBlock() {
        return this.getHandle().getDirectBlock();
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public Entity getCausingEntity() {
        cdv entity = this.getHandle().getCausingDamager();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    public Entity getDirectEntity() {
        cdv entity = this.getHandle().getDamager();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    public Location getDamageLocation() {
        foh vec3D = this.getHandle().j();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    public Location getSourceLocation() {
        foh vec3D = this.getHandle().i();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    public boolean isIndirect() {
        return this.getHandle().getCausingDamager() != this.getHandle().getDamager();
    }

    public float getFoodExhaustion() {
        return this.damageType.getExhaustion();
    }

    public boolean scalesWithDifficulty() {
        return this.getHandle().g();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DamageSource)) {
            return false;
        }
        DamageSource other = (DamageSource)obj;
        return Objects.equals(this.getDamageType(), other.getDamageType()) && Objects.equals(this.getCausingEntity(), other.getCausingEntity()) && Objects.equals(this.getDirectEntity(), other.getDirectEntity()) && Objects.equals(this.getDamageLocation(), other.getDamageLocation());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.damageType.hashCode();
        result = 31 * result + (this.getCausingEntity() != null ? this.getCausingEntity().hashCode() : 0);
        result = 31 * result + (this.getDirectEntity() != null ? this.getDirectEntity().hashCode() : 0);
        result = 31 * result + (this.getDamageLocation() != null ? this.getDamageLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DamageSource{damageType=" + String.valueOf(this.getDamageType()) + ",causingEntity=" + String.valueOf(this.getCausingEntity()) + ",directEntity=" + String.valueOf(this.getDirectEntity()) + ",damageLocation=" + String.valueOf(this.getDamageLocation()) + "}";
    }

    public static DamageSource buildFromBukkit(DamageType damageType, Entity causingEntity, Entity directEntity, Location damageLocation) {
        jk<cck> holderDamageType = CraftDamageType.bukkitToMinecraftHolder(damageType);
        cdv nmsCausingEntity = null;
        if (causingEntity instanceof CraftEntity) {
            CraftEntity craftCausingEntity = (CraftEntity)causingEntity;
            nmsCausingEntity = craftCausingEntity.getHandle();
        }
        cdv nmsDirectEntity = null;
        if (directEntity instanceof CraftEntity) {
            CraftEntity craftDirectEntity = (CraftEntity)directEntity;
            nmsDirectEntity = craftDirectEntity.getHandle();
        }
        foh vec3D = damageLocation == null ? null : CraftLocation.toVec3D(damageLocation);
        return new CraftDamageSource(new cci(holderDamageType, nmsDirectEntity, nmsCausingEntity, vec3D));
    }
}

