/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, dby entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ax());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ax());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().aY);
    }

    public boolean isLeashed() {
        return this.getHandle().ak_() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return this.getHandle().ak_().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        this.getHandle().x();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        this.getHandle().a_(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public dby getHandle() {
        return (dby)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(cee<?> boatType) {
        if (boatType == cee.aL || boatType == cee.aM) {
            return Boat.Type.OAK;
        }
        if (boatType == cee.o || boatType == cee.p) {
            return Boat.Type.BIRCH;
        }
        if (boatType == cee.c || boatType == cee.d) {
            return Boat.Type.ACACIA;
        }
        if (boatType == cee.y || boatType == cee.z) {
            return Boat.Type.CHERRY;
        }
        if (boatType == cee.ax || boatType == cee.ay) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == cee.bu || boatType == cee.bv) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == cee.I || boatType == cee.J) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == cee.aE || boatType == cee.aF) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == cee.l || boatType == cee.k) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(dby.a enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case dby.a.e -> Boat.Status.IN_AIR;
            case dby.a.d -> Boat.Status.ON_LAND;
            case dby.a.b -> Boat.Status.UNDER_WATER;
            case dby.a.c -> Boat.Status.UNDER_FLOWING_WATER;
            case dby.a.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(cee<?> boatType) {
        if (boatType == cee.bu || boatType == cee.bv) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == cee.o || boatType == cee.p) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == cee.ax || boatType == cee.ay) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == cee.c || boatType == cee.d) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == cee.I || boatType == cee.J) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

